/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail;

import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailConnectionBooleanQuery;
import org.eclipse.rdf4j.sail.SailConnectionGraphQuery;
import org.eclipse.rdf4j.sail.SailConnectionTupleQuery;
import org.eclipse.rdf4j.sail.SailConnectionUpdate;
import org.eclipse.rdf4j.sail.evaluation.SailTripleSource;

public class SailConnectionQueryPreparer
implements QueryPreparer {
    private final SailConnection con;
    private final boolean includeInferred;
    private final ValueFactory vf;
    private final TripleSource source;
    private ParserConfig parserConfig = new ParserConfig();

    public SailConnectionQueryPreparer(SailConnection con, boolean includeInferred, ValueFactory vf) {
        this.con = con;
        this.includeInferred = includeInferred;
        this.vf = vf;
        this.source = new SailTripleSource(con, includeInferred, vf);
    }

    public SailConnectionQueryPreparer(SailConnection con, boolean includeInferred, TripleSource source2) {
        this.con = con;
        this.includeInferred = includeInferred;
        this.source = source2;
        this.vf = source2.getValueFactory();
    }

    public void setParserConfig(ParserConfig parserConfig) {
        this.parserConfig = parserConfig;
    }

    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    @Override
    public BooleanQuery prepare(ParsedBooleanQuery askQuery) {
        SailConnectionBooleanQuery query = new SailConnectionBooleanQuery(askQuery, this.con);
        query.setIncludeInferred(this.includeInferred);
        return query;
    }

    @Override
    public TupleQuery prepare(ParsedTupleQuery tupleQuery) {
        SailConnectionTupleQuery query = new SailConnectionTupleQuery(tupleQuery, this.con);
        query.setIncludeInferred(this.includeInferred);
        return query;
    }

    @Override
    public GraphQuery prepare(ParsedGraphQuery graphQuery) {
        SailConnectionGraphQuery query = new SailConnectionGraphQuery(graphQuery, this.con, this.vf);
        query.setIncludeInferred(this.includeInferred);
        return query;
    }

    @Override
    public Update prepare(ParsedUpdate graphUpdate) {
        SailConnectionUpdate update2 = new SailConnectionUpdate(graphUpdate, this.con, this.vf, this.parserConfig);
        update2.setIncludeInferred(this.includeInferred);
        return update2;
    }

    @Override
    public TripleSource getTripleSource() {
        return this.source;
    }
}

