/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.optimizers;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;
import org.eclipse.rdf4j.sail.federation.algebra.NaryJoin;
import org.eclipse.rdf4j.sail.federation.algebra.OwnedTupleExpr;

public class PrepareOwnedTupleExpr
extends AbstractQueryModelVisitor<RepositoryException>
implements QueryOptimizer {
    private static final String END_BLOCK = "}\n";
    private OwnedTupleExpr owner;
    private String pattern;
    private TupleExpr patternNode;
    private Map<String, String> variables = new HashMap<String, String>();
    private boolean reduce;
    private boolean reduced;
    private boolean distinct;

    @Override
    public void optimize(TupleExpr query, Dataset dataset, BindingSet bindings) {
        try {
            query.visit(this);
        }
        catch (RepositoryException e2) {
            throw new UndeclaredThrowableException(e2);
        }
    }

    @Override
    public void meetOther(QueryModelNode node2) throws RepositoryException {
        if (node2 instanceof OwnedTupleExpr) {
            this.meetOwnedTupleExpr((OwnedTupleExpr)node2);
        } else if (node2 instanceof NaryJoin) {
            this.meetMultiJoin((NaryJoin)node2);
        } else {
            super.meetOther(node2);
        }
    }

    private void meetOwnedTupleExpr(OwnedTupleExpr node2) throws RepositoryException {
        OwnedTupleExpr before = this.owner;
        try {
            this.owner = node2;
            this.meetNode(node2);
            this.owner = null;
        }
        finally {
            this.owner = before;
        }
    }

    @Override
    protected void meetNode(QueryModelNode node2) throws RepositoryException {
        super.meetNode(node2);
        if (this.owner != null && this.patternNode != null && !(this.patternNode instanceof StatementPattern)) {
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT");
            if (this.distinct) {
                builder.append(" DISTINCT");
            } else if (this.reduced || this.reduce) {
                builder.append(" REDUCED");
            }
            boolean mapping = false;
            HashMap<String, String> bindings = new HashMap<String, String>();
            ProjectionElemList list = new ProjectionElemList();
            for (String name2 : this.patternNode.getBindingNames()) {
                mapping = this.addBindingNames(builder, mapping, bindings, list, name2);
            }
            builder.append("\nWHERE {\n").append(this.pattern).append("}");
            this.meetNodeLocal(builder, mapping, bindings, list);
        }
        this.reduced = false;
        this.distinct = false;
        this.pattern = null;
        this.patternNode = null;
    }

    private void meetNodeLocal(StringBuilder builder, boolean mapping, Map<String, String> bindings, ProjectionElemList list) throws RepositoryException, AssertionError {
        try {
            QueryModelNode parent = this.patternNode.getParentNode();
            if (parent instanceof OwnedTupleExpr) {
                OwnedTupleExpr owned = (OwnedTupleExpr)parent;
                this.meetNodeLocalParentOwned(builder, mapping, bindings, list, owned);
            } else {
                this.meetNodeLocalParentNotOwned(builder, mapping, bindings, list);
            }
        }
        catch (MalformedQueryException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    private void meetNodeLocalParentOwned(StringBuilder builder, boolean mapping, Map<String, String> bindings, ProjectionElemList list, OwnedTupleExpr owned) throws RepositoryException, MalformedQueryException {
        owned.prepare(QueryLanguage.SPARQL, builder.toString(), bindings);
        if (mapping) {
            Projection proj = new Projection(owned.clone(), list);
            owned.replaceWith(proj);
        }
    }

    private void meetNodeLocalParentNotOwned(StringBuilder builder, boolean mapping, Map<String, String> bindings, ProjectionElemList list) throws RepositoryException, MalformedQueryException {
        OwnedTupleExpr owned = new OwnedTupleExpr(this.owner.getOwner(), this.patternNode.clone());
        owned.prepare(QueryLanguage.SPARQL, builder.toString(), bindings);
        if (mapping) {
            Projection proj = new Projection(owned, list);
            this.patternNode.replaceWith(proj);
        } else {
            this.patternNode.replaceWith(owned);
        }
    }

    private boolean addBindingNames(StringBuilder builder, boolean alreadyMapping, Map<String, String> bindings, ProjectionElemList list, String name2) {
        boolean mapping = alreadyMapping;
        if (this.variables.containsKey(name2)) {
            String var = this.variables.get(name2);
            builder.append(" ?").append(var);
            bindings.put(name2, var);
            list.addElement(new ProjectionElem(var, name2));
            if (!name2.equals(var)) {
                mapping = true;
            }
        }
        return mapping;
    }

    @Override
    public void meet(Distinct node2) throws RepositoryException {
        boolean before = this.reduce;
        try {
            this.reduce = true;
            node2.getArg().visit(this);
        }
        finally {
            this.reduce = before;
        }
        if (this.patternNode == null) {
            return;
        }
        this.distinct = true;
        this.patternNode = node2;
    }

    @Override
    public void meet(Reduced node2) throws RepositoryException {
        boolean before = this.reduce;
        try {
            this.reduce = true;
            node2.getArg().visit(this);
        }
        finally {
            this.reduce = before;
        }
        if (this.patternNode == null) {
            return;
        }
        this.reduced = true;
        this.patternNode = node2;
    }

    @Override
    public void meet(Projection node2) throws RepositoryException {
        TupleExpr arg = node2.getArg();
        if (arg instanceof StatementPattern && arg.getBindingNames().equals(node2.getBindingNames())) {
            this.meetNode(node2);
        } else {
            arg.visit(this);
            if (this.patternNode == null) {
                return;
            }
            HashMap<String, String> map2 = new HashMap<String, String>();
            for (ProjectionElem e2 : node2.getProjectionElemList().getElements()) {
                String source2 = this.variables.get(e2.getSourceName());
                if (source2 == null) {
                    source2 = this.safe(e2.getSourceName());
                }
                map2.put(e2.getTargetName(), source2);
            }
            this.variables = map2;
            this.patternNode = node2;
        }
    }

    @Override
    public void meet(LeftJoin node2) throws RepositoryException {
        if (node2.getCondition() == null) {
            HashMap<String, String> vars = new HashMap<String, String>();
            StringBuilder builder = new StringBuilder();
            node2.getLeftArg().visit(this);
            if (this.patternNode != null) {
                builder.append(this.pattern);
                vars.putAll(this.variables);
                node2.getRightArg().visit(this);
                if (this.patternNode != null) {
                    builder.append("OPTIONAL {").append(this.pattern).append(END_BLOCK);
                    vars.putAll(this.variables);
                    this.variables = vars;
                    this.pattern = builder.toString();
                    this.patternNode = node2;
                }
            }
        } else {
            super.meet(node2);
        }
    }

    public void meetMultiJoin(NaryJoin node2) throws RepositoryException {
        HashMap<String, String> vars = new HashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        for (TupleExpr arg : node2.getArgs()) {
            arg.visit(this);
            if (this.patternNode == null && this.owner != null) {
                return;
            }
            if (this.patternNode == null) {
                builder = null;
                continue;
            }
            if (builder == null) continue;
            builder.append("{").append(this.pattern).append(END_BLOCK);
            vars.putAll(this.variables);
        }
        if (builder != null) {
            this.variables = vars;
            this.pattern = builder.toString();
            this.patternNode = node2;
        }
    }

    @Override
    public void meet(Join node2) throws RepositoryException {
        HashMap<String, String> vars = new HashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        node2.getLeftArg().visit(this);
        if (this.patternNode != null) {
            builder.append("{").append(this.pattern).append(END_BLOCK);
            vars.putAll(this.variables);
            node2.getRightArg().visit(this);
            if (this.patternNode != null) {
                builder.append("{").append(this.pattern).append(END_BLOCK);
                vars.putAll(this.variables);
                this.variables = vars;
                this.pattern = builder.toString();
                this.patternNode = node2;
            }
        }
    }

    @Override
    public void meet(StatementPattern node2) throws RepositoryException {
        boolean ookay;
        StringBuilder builder = new StringBuilder();
        StatementPattern.Scope scope = node2.getScope();
        Var subj = node2.getSubjectVar();
        Var pred = node2.getPredicateVar();
        Var obj = node2.getObjectVar();
        Var ctx = node2.getContextVar();
        boolean cokay = ctx == null && scope.equals((Object)StatementPattern.Scope.DEFAULT_CONTEXTS) || ctx != null && scope.equals((Object)StatementPattern.Scope.NAMED_CONTEXTS);
        boolean sokay = !subj.hasValue() || subj.isAnonymous() || subj.getValue() instanceof IRI;
        boolean bl = ookay = !obj.hasValue() || obj.isAnonymous() || obj.getValue() instanceof IRI || obj.getValue() instanceof Literal;
        if (cokay && sokay && ookay) {
            this.variables.clear();
            if (ctx != null) {
                builder.append("GRAPH ");
                this.appendVar(builder, ctx.getName());
                builder.append(" {\n");
            }
            this.appendVar(builder, subj);
            this.appendVar(builder, pred);
            this.appendVar(builder, obj);
            builder.append(" .");
            this.appendFilter(builder, subj);
            this.appendFilter(builder, pred);
            this.appendFilter(builder, obj);
            if (ctx != null) {
                if (ctx.hasValue()) {
                    builder.append("\nFILTER sameTerm(");
                    this.appendVar(builder, ctx.getName());
                    builder.append(", ");
                    this.writeValue(builder, ctx.getValue());
                    builder.append(")\n");
                }
                builder.append("}");
            }
            this.pattern = builder.toString();
            this.patternNode = node2;
        } else {
            this.patternNode = null;
        }
    }

    private void appendVar(StringBuilder builder, Var var) {
        if (var.hasValue() && var.isAnonymous()) {
            Value value = var.getValue();
            this.writeValue(builder, value);
        } else {
            String varName = var.getName();
            this.appendVar(builder, varName);
        }
        builder.append(" ");
    }

    private void appendVar(StringBuilder builder, String varName) {
        builder.append("?");
        String name2 = this.safe(varName);
        builder.append(name2);
        this.variables.put(varName, name2);
    }

    private String safe(String name2) {
        return name2.replace('-', '_');
    }

    private void appendFilter(StringBuilder builder, Var var) {
        if (var.hasValue() && !var.isAnonymous()) {
            builder.append("\nFILTER sameTerm(");
            this.appendVar(builder, var.getName());
            builder.append(", ");
            this.writeValue(builder, var.getValue());
            builder.append(")");
        }
    }

    private void writeValue(StringBuilder builder, Value val2) {
        if (val2 instanceof Resource) {
            this.writeResource(builder, (Resource)val2);
        } else {
            this.writeLiteral(builder, (Literal)val2);
        }
    }

    private void writeResource(StringBuilder builder, Resource res) {
        if (res instanceof IRI) {
            this.writeURI(builder, (IRI)res);
        } else {
            this.writeBNode(builder, (BNode)res);
        }
    }

    private void writeURI(StringBuilder builder, IRI uri) {
        builder.append("<");
        builder.append(TurtleUtil.encodeURIString(uri.stringValue()));
        builder.append(">");
    }

    private void writeBNode(StringBuilder builder, BNode bNode) {
        builder.append("_:");
        builder.append(bNode.stringValue());
    }

    private void writeLiteral(StringBuilder builder, Literal lit) {
        String label = lit.getLabel();
        if (label.indexOf(10) > 0 || label.indexOf(13) > 0 || label.indexOf(9) > 0) {
            builder.append("\"\"\"");
            builder.append(TurtleUtil.encodeLongString(label));
            builder.append("\"\"\"");
        } else {
            builder.append("\"");
            builder.append(TurtleUtil.encodeString(label));
            builder.append("\"");
        }
        IRI datatype = lit.getDatatype();
        if (Literals.isLanguageLiteral(lit)) {
            builder.append("@");
            builder.append(lit.getLanguage().get());
        } else {
            builder.append("^^");
            this.writeURI(builder, datatype);
        }
    }
}

