/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.File;
import java.io.IOException;
import org.eclipse.rdf4j.sail.nativerdf.RecordCache;
import org.eclipse.rdf4j.sail.nativerdf.btree.BTree;
import org.eclipse.rdf4j.sail.nativerdf.btree.RecordComparator;
import org.eclipse.rdf4j.sail.nativerdf.btree.RecordIterator;

final class SortedRecordCache
extends RecordCache {
    private final BTree btree;

    public SortedRecordCache(File cacheDir, int recordSize, RecordComparator comparator2) throws IOException {
        this(cacheDir, recordSize, Long.MAX_VALUE, comparator2);
    }

    public SortedRecordCache(File cacheDir, int recordSize, long maxRecords, RecordComparator comparator2) throws IOException {
        super(maxRecords);
        this.btree = new BTree(cacheDir, "txncache", 4096, recordSize, comparator2);
    }

    @Override
    protected void storeRecordInternal(byte[] record) throws IOException {
        this.btree.insert(record);
    }

    @Override
    protected RecordIterator getRecordsInternal() {
        return this.btree.iterateAll();
    }

    @Override
    protected void clearInternal() throws IOException {
        this.btree.clear();
    }

    @Override
    public void discard() throws IOException {
        this.btree.delete();
    }
}

