/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.rdf4j.common.io.NioFile;

class TxnStatusFile {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final String FILE_NAME = "txn-status";
    private final NioFile nioFile;

    public TxnStatusFile(File dataDir) throws IOException {
        File statusFile = new File(dataDir, FILE_NAME);
        this.nioFile = new NioFile(statusFile, "rwd");
        if (this.nioFile.size() == 0L) {
            this.setTxnStatus(TxnStatus.NONE);
        }
    }

    public void close() throws IOException {
        this.nioFile.close();
    }

    public void setTxnStatus(TxnStatus txnStatus) throws IOException {
        byte[] bytes2 = txnStatus.name().getBytes(US_ASCII);
        this.nioFile.truncate(bytes2.length);
        this.nioFile.writeBytes(bytes2, 0L);
    }

    public TxnStatus getTxnStatus() throws IOException {
        byte[] bytes2 = this.nioFile.readBytes(0L, (int)this.nioFile.size());
        String s = new String(bytes2, US_ASCII);
        try {
            return TxnStatus.valueOf(s);
        }
        catch (IllegalArgumentException e2) {
            s = new String(bytes2);
            try {
                return TxnStatus.valueOf(s);
            }
            catch (IllegalArgumentException e22) {
                return TxnStatus.UNKNOWN;
            }
        }
    }

    public static enum TxnStatus {
        NONE,
        ACTIVE,
        COMMITTING,
        ROLLING_BACK,
        UNKNOWN;

    }
}

