/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;

public class BeanAsArraySerializer
extends BeanSerializerBase {
    private static final long serialVersionUID = 1L;
    protected final BeanSerializerBase _defaultSerializer;

    public BeanAsArraySerializer(BeanSerializerBase src) {
        super(src, (ObjectIdWriter)null);
        this._defaultSerializer = src;
    }

    protected BeanAsArraySerializer(BeanSerializerBase src, String[] toIgnore) {
        super(src, toIgnore);
        this._defaultSerializer = src;
    }

    protected BeanAsArraySerializer(BeanSerializerBase src, ObjectIdWriter oiw, Object filterId) {
        super(src, oiw, filterId);
        this._defaultSerializer = src;
    }

    @Override
    public JsonSerializer<Object> unwrappingSerializer(NameTransformer transformer) {
        return this._defaultSerializer.unwrappingSerializer(transformer);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return false;
    }

    @Override
    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return this._defaultSerializer.withObjectIdWriter(objectIdWriter);
    }

    @Override
    public BeanSerializerBase withFilterId(Object filterId) {
        return new BeanAsArraySerializer((BeanSerializerBase)this, this._objectIdWriter, filterId);
    }

    @Override
    protected BeanAsArraySerializer withIgnorals(String[] toIgnore) {
        return new BeanAsArraySerializer((BeanSerializerBase)this, toIgnore);
    }

    @Override
    protected BeanSerializerBase asArraySerializer() {
        return this;
    }

    @Override
    public void serializeWithType(Object bean2, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        String typeStr;
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(bean2, gen, provider, typeSer);
            return;
        }
        String string2 = typeStr = this._typeId == null ? null : this._customTypeId(bean2);
        if (typeStr == null) {
            typeSer.writeTypePrefixForArray(bean2, gen);
        } else {
            typeSer.writeCustomTypePrefixForArray(bean2, gen, typeStr);
        }
        this.serializeAsArray(bean2, gen, provider);
        if (typeStr == null) {
            typeSer.writeTypeSuffixForArray(bean2, gen);
        } else {
            typeSer.writeCustomTypeSuffixForArray(bean2, gen, typeStr);
        }
    }

    @Override
    public final void serialize(Object bean2, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) && this.hasSingleElement(provider)) {
            this.serializeAsArray(bean2, gen, provider);
            return;
        }
        gen.writeStartArray();
        gen.setCurrentValue(bean2);
        this.serializeAsArray(bean2, gen, provider);
        gen.writeEndArray();
    }

    private boolean hasSingleElement(SerializerProvider provider) {
        BeanPropertyWriter[] props = this._filteredProps != null && provider.getActiveView() != null ? this._filteredProps : this._props;
        return props.length == 1;
    }

    protected final void serializeAsArray(Object bean2, JsonGenerator gen, SerializerProvider provider) throws IOException {
        int i;
        BeanPropertyWriter[] props = this._filteredProps != null && provider.getActiveView() != null ? this._filteredProps : this._props;
        try {
            for (BeanPropertyWriter prop : props) {
                if (prop == null) {
                    gen.writeNull();
                    continue;
                }
                prop.serializeAsElement(bean2, gen, provider);
            }
        }
        catch (Exception e2) {
            String name2 = i == props.length ? "[anySetter]" : props[i].getName();
            this.wrapAndThrow(provider, (Throwable)e2, bean2, name2);
        }
        catch (StackOverflowError e3) {
            JsonMappingException mapE = JsonMappingException.from(gen, "Infinite recursion (StackOverflowError)", (Throwable)e3);
            String name3 = i == props.length ? "[anySetter]" : props[i].getName();
            mapE.prependPath(new JsonMappingException.Reference(bean2, name3));
            throw mapE;
        }
    }

    public String toString() {
        return "BeanAsArraySerializer for " + this.handledType().getName();
    }
}

