/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.standard.std40.StandardTokenizer40;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;
import org.apache.lucene.util.Version;

public final class CJKAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public CJKAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public CJKAnalyzer(CharArraySet stopwords) {
        super(stopwords);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Tokenizer source2 = this.getVersion().onOrAfter(Version.LUCENE_4_7_0) ? new StandardTokenizer() : new StandardTokenizer40();
        TokenFilter result = new CJKWidthFilter(source2);
        result = new LowerCaseFilter(result);
        result = new CJKBigramFilter(result);
        return new Analyzer.TokenStreamComponents(source2, new StopFilter(result, this.stopwords));
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = CJKAnalyzer.loadStopwordSet(false, CJKAnalyzer.class, CJKAnalyzer.DEFAULT_STOPWORD_FILE, "#");
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

