/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class FilterLeafReader
extends LeafReader {
    protected final LeafReader in;

    public static LeafReader unwrap(LeafReader reader2) {
        while (reader2 instanceof FilterLeafReader) {
            reader2 = ((FilterLeafReader)reader2).in;
        }
        return reader2;
    }

    public FilterLeafReader(LeafReader in) {
        if (in == null) {
            throw new NullPointerException("incoming LeafReader cannot be null");
        }
        this.in = in;
        in.registerParentReader(this);
    }

    @Override
    public void addCoreClosedListener(LeafReader.CoreClosedListener listener) {
        this.in.addCoreClosedListener(CoreClosedListenerWrapper.wrap(listener, this.getCoreCacheKey(), this.in.getCoreCacheKey()));
    }

    @Override
    public void removeCoreClosedListener(LeafReader.CoreClosedListener listener) {
        this.in.removeCoreClosedListener(CoreClosedListenerWrapper.wrap(listener, this.getCoreCacheKey(), this.in.getCoreCacheKey()));
    }

    @Override
    public Bits getLiveDocs() {
        this.ensureOpen();
        return this.in.getLiveDocs();
    }

    @Override
    public FieldInfos getFieldInfos() {
        return this.in.getFieldInfos();
    }

    @Override
    public Fields getTermVectors(int docID) throws IOException {
        this.ensureOpen();
        return this.in.getTermVectors(docID);
    }

    @Override
    public int numDocs() {
        return this.in.numDocs();
    }

    @Override
    public int maxDoc() {
        return this.in.maxDoc();
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.ensureOpen();
        this.in.document(docID, visitor);
    }

    @Override
    protected void doClose() throws IOException {
        this.in.close();
    }

    @Override
    public Fields fields() throws IOException {
        this.ensureOpen();
        return this.in.fields();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("FilterLeafReader(");
        buffer.append(this.in);
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        return this.in.getNumericDocValues(field);
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        return this.in.getBinaryDocValues(field);
    }

    @Override
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        return this.in.getSortedDocValues(field);
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        return this.in.getSortedNumericDocValues(field);
    }

    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        return this.in.getSortedSetDocValues(field);
    }

    @Override
    public NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        return this.in.getNormValues(field);
    }

    @Override
    public Bits getDocsWithField(String field) throws IOException {
        this.ensureOpen();
        return this.in.getDocsWithField(field);
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        this.in.checkIntegrity();
    }

    public LeafReader getDelegate() {
        return this.in;
    }

    private static class CoreClosedListenerWrapper
    implements LeafReader.CoreClosedListener {
        private final LeafReader.CoreClosedListener in;
        private final Object thisCoreKey;
        private final Object inCoreKey;

        public static LeafReader.CoreClosedListener wrap(LeafReader.CoreClosedListener listener, Object thisCoreKey, Object inCoreKey) {
            if (thisCoreKey == inCoreKey) {
                return listener;
            }
            return new CoreClosedListenerWrapper(listener, thisCoreKey, inCoreKey);
        }

        private CoreClosedListenerWrapper(LeafReader.CoreClosedListener in, Object thisCoreKey, Object inCoreKey) {
            this.in = in;
            this.thisCoreKey = thisCoreKey;
            this.inCoreKey = inCoreKey;
        }

        @Override
        public void onClose(Object ownerCoreCacheKey) throws IOException {
            assert (this.inCoreKey == ownerCoreCacheKey);
            this.in.onClose(this.thisCoreKey);
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != CoreClosedListenerWrapper.class) {
                return false;
            }
            CoreClosedListenerWrapper that = (CoreClosedListenerWrapper)obj;
            return this.in.equals(that.in) && this.thisCoreKey == that.thisCoreKey;
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.in, this.thisCoreKey);
        }
    }

    public static class FilterPostingsEnum
    extends PostingsEnum {
        protected final PostingsEnum in;

        public FilterPostingsEnum(PostingsEnum in) {
            if (in == null) {
                throw new NullPointerException("incoming PostingsEnum cannot be null");
            }
            this.in = in;
        }

        @Override
        public AttributeSource attributes() {
            return this.in.attributes();
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int freq() throws IOException {
            return this.in.freq();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.in.nextDoc();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.in.advance(target);
        }

        @Override
        public int nextPosition() throws IOException {
            return this.in.nextPosition();
        }

        @Override
        public int startOffset() throws IOException {
            return this.in.startOffset();
        }

        @Override
        public int endOffset() throws IOException {
            return this.in.endOffset();
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return this.in.getPayload();
        }

        @Override
        public long cost() {
            return this.in.cost();
        }
    }

    public static class FilterTermsEnum
    extends TermsEnum {
        protected final TermsEnum in;

        public FilterTermsEnum(TermsEnum in) {
            if (in == null) {
                throw new NullPointerException("incoming TermsEnum cannot be null");
            }
            this.in = in;
        }

        @Override
        public AttributeSource attributes() {
            return this.in.attributes();
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            return this.in.seekCeil(text);
        }

        @Override
        public void seekExact(long ord) throws IOException {
            this.in.seekExact(ord);
        }

        @Override
        public BytesRef next() throws IOException {
            return this.in.next();
        }

        @Override
        public BytesRef term() throws IOException {
            return this.in.term();
        }

        @Override
        public long ord() throws IOException {
            return this.in.ord();
        }

        @Override
        public int docFreq() throws IOException {
            return this.in.docFreq();
        }

        @Override
        public long totalTermFreq() throws IOException {
            return this.in.totalTermFreq();
        }

        @Override
        public PostingsEnum postings(Bits liveDocs, PostingsEnum reuse, int flags) throws IOException {
            return this.in.postings(liveDocs, reuse, flags);
        }
    }

    public static class FilterTerms
    extends Terms {
        protected final Terms in;

        public FilterTerms(Terms in) {
            if (in == null) {
                throw new NullPointerException("incoming Terms cannot be null");
            }
            this.in = in;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return this.in.iterator();
        }

        @Override
        public long size() throws IOException {
            return this.in.size();
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            return this.in.getSumTotalTermFreq();
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return this.in.getSumDocFreq();
        }

        @Override
        public int getDocCount() throws IOException {
            return this.in.getDocCount();
        }

        @Override
        public boolean hasFreqs() {
            return this.in.hasFreqs();
        }

        @Override
        public boolean hasOffsets() {
            return this.in.hasOffsets();
        }

        @Override
        public boolean hasPositions() {
            return this.in.hasPositions();
        }

        @Override
        public boolean hasPayloads() {
            return this.in.hasPayloads();
        }

        @Override
        public Object getStats() throws IOException {
            return this.in.getStats();
        }
    }

    public static class FilterFields
    extends Fields {
        protected final Fields in;

        public FilterFields(Fields in) {
            if (in == null) {
                throw new NullPointerException("incoming Fields cannot be null");
            }
            this.in = in;
        }

        @Override
        public Iterator<String> iterator() {
            return this.in.iterator();
        }

        @Override
        public Terms terms(String field) throws IOException {
            return this.in.terms(field);
        }

        @Override
        public int size() {
            return this.in.size();
        }
    }
}

