/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;

public final class TermContext {
    public final IndexReaderContext topReaderContext;
    private final TermState[] states;
    private int docFreq;
    private long totalTermFreq;

    public TermContext(IndexReaderContext context) {
        assert (context != null && context.isTopLevel);
        this.topReaderContext = context;
        this.docFreq = 0;
        this.totalTermFreq = 0L;
        int len = context.leaves() == null ? 1 : context.leaves().size();
        this.states = new TermState[len];
    }

    public TermContext(IndexReaderContext context, TermState state, int ord, int docFreq, long totalTermFreq) {
        this(context);
        this.register(state, ord, docFreq, totalTermFreq);
    }

    public static TermContext build(IndexReaderContext context, Term term) throws IOException {
        assert (context != null && context.isTopLevel);
        String field = term.field();
        BytesRef bytes2 = term.bytes();
        TermContext perReaderTermState = new TermContext(context);
        for (LeafReaderContext ctx : context.leaves()) {
            TermsEnum termsEnum;
            Terms terms = ctx.reader().terms(field);
            if (terms == null || !(termsEnum = terms.iterator()).seekExact(bytes2)) continue;
            TermState termState = termsEnum.termState();
            perReaderTermState.register(termState, ctx.ord, termsEnum.docFreq(), termsEnum.totalTermFreq());
        }
        return perReaderTermState;
    }

    public void clear() {
        this.docFreq = 0;
        this.totalTermFreq = 0L;
        Arrays.fill(this.states, null);
    }

    public void register(TermState state, int ord, int docFreq, long totalTermFreq) {
        this.register(state, ord);
        this.accumulateStatistics(docFreq, totalTermFreq);
    }

    public void register(TermState state, int ord) {
        assert (state != null) : "state must not be null";
        assert (ord >= 0 && ord < this.states.length);
        assert (this.states[ord] == null) : "state for ord: " + ord + " already registered";
        this.states[ord] = state;
    }

    public void accumulateStatistics(int docFreq, long totalTermFreq) {
        this.docFreq += docFreq;
        this.totalTermFreq = this.totalTermFreq >= 0L && totalTermFreq >= 0L ? (this.totalTermFreq += totalTermFreq) : -1L;
    }

    public TermState get(int ord) {
        assert (ord >= 0 && ord < this.states.length);
        return this.states[ord];
    }

    public int docFreq() {
        return this.docFreq;
    }

    public long totalTermFreq() {
        return this.totalTermFreq;
    }

    public boolean hasOnlyRealTerms() {
        for (TermState termState : this.states) {
            if (termState == null || termState.isRealTerm()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TermContext\n");
        for (TermState termState : this.states) {
            sb.append("  state=");
            sb.append(termState.toString());
            sb.append('\n');
        }
        return sb.toString();
    }
}

