/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.util.Version;

public class UpgradeIndexMergePolicy
extends MergePolicy {
    protected final MergePolicy base;

    public UpgradeIndexMergePolicy(MergePolicy base) {
        this.base = base;
    }

    protected boolean shouldUpgradeSegment(SegmentCommitInfo si) {
        return !Version.LATEST.equals(si.info.getVersion());
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, IndexWriter writer2) throws IOException {
        return this.base.findMerges(null, segmentInfos, writer2);
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, IndexWriter writer2) throws IOException {
        HashMap<SegmentCommitInfo, Boolean> oldSegments = new HashMap<SegmentCommitInfo, Boolean>();
        for (SegmentCommitInfo si : segmentInfos) {
            Boolean v = segmentsToMerge.get(si);
            if (v == null || !this.shouldUpgradeSegment(si)) continue;
            oldSegments.put(si, v);
        }
        if (this.verbose(writer2)) {
            this.message("findForcedMerges: segmentsToUpgrade=" + oldSegments, writer2);
        }
        if (oldSegments.isEmpty()) {
            return null;
        }
        MergePolicy.MergeSpecification spec = this.base.findForcedMerges(segmentInfos, maxSegmentCount, oldSegments, writer2);
        if (spec != null) {
            for (MergePolicy.OneMerge om : spec.merges) {
                oldSegments.keySet().removeAll(om.segments);
            }
        }
        if (!oldSegments.isEmpty()) {
            if (this.verbose(writer2)) {
                this.message("findForcedMerges: " + this.base.getClass().getSimpleName() + " does not want to merge all old segments, merge remaining ones into new segment: " + oldSegments, writer2);
            }
            ArrayList<SegmentCommitInfo> newInfos = new ArrayList<SegmentCommitInfo>();
            for (SegmentCommitInfo si : segmentInfos) {
                if (!oldSegments.containsKey(si)) continue;
                newInfos.add(si);
            }
            if (spec == null) {
                spec = new MergePolicy.MergeSpecification();
            }
            spec.add(new MergePolicy.OneMerge(newInfos));
        }
        return spec;
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, IndexWriter writer2) throws IOException {
        return this.base.findForcedDeletesMerges(segmentInfos, writer2);
    }

    @Override
    public boolean useCompoundFile(SegmentInfos segments, SegmentCommitInfo newSegment, IndexWriter writer2) throws IOException {
        return this.base.useCompoundFile(segments, newSegment, writer2);
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "->" + this.base + "]";
    }

    private boolean verbose(IndexWriter writer2) {
        return writer2 != null && writer2.infoStream.isEnabled("UPGMP");
    }

    private void message(String message, IndexWriter writer2) {
        writer2.infoStream.message("UPGMP", message);
    }
}

