/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexSearcher;

public abstract class MultiFunction
extends ValueSource {
    protected final List<ValueSource> sources;

    public MultiFunction(List<ValueSource> sources) {
        this.sources = sources;
    }

    protected abstract String name();

    @Override
    public String description() {
        return MultiFunction.description(this.name(), this.sources);
    }

    public static boolean allExists(int doc2, FunctionValues ... values) {
        for (FunctionValues v : values) {
            if (v.exists(doc2)) continue;
            return false;
        }
        return true;
    }

    public static boolean anyExists(int doc2, FunctionValues ... values) {
        for (FunctionValues v : values) {
            if (!v.exists(doc2)) continue;
            return true;
        }
        return false;
    }

    public static String description(String name2, List<ValueSource> sources) {
        StringBuilder sb = new StringBuilder();
        sb.append(name2).append('(');
        boolean firstTime = true;
        for (ValueSource source2 : sources) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(',');
            }
            sb.append(source2);
        }
        sb.append(')');
        return sb.toString();
    }

    public static FunctionValues[] valsArr(List<ValueSource> sources, Map fcontext, LeafReaderContext readerContext) throws IOException {
        FunctionValues[] valsArr = new FunctionValues[sources.size()];
        int i = 0;
        for (ValueSource source2 : sources) {
            valsArr[i++] = source2.getValues(fcontext, readerContext);
        }
        return valsArr;
    }

    public static String toString(String name2, FunctionValues[] valsArr, int doc2) {
        StringBuilder sb = new StringBuilder();
        sb.append(name2).append('(');
        boolean firstTime = true;
        for (FunctionValues vals2 : valsArr) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(',');
            }
            sb.append(vals2.toString(doc2));
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        for (ValueSource source2 : this.sources) {
            source2.createWeight(context, searcher);
        }
    }

    @Override
    public int hashCode() {
        return this.sources.hashCode() + this.name().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        MultiFunction other = (MultiFunction)o;
        return this.sources.equals(other.sources);
    }

    public class Values
    extends FunctionValues {
        final FunctionValues[] valsArr;

        public Values(FunctionValues[] valsArr) {
            this.valsArr = valsArr;
        }

        @Override
        public String toString(int doc2) {
            return MultiFunction.toString(MultiFunction.this.name(), this.valsArr, doc2);
        }

        @Override
        public FunctionValues.ValueFiller getValueFiller() {
            return super.getValueFiller();
        }
    }
}

