/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.core.processors;

import java.util.Iterator;
import java.util.List;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.nodes.DeletedQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.MatchNoDocsQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl;

public class RemoveDeletedQueryNodesProcessor
extends QueryNodeProcessorImpl {
    @Override
    public QueryNode process(QueryNode queryTree) throws QueryNodeException {
        if ((queryTree = super.process(queryTree)) instanceof DeletedQueryNode && !(queryTree instanceof MatchNoDocsQueryNode)) {
            return new MatchNoDocsQueryNode();
        }
        return queryTree;
    }

    @Override
    protected QueryNode postProcessNode(QueryNode node2) throws QueryNodeException {
        if (!node2.isLeaf()) {
            List<QueryNode> children2 = node2.getChildren();
            boolean removeBoolean = false;
            if (children2 == null || children2.size() == 0) {
                removeBoolean = true;
            } else {
                removeBoolean = true;
                Iterator<QueryNode> it = children2.iterator();
                while (it.hasNext()) {
                    if (it.next() instanceof DeletedQueryNode) continue;
                    removeBoolean = false;
                    break;
                }
            }
            if (removeBoolean) {
                return new DeletedQueryNode();
            }
        }
        return node2;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children2) throws QueryNodeException {
        for (int i = 0; i < children2.size(); ++i) {
            if (!(children2.get(i) instanceof DeletedQueryNode)) continue;
            children2.remove(i--);
        }
        return children2;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node2) throws QueryNodeException {
        return node2;
    }
}

