/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;

public class BlockJoinComparatorSource
extends FieldComparatorSource {
    final Filter parentsFilter;
    final Sort parentSort;
    final Sort childSort;

    public BlockJoinComparatorSource(Filter parentsFilter, Sort parentSort) {
        this(parentsFilter, parentSort, new Sort(SortField.FIELD_DOC));
    }

    public BlockJoinComparatorSource(Filter parentsFilter, Sort parentSort, Sort childSort) {
        this.parentsFilter = parentsFilter;
        this.parentSort = parentSort;
        this.childSort = childSort;
    }

    public FieldComparator<Integer> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        final int[] parentSlots = new int[numHits];
        final int[] childSlots = new int[numHits];
        SortField[] parentFields = this.parentSort.getSort();
        final int[] parentReverseMul = new int[parentFields.length];
        final FieldComparator[] parentComparators = new FieldComparator[parentFields.length];
        for (int i = 0; i < parentFields.length; ++i) {
            parentReverseMul[i] = parentFields[i].getReverse() ? -1 : 1;
            parentComparators[i] = parentFields[i].getComparator(1, i);
        }
        SortField[] childFields = this.childSort.getSort();
        final int[] childReverseMul = new int[childFields.length];
        final FieldComparator[] childComparators = new FieldComparator[childFields.length];
        for (int i = 0; i < childFields.length; ++i) {
            childReverseMul[i] = childFields[i].getReverse() ? -1 : 1;
            childComparators[i] = childFields[i].getComparator(1, i);
        }
        return new FieldComparator<Integer>(){
            int bottomParent;
            int bottomChild;
            BitSet parentBits;
            LeafFieldComparator[] parentLeafComparators;
            LeafFieldComparator[] childLeafComparators;

            @Override
            public int compare(int slot1, int slot2) {
                try {
                    return this.compare(childSlots[slot1], parentSlots[slot1], childSlots[slot2], parentSlots[slot2]);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }

            @Override
            public void setTopValue(Integer value) {
                throw new UnsupportedOperationException("this comparator cannot be used with deep paging");
            }

            @Override
            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                int i;
                if (this.parentBits != null) {
                    throw new IllegalStateException("This comparator can only be used on a single segment");
                }
                DocIdSet parents2 = BlockJoinComparatorSource.this.parentsFilter.getDocIdSet(context, null);
                if (parents2 == null) {
                    throw new IllegalStateException("LeafReader " + context.reader() + " contains no parents!");
                }
                if (!(parents2 instanceof BitDocIdSet)) {
                    throw new IllegalStateException("parentFilter must return BitSet; got " + parents2);
                }
                this.parentBits = (BitSet)parents2.bits();
                this.parentLeafComparators = new LeafFieldComparator[parentComparators.length];
                for (i = 0; i < parentComparators.length; ++i) {
                    this.parentLeafComparators[i] = parentComparators[i].getLeafComparator(context);
                }
                this.childLeafComparators = new LeafFieldComparator[childComparators.length];
                for (i = 0; i < childComparators.length; ++i) {
                    this.childLeafComparators[i] = childComparators[i].getLeafComparator(context);
                }
                return new LeafFieldComparator(){

                    @Override
                    public int compareBottom(int doc2) throws IOException {
                        return this.compare(bottomChild, bottomParent, doc2, this.parent(doc2));
                    }

                    @Override
                    public int compareTop(int doc2) throws IOException {
                        throw new UnsupportedOperationException("this comparator cannot be used with deep paging");
                    }

                    @Override
                    public void copy(int slot, int doc2) throws IOException {
                        childSlots[slot] = doc2;
                        parentSlots[slot] = this.parent(doc2);
                    }

                    @Override
                    public void setBottom(int slot) {
                        bottomParent = parentSlots[slot];
                        bottomChild = childSlots[slot];
                    }

                    @Override
                    public void setScorer(Scorer scorer) {
                        for (LeafFieldComparator comp2 : parentLeafComparators) {
                            comp2.setScorer(scorer);
                        }
                        for (LeafFieldComparator comp2 : childLeafComparators) {
                            comp2.setScorer(scorer);
                        }
                    }
                };
            }

            @Override
            public Integer value(int slot) {
                throw new UnsupportedOperationException("filling sort field values is not yet supported");
            }

            int parent(int doc2) {
                return this.parentBits.nextSetBit(doc2);
            }

            int compare(int docID1, int parent1, int docID2, int parent2) throws IOException {
                if (parent1 == parent2) {
                    if (docID1 == parent1 || docID2 == parent2) {
                        return docID1 - docID2;
                    }
                    return this.compare(docID1, docID2, this.childLeafComparators, childReverseMul);
                }
                int cmp = this.compare(parent1, parent2, this.parentLeafComparators, parentReverseMul);
                if (cmp == 0) {
                    return parent1 - parent2;
                }
                return cmp;
            }

            int compare(int docID1, int docID2, LeafFieldComparator[] comparators, int[] reverseMul) throws IOException {
                for (int i = 0; i < comparators.length; ++i) {
                    comparators[i].copy(0, docID1);
                    comparators[i].setBottom(0);
                    int comp2 = reverseMul[i] * comparators[i].compareBottom(docID2);
                    if (comp2 == 0) continue;
                    return comp2;
                }
                return 0;
            }
        };
    }

    public String toString() {
        return "blockJoin(parentSort=" + this.parentSort + ",childSort=" + this.childSort + ")";
    }
}

