/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DocIdSetIterator;

public class DisjunctionDISIApproximation<Iter extends DocIdSetIterator>
extends DocIdSetIterator {
    final DisiPriorityQueue<Iter> subIterators;
    final long cost;

    public DisjunctionDISIApproximation(DisiPriorityQueue<Iter> subIterators) {
        this.subIterators = subIterators;
        long cost = 0L;
        for (DisiWrapper<Iter> w : subIterators) {
            cost += w.cost;
        }
        this.cost = cost;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    @Override
    public int docID() {
        return this.subIterators.top().doc;
    }

    @Override
    public int nextDoc() throws IOException {
        DisiWrapper<Iter> top = this.subIterators.top();
        int doc2 = top.doc;
        do {
            top.doc = top.approximation.nextDoc();
            top = this.subIterators.updateTop();
        } while (top.doc == doc2);
        return top.doc;
    }

    @Override
    public int advance(int target) throws IOException {
        DisiWrapper<Iter> top = this.subIterators.top();
        do {
            top.doc = top.approximation.advance(target);
            top = this.subIterators.updateTop();
        } while (top.doc < target);
        return top.doc;
    }
}

