/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.BinaryValueOperator;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.If;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.UnaryValueOperator;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.FunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.function.numeric.Rand;
import org.eclipse.rdf4j.query.algebra.evaluation.function.rdfterm.STRUUID;
import org.eclipse.rdf4j.query.algebra.evaluation.function.rdfterm.UUID;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantOptimizer
implements QueryOptimizer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final EvaluationStrategy strategy;

    public ConstantOptimizer(EvaluationStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        ConstantVisitor visitor = new ConstantVisitor();
        tupleExpr.visit(visitor);
        Set varsBefore = visitor.varNames;
        VarNameCollector varCollector = new VarNameCollector();
        tupleExpr.visit(varCollector);
        Set<String> varsAfter = varCollector.varNames;
        if (varsAfter.size() < varsBefore.size()) {
            varsBefore.removeAll(varsAfter);
            for (ProjectionElemList projElems : visitor.projElemLists) {
                for (ProjectionElem projElem : projElems.getElements()) {
                    String name2 = projElem.getSourceName();
                    if (!varsBefore.contains(name2)) continue;
                    UnaryTupleOperator proj = (UnaryTupleOperator)projElems.getParentNode();
                    Extension ext = new Extension(proj.getArg());
                    proj.setArg(ext);
                    Var lostVar = new Var(name2);
                    Value value = bindings.getValue(name2);
                    if (value != null) {
                        lostVar.setValue(value);
                    }
                    ext.addElement(new ExtensionElem(lostVar, name2));
                }
            }
        }
    }

    protected class VarNameCollector
    extends AbstractQueryModelVisitor<RuntimeException> {
        final Set<String> varNames = new HashSet<String>();

        protected VarNameCollector() {
        }

        @Override
        public void meet(Var var) {
            if (!var.isAnonymous()) {
                this.varNames.add(var.getName());
            }
        }
    }

    protected class ConstantVisitor
    extends VarNameCollector {
        final List<ProjectionElemList> projElemLists = new ArrayList<ProjectionElemList>();

        protected ConstantVisitor() {
        }

        @Override
        public void meet(ProjectionElemList projElems) {
            super.meet(projElems);
            this.projElemLists.add(projElems);
        }

        @Override
        public void meet(Or or2) {
            or2.visitChildren(this);
            try {
                if (this.isConstant(or2.getLeftArg()) && this.isConstant(or2.getRightArg())) {
                    boolean value = ConstantOptimizer.this.strategy.isTrue(or2, EmptyBindingSet.getInstance());
                    or2.replaceWith(new ValueConstant(BooleanLiteral.valueOf(value)));
                } else if (this.isConstant(or2.getLeftArg())) {
                    boolean leftIsTrue = ConstantOptimizer.this.strategy.isTrue(or2.getLeftArg(), EmptyBindingSet.getInstance());
                    if (leftIsTrue) {
                        or2.replaceWith(new ValueConstant(BooleanLiteral.TRUE));
                    } else {
                        or2.replaceWith(or2.getRightArg());
                    }
                } else if (this.isConstant(or2.getRightArg())) {
                    boolean rightIsTrue = ConstantOptimizer.this.strategy.isTrue(or2.getRightArg(), EmptyBindingSet.getInstance());
                    if (rightIsTrue) {
                        or2.replaceWith(new ValueConstant(BooleanLiteral.TRUE));
                    } else {
                        or2.replaceWith(or2.getLeftArg());
                    }
                }
            }
            catch (ValueExprEvaluationException e2) {
                ConstantOptimizer.this.logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", e2);
            }
            catch (QueryEvaluationException e3) {
                ConstantOptimizer.this.logger.error("Query evaluation exception caught", e3);
            }
        }

        @Override
        public void meet(And and2) {
            and2.visitChildren(this);
            try {
                if (this.isConstant(and2.getLeftArg()) && this.isConstant(and2.getRightArg())) {
                    boolean value = ConstantOptimizer.this.strategy.isTrue(and2, EmptyBindingSet.getInstance());
                    and2.replaceWith(new ValueConstant(BooleanLiteral.valueOf(value)));
                } else if (this.isConstant(and2.getLeftArg())) {
                    boolean leftIsTrue = ConstantOptimizer.this.strategy.isTrue(and2.getLeftArg(), EmptyBindingSet.getInstance());
                    if (leftIsTrue) {
                        and2.replaceWith(and2.getRightArg());
                    } else {
                        and2.replaceWith(new ValueConstant(BooleanLiteral.FALSE));
                    }
                } else if (this.isConstant(and2.getRightArg())) {
                    boolean rightIsTrue = ConstantOptimizer.this.strategy.isTrue(and2.getRightArg(), EmptyBindingSet.getInstance());
                    if (rightIsTrue) {
                        and2.replaceWith(and2.getLeftArg());
                    } else {
                        and2.replaceWith(new ValueConstant(BooleanLiteral.FALSE));
                    }
                }
            }
            catch (ValueExprEvaluationException e2) {
                ConstantOptimizer.this.logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", e2);
            }
            catch (QueryEvaluationException e3) {
                ConstantOptimizer.this.logger.error("Query evaluation exception caught", e3);
            }
        }

        @Override
        protected void meetBinaryValueOperator(BinaryValueOperator binaryValueOp) {
            super.meetBinaryValueOperator(binaryValueOp);
            if (this.isConstant(binaryValueOp.getLeftArg()) && this.isConstant(binaryValueOp.getRightArg())) {
                try {
                    Value value = ConstantOptimizer.this.strategy.evaluate(binaryValueOp, EmptyBindingSet.getInstance());
                    binaryValueOp.replaceWith(new ValueConstant(value));
                }
                catch (ValueExprEvaluationException e2) {
                    ConstantOptimizer.this.logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", e2);
                }
                catch (QueryEvaluationException e3) {
                    ConstantOptimizer.this.logger.error("Query evaluation exception caught", e3);
                }
            }
        }

        @Override
        protected void meetUnaryValueOperator(UnaryValueOperator unaryValueOp) {
            super.meetUnaryValueOperator(unaryValueOp);
            if (this.isConstant(unaryValueOp.getArg())) {
                try {
                    Value value = ConstantOptimizer.this.strategy.evaluate(unaryValueOp, EmptyBindingSet.getInstance());
                    unaryValueOp.replaceWith(new ValueConstant(value));
                }
                catch (ValueExprEvaluationException e2) {
                    ConstantOptimizer.this.logger.debug("Failed to evaluate UnaryValueOperator with a constant argument", e2);
                }
                catch (QueryEvaluationException e3) {
                    ConstantOptimizer.this.logger.error("Query evaluation exception caught", e3);
                }
            }
        }

        @Override
        public void meet(FunctionCall functionCall) {
            super.meet(functionCall);
            List<ValueExpr> args = functionCall.getArgs();
            if (args.size() == 0) {
                if (!this.isConstantZeroArgFunction(functionCall)) {
                    return;
                }
            } else {
                for (ValueExpr arg : args) {
                    if (this.isConstant(arg)) continue;
                    return;
                }
            }
            try {
                Value value = ConstantOptimizer.this.strategy.evaluate(functionCall, EmptyBindingSet.getInstance());
                functionCall.replaceWith(new ValueConstant(value));
            }
            catch (ValueExprEvaluationException e2) {
                ConstantOptimizer.this.logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", e2);
            }
            catch (QueryEvaluationException e3) {
                ConstantOptimizer.this.logger.error("Query evaluation exception caught", e3);
            }
        }

        private boolean isConstantZeroArgFunction(FunctionCall functionCall) {
            Function function = (Function)FunctionRegistry.getInstance().get(functionCall.getURI()).orElseThrow(() -> new QueryEvaluationException("Unable to find function with the URI: " + functionCall.getURI()));
            return !(function instanceof Rand) && !(function instanceof UUID) && !(function instanceof STRUUID);
        }

        @Override
        public void meet(Bound bound) {
            super.meet(bound);
            if (bound.getArg().hasValue()) {
                bound.replaceWith(new ValueConstant(BooleanLiteral.TRUE));
            }
        }

        @Override
        public void meet(If node2) {
            super.meet(node2);
            if (this.isConstant(node2.getCondition())) {
                try {
                    if (ConstantOptimizer.this.strategy.isTrue(node2.getCondition(), EmptyBindingSet.getInstance())) {
                        node2.replaceWith(node2.getResult());
                    } else {
                        node2.replaceWith(node2.getAlternative());
                    }
                }
                catch (ValueExprEvaluationException e2) {
                    ConstantOptimizer.this.logger.debug("Failed to evaluate UnaryValueOperator with a constant argument", e2);
                }
                catch (QueryEvaluationException e3) {
                    ConstantOptimizer.this.logger.error("Query evaluation exception caught", e3);
                }
            }
        }

        @Override
        public void meet(Regex node2) {
            super.meetNode(node2);
            if (this.isConstant(node2.getArg()) && this.isConstant(node2.getPatternArg()) && this.isConstant(node2.getFlagsArg())) {
                try {
                    Value value = ConstantOptimizer.this.strategy.evaluate(node2, EmptyBindingSet.getInstance());
                    node2.replaceWith(new ValueConstant(value));
                }
                catch (ValueExprEvaluationException e2) {
                    ConstantOptimizer.this.logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", e2);
                }
                catch (QueryEvaluationException e3) {
                    ConstantOptimizer.this.logger.error("Query evaluation exception caught", e3);
                }
            }
        }

        private boolean isConstant(ValueExpr expr) {
            return expr instanceof ValueConstant || expr instanceof Var && ((Var)expr).hasValue();
        }
    }
}

