/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.AggregateOperator;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;

public class ExtensionIterator
extends ConvertingIteration<BindingSet, BindingSet, QueryEvaluationException> {
    private final Extension extension;
    private final EvaluationStrategy strategy;

    public ExtensionIterator(Extension extension, CloseableIteration<BindingSet, QueryEvaluationException> iter, EvaluationStrategy strategy) throws QueryEvaluationException {
        super(iter);
        this.extension = extension;
        this.strategy = strategy;
    }

    @Override
    public BindingSet convert(BindingSet sourceBindings) throws QueryEvaluationException {
        QueryBindingSet targetBindings = new QueryBindingSet(sourceBindings);
        for (ExtensionElem extElem : this.extension.getElements()) {
            ValueExpr expr = extElem.getExpr();
            if (expr instanceof AggregateOperator) continue;
            try {
                Value targetValue = this.strategy.evaluate(extElem.getExpr(), (BindingSet)targetBindings);
                if (targetValue == null) continue;
                targetBindings.setBinding(extElem.getName(), targetValue);
            }
            catch (ValueExprEvaluationException valueExprEvaluationException) {}
        }
        return targetBindings;
    }
}

