/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;

public class MathUtil {
    public static final int DEFAULT_DECIMAL_EXPANSION_SCALE = 24;
    private static int decimalExpansionScale = 24;

    public static Literal compute(Literal leftLit, Literal rightLit, MathExpr.MathOp op) throws ValueExprEvaluationException {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        IRI leftDatatype = leftLit.getDatatype();
        IRI rightDatatype = rightLit.getDatatype();
        if (!XMLDatatypeUtil.isNumericDatatype(leftDatatype)) {
            throw new ValueExprEvaluationException("Not a number: " + leftLit);
        }
        if (!XMLDatatypeUtil.isNumericDatatype(rightDatatype)) {
            throw new ValueExprEvaluationException("Not a number: " + rightLit);
        }
        IRI commonDatatype = leftDatatype.equals(XMLSchema.DOUBLE) || rightDatatype.equals(XMLSchema.DOUBLE) ? XMLSchema.DOUBLE : (leftDatatype.equals(XMLSchema.FLOAT) || rightDatatype.equals(XMLSchema.FLOAT) ? XMLSchema.FLOAT : (leftDatatype.equals(XMLSchema.DECIMAL) || rightDatatype.equals(XMLSchema.DECIMAL) ? XMLSchema.DECIMAL : (op == MathExpr.MathOp.DIVIDE ? XMLSchema.DECIMAL : XMLSchema.INTEGER)));
        try {
            if (commonDatatype.equals(XMLSchema.DOUBLE)) {
                double left2 = leftLit.doubleValue();
                double right2 = rightLit.doubleValue();
                switch (op) {
                    case PLUS: {
                        return vf.createLiteral(left2 + right2);
                    }
                    case MINUS: {
                        return vf.createLiteral(left2 - right2);
                    }
                    case MULTIPLY: {
                        return vf.createLiteral(left2 * right2);
                    }
                    case DIVIDE: {
                        return vf.createLiteral(left2 / right2);
                    }
                }
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)op));
            }
            if (commonDatatype.equals(XMLSchema.FLOAT)) {
                float left3 = leftLit.floatValue();
                float right3 = rightLit.floatValue();
                switch (op) {
                    case PLUS: {
                        return vf.createLiteral(left3 + right3);
                    }
                    case MINUS: {
                        return vf.createLiteral(left3 - right3);
                    }
                    case MULTIPLY: {
                        return vf.createLiteral(left3 * right3);
                    }
                    case DIVIDE: {
                        return vf.createLiteral(left3 / right3);
                    }
                }
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)op));
            }
            if (commonDatatype.equals(XMLSchema.DECIMAL)) {
                BigDecimal left4 = leftLit.decimalValue();
                BigDecimal right4 = rightLit.decimalValue();
                switch (op) {
                    case PLUS: {
                        return vf.createLiteral(left4.add(right4));
                    }
                    case MINUS: {
                        return vf.createLiteral(left4.subtract(right4));
                    }
                    case MULTIPLY: {
                        return vf.createLiteral(left4.multiply(right4));
                    }
                    case DIVIDE: {
                        BigDecimal result = null;
                        try {
                            result = left4.divide(right4, MathContext.UNLIMITED);
                        }
                        catch (ArithmeticException e2) {
                            result = left4.setScale(MathUtil.getDecimalExpansionScale(), RoundingMode.HALF_UP).divide(right4, RoundingMode.HALF_UP);
                        }
                        return vf.createLiteral(result);
                    }
                }
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)op));
            }
            BigInteger left5 = leftLit.integerValue();
            BigInteger right5 = rightLit.integerValue();
            switch (op) {
                case PLUS: {
                    return vf.createLiteral(left5.add(right5));
                }
                case MINUS: {
                    return vf.createLiteral(left5.subtract(right5));
                }
                case MULTIPLY: {
                    return vf.createLiteral(left5.multiply(right5));
                }
                case DIVIDE: {
                    throw new RuntimeException("Integer divisions should be processed as decimal divisions");
                }
            }
            throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)op));
        }
        catch (NumberFormatException e3) {
            throw new ValueExprEvaluationException(e3);
        }
        catch (ArithmeticException e4) {
            throw new ValueExprEvaluationException(e4);
        }
    }

    public static int getDecimalExpansionScale() {
        return decimalExpansionScale;
    }

    public static void setDecimalExpansionScale(int decimalExpansionScale) {
        MathUtil.decimalExpansionScale = decimalExpansionScale;
    }
}

