/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.serql;

import org.eclipse.rdf4j.common.text.StringUtil;

public class SeRQLUtil {
    public static String encodeString(String s) {
        s = StringUtil.gsub("\\", "\\\\", s);
        s = StringUtil.gsub("\t", "\\t", s);
        s = StringUtil.gsub("\n", "\\n", s);
        s = StringUtil.gsub("\r", "\\r", s);
        s = StringUtil.gsub("\b", "\\b", s);
        s = StringUtil.gsub("\f", "\\f", s);
        s = StringUtil.gsub("\"", "\\\"", s);
        return s;
    }

    public static String decodeString(String s) {
        int backSlashIdx = s.indexOf(92);
        if (backSlashIdx == -1) {
            return s;
        }
        int startIdx = 0;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength);
        while (backSlashIdx != -1) {
            String xx;
            sb.append(s.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            char c = s.charAt(backSlashIdx + 1);
            if (c == 't') {
                sb.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                sb.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                sb.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'b') {
                sb.append('\b');
                startIdx = backSlashIdx + 2;
            } else if (c == 'f') {
                sb.append('\f');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                sb.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                sb.append('\\');
                startIdx = backSlashIdx + 2;
            } else if (c == 'u') {
                if (backSlashIdx + 5 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 6);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 6;
                }
                catch (NumberFormatException e2) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\u" + xx + "' in: " + s);
                }
            } else if (c == 'U') {
                if (backSlashIdx + 9 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 10);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 10;
                }
                catch (NumberFormatException e3) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\U" + xx + "' in: " + s);
                }
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            backSlashIdx = s.indexOf(92, startIdx);
        }
        sb.append(s.substring(startIdx));
        return sb.toString();
    }
}

