/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.dataset;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.RepositoryConnectionWrapper;
import org.eclipse.rdf4j.repository.dataset.DatasetBooleanQuery;
import org.eclipse.rdf4j.repository.dataset.DatasetGraphQuery;
import org.eclipse.rdf4j.repository.dataset.DatasetRepository;
import org.eclipse.rdf4j.repository.dataset.DatasetTupleQuery;
import org.eclipse.rdf4j.repository.sail.SailBooleanQuery;
import org.eclipse.rdf4j.repository.sail.SailGraphQuery;
import org.eclipse.rdf4j.repository.sail.SailQuery;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailTupleQuery;

public class DatasetRepositoryConnection
extends RepositoryConnectionWrapper {
    private DatasetRepository repository;
    private SailRepositoryConnection delegate;

    public DatasetRepositoryConnection(DatasetRepository repository2, SailRepositoryConnection delegate) {
        super(repository2, delegate);
        this.repository = repository2;
        this.delegate = delegate;
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.wrap(this.delegate.prepareBooleanQuery(ql, query, baseURI));
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.wrap(this.delegate.prepareGraphQuery(ql, query, baseURI));
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.wrap(this.delegate.prepareQuery(ql, query, baseURI));
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.wrap(this.delegate.prepareTupleQuery(ql, query, baseURI));
    }

    void loadDataset(Dataset datasets) throws QueryEvaluationException {
        try {
            if (datasets == null) {
                return;
            }
            for (IRI dataset : datasets.getDefaultGraphs()) {
                this.repository.loadDataset(new URL(dataset.toString()), dataset, this.getParserConfig());
            }
            for (IRI dataset : datasets.getNamedGraphs()) {
                this.repository.loadDataset(new URL(dataset.toString()), dataset, this.getParserConfig());
            }
        }
        catch (MalformedURLException e2) {
            throw new QueryEvaluationException(e2);
        }
        catch (RepositoryException e3) {
            throw new QueryEvaluationException(e3);
        }
    }

    private Query wrap(SailQuery q) {
        if (q instanceof SailBooleanQuery) {
            return this.wrap((SailBooleanQuery)q);
        }
        if (q instanceof SailGraphQuery) {
            return this.wrap((SailGraphQuery)q);
        }
        if (q instanceof SailTupleQuery) {
            return this.wrap((SailTupleQuery)q);
        }
        throw new IllegalArgumentException(q.getClass().getSimpleName() + " not supported on DatasetRepository");
    }

    private BooleanQuery wrap(SailBooleanQuery q) {
        return new DatasetBooleanQuery(this, q);
    }

    private GraphQuery wrap(SailGraphQuery q) {
        return new DatasetGraphQuery(this, q);
    }

    private TupleQuery wrap(SailTupleQuery q) {
        return new DatasetTupleQuery(this, q);
    }
}

