/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.evaluation;

import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.sail.federation.evaluation.AlternativeCursor;
import org.eclipse.rdf4j.sail.federation.evaluation.FilterCursor;
import org.eclipse.rdf4j.sail.federation.evaluation.QueueCursor;

public class ParallelLeftJoinCursor
extends LookAheadIteration<BindingSet, QueryEvaluationException>
implements Runnable {
    private static final String LF_TAB = "\n\t";
    private final EvaluationStrategy strategy;
    private final LeftJoin join;
    private final Set<String> scopeBindingNames;
    private volatile Thread evaluationThread;
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private volatile CloseableIteration<BindingSet, QueryEvaluationException> rightIter;
    private volatile boolean closed;
    private final QueueCursor<CloseableIteration<BindingSet, QueryEvaluationException>> rightQueue = new QueueCursor(1024);

    public ParallelLeftJoinCursor(EvaluationStrategy strategy, LeftJoin join2, BindingSet bindings) throws QueryEvaluationException {
        this.strategy = strategy;
        this.join = join2;
        this.scopeBindingNames = join2.getBindingNames();
        this.leftIter = strategy.evaluate(join2.getLeftArg(), bindings);
    }

    @Override
    public void run() {
        this.evaluationThread = Thread.currentThread();
        try {
            ValueExpr condition = this.join.getCondition();
            while (!this.isClosed() && this.leftIter.hasNext()) {
                BindingSet leftBindings = (BindingSet)this.leftIter.next();
                this.addToRightQueue(condition, leftBindings);
            }
        }
        catch (RuntimeException e2) {
            this.rightQueue.toss(e2);
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.evaluationThread = null;
            this.rightQueue.done();
        }
    }

    private void addToRightQueue(ValueExpr condition, BindingSet leftBindings) throws QueryEvaluationException, InterruptedException {
        FilterCursor result = this.strategy.evaluate(this.join.getRightArg(), leftBindings);
        if (condition != null) {
            result = new FilterCursor(result, condition, this.scopeBindingNames, this.strategy);
        }
        SingletonIteration alt = new SingletonIteration(leftBindings);
        this.rightQueue.put(new AlternativeCursor<BindingSet>(result, alt));
    }

    @Override
    public BindingSet getNextElement() throws QueryEvaluationException {
        BindingSet result = null;
        CloseableIteration nextRightIter = this.rightIter;
        while (!this.isClosed() && (nextRightIter != null || this.rightQueue.hasNext())) {
            if (nextRightIter == null) {
                nextRightIter = this.rightIter = (CloseableIteration)this.rightQueue.next();
            }
            if (nextRightIter == null) continue;
            if (nextRightIter.hasNext()) {
                result = (BindingSet)nextRightIter.next();
                break;
            }
            nextRightIter.close();
            this.rightIter = null;
            nextRightIter = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleClose() throws QueryEvaluationException {
        this.closed = true;
        try {
            super.handleClose();
        }
        finally {
            try {
                Thread toCloseEvaluationThread = this.evaluationThread;
                if (toCloseEvaluationThread != null) {
                    toCloseEvaluationThread.interrupt();
                }
            }
            finally {
                try {
                    CloseableIteration<BindingSet, QueryEvaluationException> toCloseRightIter = this.rightIter;
                    this.rightIter = null;
                    if (toCloseRightIter != null) {
                        toCloseRightIter.close();
                    }
                }
                finally {
                    this.leftIter.close();
                }
            }
        }
    }

    public String toString() {
        String left2 = this.leftIter.toString().replace("\n", LF_TAB);
        CloseableIteration<BindingSet, QueryEvaluationException> nextRightIter = this.rightIter;
        String right2 = null == nextRightIter ? this.join.getRightArg().toString() : nextRightIter.toString();
        ValueExpr condition = this.join.getCondition();
        String filter2 = null == condition ? "" : condition.toString().trim().replace("\n", LF_TAB);
        return "ParallelLeftJoin " + filter2 + LF_TAB + left2 + LF_TAB + right2.replace("\n", LF_TAB);
    }
}

