/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.inferencer.fc;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnection;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DedupingInferencerConnection
extends InferencerConnectionWrapper {
    private static final int MAX_SIZE = 10000;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ValueFactory valueFactory;
    private Set<Statement> addedStmts;
    private int dedupCount;

    public DedupingInferencerConnection(InferencerConnection con, ValueFactory vf) {
        super(con);
        this.valueFactory = vf;
        this.addedStmts = this.createDedupBuffer();
    }

    private Set<Statement> createDedupBuffer() {
        return Collections.newSetFromMap(new LRUMap(10000));
    }

    @Override
    public boolean addInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 0) {
            Statement stmt = this.valueFactory.createStatement(subj, pred, obj);
            if (this.addedStmts.add(stmt)) {
                return super.addInferredStatement(subj, pred, obj, new Resource[0]);
            }
            ++this.dedupCount;
            return false;
        }
        return super.addInferredStatement(subj, pred, obj, contexts);
    }

    @Override
    public boolean removeInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        Statement stmt = this.valueFactory.createStatement(subj, pred, obj);
        this.addedStmts.remove(stmt);
        return super.removeInferredStatement(subj, pred, obj, contexts);
    }

    @Override
    public void clearInferred(Resource ... contexts) throws SailException {
        this.resetDedupBuffer();
        super.clearInferred(contexts);
    }

    @Override
    public void commit() throws SailException {
        super.commit();
        this.logger.debug("Added {} unique statements, deduped {}", (Object)this.addedStmts.size(), (Object)this.dedupCount);
        this.resetDedupBuffer();
    }

    @Override
    public void rollback() throws SailException {
        super.rollback();
        this.resetDedupBuffer();
    }

    private void resetDedupBuffer() {
        this.addedStmts = null;
        this.addedStmts = this.createDedupBuffer();
        this.dedupCount = 0;
    }

    static class LRUMap<K, V>
    extends LinkedHashMap<K, V> {
        final int maxSize;

        LRUMap(int maxSize) {
            super(maxSize, 0.75f, true);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            return this.size() > this.maxSize;
        }
    }
}

