/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.spin;

import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.model.vocabulary.SPIF;
import org.eclipse.rdf4j.model.vocabulary.SPIN;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.FunctionRegistry;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.spin.SpinParser;
import org.eclipse.rdf4j.spin.function.AskFunction;
import org.eclipse.rdf4j.spin.function.Concat;
import org.eclipse.rdf4j.spin.function.EvalFunction;
import org.eclipse.rdf4j.spin.function.spif.CanInvoke;
import org.eclipse.rdf4j.spin.function.spif.ConvertSpinRDFToString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpinFunctionInterpreter
implements QueryOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(SpinFunctionInterpreter.class);
    private final TripleSource tripleSource;
    private final SpinParser parser;
    private final FunctionRegistry functionRegistry;

    static void registerSpinParsingFunctions(SpinParser parser, FunctionRegistry functionRegistry) {
        if (!(functionRegistry.get(FN.CONCAT.toString()).get() instanceof Concat)) {
            functionRegistry.add(new Concat());
        }
        if (!functionRegistry.has(SPIN.EVAL_FUNCTION.toString())) {
            functionRegistry.add(new EvalFunction(parser));
        }
        if (!functionRegistry.has(SPIN.ASK_FUNCTION.toString())) {
            functionRegistry.add(new AskFunction(parser));
        }
        if (!functionRegistry.has(SPIF.CONVERT_SPIN_RDF_TO_STRING_FUNCTION.toString())) {
            functionRegistry.add(new ConvertSpinRDFToString(parser));
        }
        if (!functionRegistry.has(SPIF.CAN_INVOKE_FUNCTION.toString())) {
            functionRegistry.add(new CanInvoke(parser));
        }
    }

    public SpinFunctionInterpreter(SpinParser parser, TripleSource tripleSource, FunctionRegistry functionRegistry) {
        this.parser = parser;
        this.tripleSource = tripleSource;
        this.functionRegistry = functionRegistry;
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        try {
            tupleExpr.visit(new FunctionScanner());
        }
        catch (RDF4JException e2) {
            logger.warn("Failed to parse function");
        }
    }

    private class FunctionScanner
    extends AbstractQueryModelVisitor<RDF4JException> {
        ValueFactory vf;

        private FunctionScanner() {
            this.vf = SpinFunctionInterpreter.this.tripleSource.getValueFactory();
        }

        @Override
        public void meet(FunctionCall node2) throws RDF4JException {
            String name2 = node2.getURI();
            if (!SpinFunctionInterpreter.this.functionRegistry.has(name2)) {
                IRI funcUri = this.vf.createIRI(name2);
                Function f = SpinFunctionInterpreter.this.parser.parseFunction(funcUri, SpinFunctionInterpreter.this.tripleSource);
                SpinFunctionInterpreter.this.functionRegistry.add(f);
            }
            super.meet(node2);
        }
    }
}

