/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.ConditionalFormatRule;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.Handle;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.XLS.Cf;
import com.extentech.formats.XLS.Condfmt;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;

public class ConditionalFormatHandle
implements Handle {
    private Condfmt cndfmt = null;
    private WorkSheetHandle worksheet;

    public ConditionalFormatRule evaluate(CellHandle refcell) {
        ConditionalFormatRule[] rules = this.getRules();
        int i = 0;
        while (i < rules.length) {
            if (rules[i].evaluate(refcell)) {
                return rules[i];
            }
            ++i;
        }
        return null;
    }

    public ConditionalFormatRule[] getRules() {
        ArrayList cfs = this.cndfmt.getRules();
        ConditionalFormatRule[] rules = new ConditionalFormatRule[cfs.size()];
        int i = 0;
        while (i < cfs.size()) {
            ConditionalFormatRule cfr;
            rules[i] = cfr = new ConditionalFormatRule((Cf)cfs.get(i));
            ++i;
        }
        return rules;
    }

    protected ConditionalFormatHandle(Condfmt c, WorkSheetHandle workSheetHandle) {
        this.cndfmt = c;
        this.worksheet = workSheetHandle;
    }

    public WorkSheetHandle getWorkSheetHandle() {
        return this.worksheet;
    }

    public String getEncompassingRange() {
        int[] rowcols = this.cndfmt.getEncompassingRange();
        return ExcelTools.formatRangeRowCol(rowcols);
    }

    public String[] getAllAffectedRanges() {
        return this.cndfmt.getAllRanges();
    }

    public boolean contains(CellHandle cellHandle) {
        return this.cndfmt.contains(cellHandle.getIntLocation());
    }

    public void setRange(String range) {
        this.cndfmt.resetRange(range);
    }

    public boolean contains(String celladdy) {
        return this.cndfmt.contains(ExcelTools.getRowColFromString(celladdy));
    }

    public String getXML() {
        ConditionalFormatRule[] rules = this.getRules();
        StringBuffer xml = new StringBuffer();
        xml.append("<dataConditionalFormat");
        xml.append(" type=\"" + ConditionalFormatRule.VALUE_TYPE[rules[0].getConditionalFormatType()] + "\"");
        xml.append(" operator=\"" + ConditionalFormatRule.OPERATORS[rules[0].getTypeOperator()] + "\"");
        try {
            xml.append(" sqref=\"" + this.getEncompassingRange() + "\"");
        }
        catch (Exception e) {
            Logger.logErr("Problem getting range for ConditionalFormatHandle.getXML().", e);
        }
        xml.append(">");
        if (rules[0].getFirstCondition() != null) {
            xml.append("<formula1>");
            xml.append(rules[0].getFirstCondition());
            xml.append("</formula1>");
        }
        if (rules[0].getSecondCondition() != null) {
            xml.append("<formula2>");
            xml.append(rules[0].getSecondCondition());
            xml.append("</formula2>");
        }
        xml.append("</dataConditionalFormat>");
        return xml.toString();
    }

    public String toString() {
        ConditionalFormatRule[] rules = this.getRules();
        String ret = String.valueOf(this.getEncompassingRange()) + ": " + rules[0].getType() + " " + rules[0].getOperator();
        if (rules[0].getFormula1() != null) {
            ret = String.valueOf(ret) + " " + rules[0].getFormula1().getFormulaString().substring(1);
        }
        if (rules[0].getFormula2() != null) {
            ret = String.valueOf(ret) + " and " + rules[0].getFormula2().getFormulaString().substring(1);
        }
        return ret;
    }

    protected Condfmt getCndfmt() {
        return this.cndfmt;
    }

    protected void setCndfmt(Condfmt cndfmt) {
        this.cndfmt = cndfmt;
    }

    public void addCell(CellHandle cellHandle) {
        if (this.contains(cellHandle)) {
            return;
        }
        this.cndfmt.addLocation(cellHandle.getCellAddress());
    }

    public FormatHandle[] getFormats() {
        FormatHandle[] fmx = new FormatHandle[this.getCndfmt().getRules().size()];
        if (this.cndfmt.getFormatHandle() == null) {
            int cfxe = this.cndfmt.getCfxe();
            FormatHandle formatHandle = new FormatHandle(this.cndfmt, this.worksheet.wbh, cfxe, null);
        }
        int t = 0;
        while (t < fmx.length) {
            this.cndfmt.getFormatHandle().updateFromCF((Cf)this.getCndfmt().getRules().get(t), this.worksheet.wbh);
            fmx[t] = this.cndfmt.getFormatHandle();
            ++t;
        }
        return fmx;
    }
}

