/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.Cell;
import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.WorkBook;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.toolkit.Logger;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class DateConverter {
    private static final int MILLIS_DAY = 86400000;
    private static final int EXTRA_DAY = 60;
    private static Calendar calendar = Calendar.getInstance();
    private static boolean validate = false;

    public static Calendar getCalendar() {
        return (Calendar)calendar.clone();
    }

    public static void setCalendar(Calendar cal) {
        calendar = cal;
    }

    public static boolean getValidate() {
        return validate;
    }

    public static void setValidate(boolean validate) {
        DateConverter.validate = validate;
    }

    public static boolean isParseableDateString(String str) {
        if (str.indexOf(" ") > 0) {
            str = str.substring(0, str.indexOf(" "));
        }
        try {
            java.sql.Date d1 = java.sql.Date.valueOf(str);
            DateConverter.getXLSDateVal(d1);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static Date getDate(String str) {
        try {
            Timestamp d1 = Timestamp.valueOf(str);
            Calendar cal = (Calendar)calendar.clone();
            cal.setTime(d1);
            return cal.getTime();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static double getXLSDateVal(Calendar cal) {
        return DateConverter.getXLSDateVal(cal, DateFormat.LEGACY_1900);
    }

    public static double getXLSDateVal(Calendar cal, DateFormat format) {
        long millis = cal.getTimeInMillis();
        double days = (double)(millis += (long)(cal.get(15) + cal.get(16))) / 8.64E7;
        days += (double)format.getEpochDelta();
        if (format == DateFormat.LEGACY_1900 && days >= 60.0) {
            days += 1.0;
        }
        if (validate && (days < format.getLowerLimit() || days > format.getUpperLimit())) {
            throw new IllegalArgumentException("the given date is not supported by Excel");
        }
        return days;
    }

    public static double getXLSDateVal(Date date, DateFormat format) {
        Calendar cal = (Calendar)calendar.clone();
        cal.setTime(date);
        return DateConverter.getXLSDateVal(cal, format);
    }

    public static double getXLSDateVal(Date date) {
        return DateConverter.getXLSDateVal(date, DateFormat.LEGACY_1900);
    }

    public static Calendar getCalendarFromNumber(double date) {
        return DateConverter.getCalendarFromNumber(date, DateFormat.LEGACY_1900);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static Calendar getCalendarFromNumber(double date, DateFormat format) {
        Calendar cal;
        block4: {
            long l;
            int count;
            long offset;
            long millis;
            block3: {
                cal = DateConverter.getCalendar();
                double days = date;
                if (format == DateFormat.LEGACY_1900 && days > 60.0) {
                    days -= 1.0;
                }
                millis = Math.round((days -= (double)format.getEpochDelta()) * 8.64E7);
                cal.setTimeInMillis(millis);
                offset = 0L;
                count = 0;
                if (!true) break block3;
                l = offset;
                if (l == (offset = (long)(cal.get(15) + cal.get(16))) || count >= 3) break block4;
            }
            do {
                cal.setTimeInMillis(millis - offset);
                ++count;
                l = offset;
            } while (l != (offset = (long)(cal.get(15) + cal.get(16))) && count < 3);
        }
        return cal;
    }

    public static Date getDateFromNumber(double date) {
        return DateConverter.getCalendarFromNumber(date).getTime();
    }

    public static Date getDateFromNumber(Object number) {
        if (number instanceof Number) {
            return DateConverter.getDateFromNumber(((Number)number).doubleValue());
        }
        throw new ClassCastException("passed object was not a number");
    }

    public static Date getNonLocalizedDateFromNumber(Object number) {
        return DateConverter.getDateFromNumber(number);
    }

    public static Calendar getCalendarFromNumber(Object number) {
        if (number == null) {
            throw new ClassCastException("object cannot be converted to a date");
        }
        if (!(number instanceof Number)) {
            number = new Double(number.toString());
        }
        if (number instanceof Number) {
            return DateConverter.getCalendarFromNumber(((Number)number).doubleValue());
        }
        throw new ClassCastException("passed object was not a number");
    }

    public static Calendar getNonLocalizedCalendarFromNumber(Object number) {
        return DateConverter.getCalendarFromNumber(number);
    }

    public static Date getDateFromCell(CellHandle cell) {
        return DateConverter.getCalendarFromCell(cell).getTime();
    }

    public static Calendar getCalendarFromCellWithPrecision(Cell cell, int roundingCalendarField) {
        Calendar tmp = DateConverter.getCalendarFromCell(cell);
        GregorianCalendar newCalendar = new GregorianCalendar();
        newCalendar.set(1, tmp.get(1));
        newCalendar.set(2, tmp.get(2));
        newCalendar.set(5, tmp.get(5));
        newCalendar.set(11, tmp.get(11));
        if (roundingCalendarField == 10) {
            if (tmp.get(12) > 29) {
                newCalendar.set(11, tmp.get(11) + 1);
            }
            newCalendar.set(12, 0);
            newCalendar.set(13, 0);
            newCalendar.set(14, 0);
            return newCalendar;
        }
        newCalendar.set(12, tmp.get(12));
        if (roundingCalendarField == 12) {
            if (tmp.get(13) > 29) {
                newCalendar.set(12, tmp.get(12) + 1);
            }
            newCalendar.set(13, 0);
            newCalendar.set(14, 0);
            return newCalendar;
        }
        newCalendar.set(13, tmp.get(13));
        if (roundingCalendarField == 13) {
            if (tmp.get(14) > 499) {
                newCalendar.set(13, tmp.get(13) + 1);
            }
            newCalendar.set(14, 0);
            return newCalendar;
        }
        newCalendar.set(14, tmp.get(14));
        return newCalendar;
    }

    public static Calendar getCalendarFromCell(Cell cell) {
        double value;
        DateFormat format = DateFormat.LEGACY_1900;
        if (cell instanceof CellHandle) {
            CellHandle realCell = (CellHandle)cell;
            value = realCell.getDoubleVal();
            WorkBook book = realCell.getWorkBook();
            if (book != null) {
                format = book.getDateFormat();
            }
        } else {
            value = Double.parseDouble(cell.getVal().toString());
        }
        return DateConverter.getCalendarFromNumber(value, format);
    }

    public static boolean isDatePattern(String possibleDate) {
        if (possibleDate.indexOf("/") == -1) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(possibleDate, "/");
        return st.countTokens() == 3;
    }

    public static Calendar convertStringToCalendar(String dateStr) {
        if (!DateConverter.isDatePattern(dateStr)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(dateStr, "/");
        try {
            int y;
            int m = Integer.valueOf(st.nextToken()) - 1;
            int d = Integer.valueOf(st.nextToken());
            String s = st.nextToken();
            int sc = 0;
            int mn = 0;
            int h = 0;
            if (s.indexOf(" ") > -1) {
                int i = s.indexOf(" ");
                String time = s.substring(i + 1);
                s = s.substring(0, i);
                String[] timetokens = time.split(":");
                if (timetokens.length > 0) {
                    h = Integer.valueOf(timetokens[0]);
                }
                if (timetokens.length > 1) {
                    mn = Integer.valueOf(timetokens[1]);
                }
                if (timetokens.length > 2) {
                    sc = Integer.valueOf(timetokens[2]);
                }
            }
            if ((y = Integer.valueOf(s).intValue()) < 100) {
                y += 2000;
            }
            GregorianCalendar cdr = new GregorianCalendar(y, m, d, h, mn, sc);
            return cdr;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getFormattedDateVal(CellHandle cell) {
        if (!cell.isDate()) {
            return "Not a Date";
        }
        if (Double.isNaN(cell.getDoubleVal())) {
            return "";
        }
        Date cal = DateConverter.getDateFromCell(cell);
        FormatHandle f = cell.getFormatHandle();
        int pat = f.getFormatPatternId();
        switch (pat) {
            case 14: {
                WorkBookHandle.simpledateformat.applyPattern("MM/dd/yy");
                return WorkBookHandle.simpledateformat.format(cal);
            }
            case 15: {
                WorkBookHandle.simpledateformat.applyPattern("dd-MMM-yy");
                return WorkBookHandle.simpledateformat.format(cal);
            }
            case 16: {
                WorkBookHandle.simpledateformat.applyPattern("dd-MMM");
                return WorkBookHandle.simpledateformat.format(cal);
            }
            case 17: {
                WorkBookHandle.simpledateformat.applyPattern("MMM-yy");
                return WorkBookHandle.simpledateformat.format(cal);
            }
            case 22: {
                WorkBookHandle.simpledateformat.applyPattern("MM/dd/yy HH:mm");
                return WorkBookHandle.simpledateformat.format(cal);
            }
        }
        WorkBookHandle.simpledateformat.applyPattern("MM/dd/yyyy");
        return WorkBookHandle.simpledateformat.format(cal);
    }

    public static Date parseDate(String s, int pat) {
        if (s.equals("")) {
            return null;
        }
        try {
            switch (pat) {
                case 14: {
                    WorkBookHandle.simpledateformat.applyPattern("dd/MM/yy");
                    return WorkBookHandle.simpledateformat.parse(s);
                }
                case 15: {
                    WorkBookHandle.simpledateformat.applyPattern("dd-MMM-yy");
                    return WorkBookHandle.simpledateformat.parse(s);
                }
                case 16: {
                    WorkBookHandle.simpledateformat.applyPattern("dd-MMM");
                    return WorkBookHandle.simpledateformat.parse(s);
                }
                case 17: {
                    WorkBookHandle.simpledateformat.applyPattern("MMM-yy");
                    return WorkBookHandle.simpledateformat.parse(s);
                }
                case 22: {
                    WorkBookHandle.simpledateformat.applyPattern("MM/dd/yy HH:mm");
                    return WorkBookHandle.simpledateformat.parse(s);
                }
            }
            WorkBookHandle.simpledateformat.applyPattern("dd/MM/yyyy");
            return WorkBookHandle.simpledateformat.parse(s);
        }
        catch (Exception e) {
            Logger.logWarn("Failed to parse date " + s + " format pattern: " + pat);
            return Calendar.getInstance().getTime();
        }
    }

    public static Double calcDateValue(String dateString) {
        String[] formats = new String[]{"MM/dd/yyyy HH:mm:ss", "MM/dd/yy HH:mm:ss", "MM/dd/yy", "MM/dd/yyyy", "MM/d/yyyy HH:mm:ss", "MM/d/yy HH:mm:ss", "yy-M-d hh:mm:ss a", "yy-M-d HH:mm:ss", "yy-M-d hh:mm a", "yy-M-d HH:mm", "dd-M-yyyy hh:mm:ss a", "dd-M-yyyy HH:mm:ss", "dd-M-yyyy hh:mm a", "dd-M-yyyy HH:mm", "dd-MMM-yy hh:mm:ss a", "dd-MMM-yy HH:mm:ss", "dd-MMM-yy hh:mm a", "dd-MMM-yy HH:mm", "yyMMdd", "MM/d/yy", "MM/d/yyyy", "yyyy/MM/dd", "d-MMM-yy", "d-M-yy", "d-M-yyyy", "dd-MMM-yy", "dd-MMM-yyyy", "dd-M-yyyy", "dd-MM-yy", "dd-MM-yyyy", "d-MMM-yyyy", "d-M-yyyy", "d-MMM-yyyy", "d/MMM/yyyy", "M-yy", "MMM-yy", "M/d/yyyy", "M d, yyyy", "yyyy-MM-dd", "yy-M-d", "yyyy-MM-dd", "MMyy", "yyMM", "yyyyMMddHHmm", "yyyyMMddHHmmss", "yyMMddHHmmss", "MMDDHHmm", "MMMM dd, yyyy", "E, MMM d, yyyy", "E MMM dd, yyyy", "EE, MMM dd, yyyy", "E, MMMM d, yyyy", "E, MMMM dd, yyyy", "EE, MMMM dd, yyyy", "hh:mm:ss a", "HH:mm:ss", "hh:mm a", "HH:mm"};
        int i = 0;
        while (i < formats.length) {
            try {
                String ds = dateString;
                if (i == 32 || i == 33) {
                    GregorianCalendar calendar = new GregorianCalendar();
                    int curyear = calendar.get(1);
                    ds = i == 32 ? String.valueOf(dateString) + "-" + curyear : String.valueOf(dateString) + "/" + curyear;
                }
                WorkBookHandle.simpledateformat.applyLocalizedPattern(formats[i]);
                WorkBookHandle.simpledateformat.setLenient(false);
                Date d = WorkBookHandle.simpledateformat.parse(ds);
                return DateConverter.getXLSDateVal(d);
            }
            catch (Exception exception) {
                ++i;
            }
        }
        return null;
    }

    public static enum DateFormat {
        OOXML_1900(25569, -4346018.0, 2958465.9999884),
        LEGACY_1900(25568, 1.0, 2958465.9999884),
        LEGACY_1904(24107, 0.0, 2957003.9999884);

        private final int epoch_delta;
        private final double limit_lower;
        private final double limit_upper;

        private DateFormat(int delta, double min, double max) {
            this.epoch_delta = delta;
            this.limit_lower = min;
            this.limit_upper = max;
        }

        protected int getEpochDelta() {
            return this.epoch_delta;
        }

        public double getLowerLimit() {
            return this.limit_lower;
        }

        public double getUpperLimit() {
            return this.limit_upper;
        }
    }
}

