/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.Document;
import com.extentech.ExtenXLS.GetInfo;
import com.extentech.ExtenXLS.Handle;
import com.extentech.ExtenXLS.WorkBookException;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.LEO.LEOFile;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.TempFileManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class DocumentHandle
implements Document,
Handle,
Closeable {
    public static final int FORMAT_NATIVE = 0;
    protected int DEBUGLEVEL = 0;
    protected String name = null;
    protected File file;
    private Map<String, Object> props = new HashMap<String, Object>();
    private boolean streamingSheets = false;

    public DocumentHandle() {
    }

    public DocumentHandle(InputStream urlx) {
        Logger.logErr("DocumentHandle InputStream Constructor Not Implemented");
    }

    @Override
    public Object getProperty(String name) {
        return this.props.get(name);
    }

    @Override
    public void addProperty(String name, Object val) {
        this.props.put(name, val);
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.props);
    }

    public void setProperties(Map<String, Object> properties) {
        this.props = new HashMap<String, Object>();
        this.props.putAll(properties);
    }

    public static String getVersion() {
        return GetInfo.getVersion();
    }

    @Override
    public void setName(String nm) {
        this.name = nm;
    }

    public void setStreamingSheets(boolean streamSheets) {
        this.streamingSheets = streamSheets;
    }

    public void setFileName(String name) {
        this.file = new File(name).getAbsoluteFile();
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public static DocumentHandle getInstance(InputStream input) throws IOException {
        String headerString;
        BufferedInputStream bufferedStream = new BufferedInputStream(input);
        bufferedStream.mark(1028);
        byte[] headerBytes = new byte[512];
        int count = bufferedStream.read(headerBytes);
        bufferedStream.reset();
        if (LEOFile.checkIsLEO(headerBytes, count)) {
            LEOFile leo = new LEOFile(bufferedStream);
            if (leo.hasWorkBook()) {
                return new WorkBookHandle(leo);
            }
            throw new WorkBookException("input is LEO but no supported format detected", -1);
        }
        try {
            headerString = new String(headerBytes, 0, count, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("the JVM does not support UTF-8", e);
        }
        if (headerString.startsWith("PK")) {
            return new WorkBookHandle(bufferedStream);
        }
        if (headerString.indexOf(",") > -1 && headerString.indexOf(",") > -1) {
            WorkBookHandle book = new WorkBookHandle();
            try {
                WorkSheetHandle sheet = book.getWorkSheet(0);
                sheet.readCSV(new BufferedReader(new InputStreamReader(bufferedStream)));
                return book;
            }
            catch (Exception e) {
                throw new WorkBookException("Error encountered importing CSV: " + e.toString(), 11);
            }
        }
        throw new WorkBookException("unknown file format", -1);
    }

    public String getFileName() {
        return this.file != null ? this.file.getPath() : "New Document.doc";
    }

    @Override
    public void setDebugLevel(int level) {
        this.DEBUGLEVEL = level;
    }

    public int getDebugLevel() {
        return this.DEBUGLEVEL;
    }

    @Deprecated
    protected static File getFileFromURL(URL u) {
        try {
            File fx = TempFileManager.createTempFile("upload-" + System.currentTimeMillis(), ".tmp");
            URLConnection uc = u.openConnection();
            String contentType = uc.getContentType();
            int contentLength = uc.getContentLength();
            if (contentType.startsWith("text/") || contentLength == -1) {
                throw new IOException("This is not a binary file.");
            }
            InputStream raw = uc.getInputStream();
            BufferedInputStream in = new BufferedInputStream(raw);
            byte[] data = new byte[contentLength];
            int bytesRead = 0;
            int offset = 0;
            while (offset < contentLength) {
                bytesRead = ((InputStream)in).read(data, offset, data.length - offset);
                if (bytesRead == -1) break;
                offset += bytesRead;
            }
            ((InputStream)in).close();
            if (offset != contentLength) {
                throw new IOException("Only read " + offset + " bytes; Expected " + contentLength + " bytes");
            }
            FileOutputStream out = new FileOutputStream(fx);
            out.write(data);
            out.flush();
            out.close();
            return fx;
        }
        catch (Exception e) {
            Logger.logErr("Could not load WorkBook from URL: " + e.toString());
            return null;
        }
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "Untitled Document";
    }

    @Override
    public abstract void reset();

    public abstract int getFormat();

    public abstract String getFileExtension();

    @Override
    public abstract void write(OutputStream var1, int var2) throws IOException;

    @Override
    public void write(OutputStream dest) throws IOException {
        this.write(dest, 0);
    }

    @Override
    public void write(File file, int format) throws IOException {
        if (format > 100 && this.file != null) {
            OOXMLAdapter.refreshPassThroughFiles((WorkBookHandle)this);
        }
        if (file.exists()) {
            file.delete();
        }
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        this.write(stream, format);
        this.file = file;
        ((OutputStream)stream).flush();
        ((OutputStream)stream).close();
    }

    @Override
    public void write(File file) throws IOException {
        this.write(file, 0);
    }

    public String toString() {
        return this.getName();
    }
}

