/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.WorkBook;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.formats.XLS.ReferenceTracker;
import com.extentech.formats.XLS.formulas.CalculationException;
import com.extentech.formats.XLS.formulas.FormulaParser;
import com.extentech.formats.XLS.formulas.FunctionConstants;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgName;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.toolkit.Logger;
import java.util.Iterator;
import java.util.List;

public class FormulaHandle {
    private WorkBook bk;
    private Formula form;

    public static String[][] getSupportedFunctions() {
        return FunctionConstants.recArr;
    }

    public boolean setLocationLocked(String loc, boolean l) {
        int x = 0;
        if (l) {
            x = 1;
        }
        return this.form.setLocationPolicy(loc, x);
    }

    public boolean setLocationPolicy(String loc, int l) {
        return this.form.setLocationPolicy(loc, l);
    }

    protected FormulaHandle(Formula f, WorkBook book) {
        this.bk = book;
        this.form = f;
    }

    public String getCellAddress() {
        return this.form.getCellAddress();
    }

    public String getFormulaString() {
        return this.form.getFormulaString();
    }

    public String getStringVal() throws FunctionNotSupportedException {
        return this.form.getStringVal();
    }

    static Object sanitizeValue(Object val) {
        if (val instanceof CalculationException) {
            return ((CalculationException)val).getName();
        }
        return val;
    }

    public Object getVal() throws FunctionNotSupportedException {
        return FormulaHandle.sanitizeValue(this.form.calculateFormula());
    }

    public Object calculate() throws FunctionNotSupportedException {
        this.form.clearCachedValue();
        return FormulaHandle.sanitizeValue(this.form.calculate());
    }

    public void setFormula(String formulaString) throws FunctionNotSupportedException {
        this.form = FormulaParser.setFormula(this.form, formulaString, new int[]{this.form.getRowNumber(), this.form.getColNumber()});
    }

    public boolean evaluatesToString() {
        return this.form.calculateFormula() instanceof String;
    }

    public float getFloatVal() throws FunctionNotSupportedException {
        return this.form.getFloatVal();
    }

    public double getDoubleVal() throws FunctionNotSupportedException {
        return this.form.getDblVal();
    }

    public int getIntVal() throws FunctionNotSupportedException {
        return this.form.getIntVal();
    }

    public String[] getRanges() throws FormulaNotFoundException {
        Ptg[] locptgs = this.form.getCellRangePtgs();
        String[] ret = new String[locptgs.length];
        int x = 0;
        while (x < locptgs.length) {
            try {
                ret[x] = ((PtgRef)locptgs[x]).getLocationWithSheet();
            }
            catch (Exception e) {
                ret[x] = locptgs[x] instanceof PtgName ? ((PtgName)locptgs[x]).getLocation() : locptgs[x].getTextString();
            }
            ++x;
        }
        return ret;
    }

    public CellRange[] getCellRanges() throws FormulaNotFoundException {
        String[] crstrs = this.getRanges();
        CellRange[] crs = new CellRange[crstrs.length];
        int x = 0;
        while (x < crs.length) {
            crs[x] = new CellRange(crstrs[x], this.bk, true);
            try {
                crs[x].init();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++x;
        }
        return crs;
    }

    public boolean changeFormulaLocation(String formulaLoc, String newaddr) throws FormulaNotFoundException {
        List dx = this.form.getPtgsByLocation(formulaLoc);
        Iterator lx = dx.iterator();
        if (lx.hasNext()) {
            try {
                Ptg thisptg = (Ptg)lx.next();
                ReferenceTracker.updateAddressPerPolicy(thisptg, newaddr);
                this.form.setCachedValue(null);
                return true;
            }
            catch (Exception e) {
                Logger.logInfo("updating Formula reference failed:" + e.toString());
                return false;
            }
        }
        return true;
    }

    public boolean addCellToRange(String formulaLoc, CellHandle handle) throws FormulaNotFoundException {
        List dx = this.form.getPtgsByLocation(formulaLoc);
        Iterator lx = dx.iterator();
        boolean b = false;
        while (lx.hasNext()) {
            Ptg ptg = (Ptg)lx.next();
            if (ptg == null) {
                return false;
            }
            int[] formulaaddr = ExcelTools.getRangeRowCol(formulaLoc);
            String handleaddr = handle.getCellAddress();
            int[] celladdr = ExcelTools.getRowColFromString(handleaddr);
            if (celladdr[0] > formulaaddr[2]) {
                formulaaddr[2] = celladdr[0];
            }
            if (celladdr[0] < formulaaddr[0]) {
                formulaaddr[0] = celladdr[0];
            }
            if (celladdr[1] > formulaaddr[3]) {
                formulaaddr[3] = celladdr[1];
            }
            if (celladdr[1] < formulaaddr[1]) {
                formulaaddr[1] = celladdr[1];
            }
            String newaddr = ExcelTools.formatRange(formulaaddr);
            b = this.changeFormulaLocation(formulaLoc, newaddr);
        }
        return b;
    }

    public static void moveCellRefs(FormulaHandle fmh, int[] offsets) throws FormulaNotFoundException {
        String[] celladdys = fmh.getRanges();
        int x = 0;
        while (x < celladdys.length) {
            boolean relRow;
            String[] s = ExcelTools.stripSheetNameFromRange(celladdys[x]);
            String sh = s[0];
            String range = s[1];
            int rangeIdx = range.indexOf(":");
            String secondAddress = null;
            if (rangeIdx > -1) {
                secondAddress = range.substring(rangeIdx + 1);
                range = range.substring(0, rangeIdx);
            }
            int[] orig = ExcelTools.getRowColFromString(range);
            boolean relCol = !range.startsWith("$");
            boolean bl = relRow = range.length() <= 0 || range.substring(1).indexOf(36) <= -1;
            if (relRow) {
                orig[0] = orig[0] + offsets[0];
            }
            if (relCol) {
                orig[1] = orig[1] + offsets[1];
            }
            String newAddress = ExcelTools.formatLocation(orig, relRow, relCol);
            if (orig[0] < 0 || orig[1] < 0) {
                newAddress = "#REF!";
            }
            if (secondAddress != null) {
                orig = ExcelTools.getRowColFromString(secondAddress);
                relCol = !secondAddress.startsWith("$");
                boolean bl2 = relRow = secondAddress.length() <= 0 || secondAddress.substring(1).indexOf(36) <= -1;
                if (orig[0] >= 0 && relRow) {
                    orig[0] = orig[0] + offsets[0];
                }
                if (orig[1] >= 0 && relCol) {
                    orig[1] = orig[1] + offsets[1];
                }
                String newAddress1 = ExcelTools.formatLocation(orig, relRow, relCol);
                newAddress = String.valueOf(newAddress) + ":" + newAddress1;
            }
            if (sh != null) {
                newAddress = String.valueOf(sh) + "!" + newAddress;
            }
            if (!fmh.changeFormulaLocation(celladdys[x], newAddress)) {
                Logger.logErr("Could not change Formula Reference: " + celladdys[x] + " to: " + newAddress);
            }
            ++x;
        }
    }

    public String toString() {
        return String.valueOf(this.form.getCellAddress()) + ":" + this.form.getFormulaString();
    }

    public boolean isSharedFormula() {
        return this.form.isSharedFormula();
    }

    public boolean isArrayFormula() {
        return this.form.isArrayFormula();
    }

    public Formula getFormulaRec() {
        return this.form;
    }

    public boolean isErrorValue() {
        return this.form.calculateFormula() instanceof CalculationException;
    }

    public boolean getCalcAlways() {
        return this.form.getCalcAlways();
    }

    public void setCalcAlways(boolean fAlwaysCalc) {
        this.form.setCalcAlways(fAlwaysCalc);
    }

    public String getOOXML() {
        Object val;
        StringBuffer ooxml = new StringBuffer();
        try {
            val = this.getVal();
            if (val == null) {
                if (this.form.getWorkBook().getCalcMode() != 1) {
                    this.calculate();
                    val = this.getVal();
                } else {
                    val = new CalculationException(15);
                }
            } else if (val instanceof String && ((String)val).startsWith("#")) {
                val = new CalculationException(CalculationException.getErrorCode((String)val));
            }
        }
        catch (Exception e) {
            val = new CalculationException(15);
        }
        if (val == null) {
            Logger.logErr("FormulaHandle.getOOXML:  unexpected null encountered when calculating formula: " + this.getCellAddress());
        }
        if (val instanceof String) {
            ooxml.append(" t=\"str\"");
            val = OOXMLAdapter.stripNonAscii((String)val);
        } else if (val instanceof Boolean) {
            ooxml.append(" t=\"b\"");
            val = ((Boolean)val).booleanValue() ? "1" : "0";
        } else if (val instanceof Double) {
            ooxml.append(" t=\"n\"");
        } else if (val instanceof CalculationException) {
            ooxml.append(" t=\"e\"");
        }
        String fs = "=";
        try {
            fs = this.getFormulaString();
        }
        catch (Exception e) {
            Logger.logErr("FormulaHandle.getOOXML: error obtaining formula string: " + e.toString());
        }
        fs = OOXMLAdapter.stripNonAscii(fs).toString();
        if (!this.isArrayFormula()) {
            ooxml.append("><f");
            fs = fs.substring(1);
        } else if (this.form.getSheet().isArrayFormulaParent(this.getCellAddress())) {
            ooxml.append("><f");
            String refs = this.form.getSheet().getArrayRef(this.getCellAddress());
            if (fs.startsWith("{=")) {
                fs = fs.substring(2, fs.length() - 1);
            }
            ooxml.append(" t=\"array\"");
            ooxml.append(" ref=\"" + refs + "\"");
        } else {
            fs = null;
            ooxml.append(">");
        }
        if (this.isSharedFormula()) {
            // empty if block
        }
        if (this.getCalcAlways()) {
            ooxml.append(" ca=\"1\"");
        }
        if (fs != null) {
            ooxml.append(">" + fs + "</f>");
        }
        ooxml.append("<v>" + val + "</v>");
        return ooxml.toString();
    }
}

