/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.Handle;
import com.extentech.ExtenXLS.RowHandle;
import com.extentech.ExtenXLS.WorkBook;
import com.extentech.ExtenXLS.WorkBookException;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import org.json.JSONArray;
import org.json.JSONObject;

public class NameHandle {
    private Name myName;
    private WorkBook mybook;
    private int DEBUGLEVEL = -1;
    private boolean createblanks = false;
    private CellRange initialRange = null;

    public NameHandle(String namestr, CellRange cr) {
        this.mybook = cr.getWorkBook();
        this.initialRange = cr;
        this.myName = new Name(this.mybook.getWorkBook(), namestr);
        this.setName(namestr);
        this.setLocation(cr.toString());
    }

    protected NameHandle(Name c, WorkBookHandle myb) {
        this.myName = c;
        this.mybook = myb;
    }

    public Handle getScope() throws WorkSheetNotFoundException {
        short itab = this.myName.getItab();
        if (itab == 0) {
            return this.mybook;
        }
        WorkSheetHandle sheet = this.mybook.getWorkSheet(itab - 1);
        return sheet;
    }

    public void setScope(Handle scope) {
        int newitab = 0;
        if (scope instanceof WorkSheetHandle) {
            newitab = ((WorkSheetHandle)scope).getSheetNum() + 1;
        }
        try {
            this.myName.setNewScope(newitab);
        }
        catch (WorkSheetNotFoundException e) {
            Logger.logErr("ERROR: setting new scope on name: " + e);
        }
    }

    public NameHandle(String namestr, WorkBookHandle myb) {
        this.mybook = myb;
        this.myName = new Name(this.mybook.getWorkBook(), namestr);
        this.setName(namestr);
    }

    public NameHandle(String name, String location, WorkBookHandle book) {
        this.mybook = book;
        this.myName = new Name(this.mybook.getWorkBook(), name);
        this.setName(name);
        this.setLocation(location);
        this.mybook.getWorkBook().associateDereferencedNames(this.myName);
    }

    public String getXML() {
        StringBuffer retXML = new StringBuffer();
        String nmv = this.getExpressionString();
        if (nmv.indexOf("=!") > -1) {
            Boundsheet bs = this.myName.getSheet();
            nmv = bs != null ? String.valueOf(bs.getSheetName()) + "!" + nmv : StringTool.replaceChars("!", nmv, "");
        }
        nmv = StringTool.convertXMLChars(nmv);
        String nmx = this.getName();
        if ((nmx = StringTool.convertXMLChars(nmx)).length() == 1) {
            if (Character.isLetterOrDigit(nmx.charAt(0))) {
                Logger.logInfo("NameHandle getting XML for name: " + nmx);
            } else {
                nmx = "#NAME";
            }
        }
        if (nmv.startsWith("=")) {
            nmv = nmv.substring(1);
        }
        retXML.append("\t\t<NamedRange Name=\"");
        retXML.append(nmx);
        retXML.append("\" RefersTo=\"");
        retXML.append(nmv);
        if (this.myName.getItab() != 0) {
            retXML.append("\" Scope=\"");
            retXML.append(this.myName.getItab());
        }
        retXML.append("\"/>");
        return retXML.toString();
    }

    public String getExpandedXML() {
        String nmv = this.getExpressionString();
        if (nmv.indexOf("=!") > -1) {
            Boundsheet bs = this.myName.getSheet();
            nmv = bs != null ? String.valueOf(bs.getSheetName()) + "!" + nmv : StringTool.replaceChars("!", nmv, "");
        }
        String nmx = this.getName();
        if ((nmx = StringTool.convertXMLChars(nmx)).length() == 1) {
            if (Character.isLetterOrDigit(nmx.charAt(0))) {
                Logger.logInfo("NameHandle getting XML for name: " + nmx);
            } else {
                nmx = "#NAME";
            }
        }
        if (nmv.startsWith("=")) {
            nmv = nmv.substring(1);
        }
        StringBuffer retXML = new StringBuffer();
        retXML.append("\t<NamedRange Name=\"");
        retXML.append(nmx);
        retXML.append("\" RefersTo=\"");
        retXML.append(nmv);
        retXML.append("\">\n");
        try {
            CellHandle[] cells = this.getCells();
            int i = 0;
            while (i < cells.length) {
                retXML.append("\t\t" + cells[i].getXML() + "\n");
                ++i;
            }
        }
        catch (CellNotFoundException ex) {
            Logger.logErr("NameHandle.getExpandedXML failed: ", ex);
        }
        retXML.append("</NamedRange>\n");
        return retXML.toString();
    }

    public void setFormatId(int i) {
        try {
            CellHandle[] cs = this.getCells();
            int t = 0;
            while (t < cs.length) {
                cs[t].setFormatId(i);
                ++t;
            }
        }
        catch (CellNotFoundException ex) {
            Logger.logErr("NameHandle.setFormatId failed: ", ex);
        }
    }

    public void deleteRow(int idxcol) throws Exception {
        CellRange[] rngs = this.getCellRanges();
        if (rngs.length > 1) {
            throw new WorkBookException("NamedRange.updateRow Object array failed: too many CellRanges.", 4);
        }
        if (rngs.length == 0) {
            throw new WorkBookException("NamedRange.updateRow Object array failed: zero CellRanges", 4);
        }
        WorkSheetHandle shtx = rngs[0].getSheet();
        int x = rngs[0].firstcellrow;
        RowHandle[] rx = rngs[0].getRows();
        boolean found = false;
        int t = 0;
        while (t < rx.length) {
            ++t;
        }
    }

    public void updateRow(Object[] objarr, int idxcol) throws Exception {
        CellRange[] rngs = this.getCellRanges();
        if (rngs.length > 1) {
            throw new WorkBookException("NamedRange.updateRow Object array failed: too many CellRanges.", 4);
        }
        if (rngs.length == 0) {
            throw new WorkBookException("NamedRange.updateRow Object array failed: zero CellRanges", 4);
        }
        WorkSheetHandle shtx = rngs[0].getSheet();
        int x = rngs[0].firstcellrow;
        RowHandle[] rx = rngs[0].getRows();
        boolean found = false;
        int t = 0;
        while (t < rx.length) {
            CellHandle[] cx = rx[t].getCells();
            if (cx.length > idxcol && cx[idxcol].getStringVal().equalsIgnoreCase(objarr[idxcol].toString())) {
                found = true;
                int z = 0;
                while (z < cx.length) {
                    cx[z].setVal(objarr[z]);
                    ++z;
                }
            }
            ++t;
        }
        if (!found) {
            this.addRow(objarr);
        }
    }

    public void addRow(Object[] objarr) throws Exception {
        CellRange[] rngs = this.getCellRanges();
        if (rngs.length > 1) {
            throw new WorkBookException("NamedRange.add Object array failed: too many CellRanges.", 4);
        }
        if (rngs.length == 0) {
            throw new WorkBookException("NamedRange.add Object array failed: zero CellRanges", 4);
        }
        WorkSheetHandle shtx = rngs[0].getSheet();
        int x = rngs[0].firstcellrow;
        CellHandle[] cxx = shtx.insertRow(x, objarr, true);
        rngs[0] = new CellRange(this.myName.getLocation(), this.mybook, this.createblanks);
    }

    public void addCell(CellHandle cx) throws Exception {
        CellRange[] rngs = this.getCellRanges();
        if (rngs.length > 1) {
            throw new WorkBookException("NamedRange.addCell failed -- more than one cell range defined in this NameHandle, cannot determine where to add cell.", 4);
        }
        rngs[0].addCellToRange(cx);
        this.setLocation(rngs[0].getRange());
    }

    public void setLocation(String strloc) {
        if (strloc.indexOf("!") == -1 && strloc.indexOf("=") == -1) {
            if (this.get2DSheetName() == null) {
                this.remove();
                throw new IllegalArgumentException("Named Range References must include a Sheet name.");
            }
            strloc = String.valueOf(this.get2DSheetName()) + "!" + strloc;
        }
        try {
            this.myName.setLocation(strloc);
        }
        catch (FunctionNotSupportedException e) {
            Logger.logWarn("NameHandle.setLocation :" + strloc + " failed: " + e.toString());
        }
    }

    public String getLocation() {
        try {
            String loc = this.myName.getLocation();
            return loc;
        }
        catch (Exception e) {
            Logger.logErr("Error getting named range location" + e);
            return null;
        }
    }

    public void setName(String newname) {
        this.myName.setName(newname);
    }

    public String getName() {
        return this.myName.getName();
    }

    public String toString() {
        return this.getName();
    }

    public String getExpressionString() {
        try {
            return this.myName.getExpressionString();
        }
        catch (Exception e) {
            if (this.DEBUGLEVEL > -1) {
                Logger.logWarn("Could not parse expression string for name: " + this.getName());
            }
            return "#ERR";
        }
    }

    public boolean remove() {
        boolean success = false;
        try {
            success = this.myName.getWorkBook().removeName(this.myName);
        }
        catch (Exception e) {
            return false;
        }
        return success;
    }

    public void setCreateBlanks(boolean b) {
        this.createblanks = b;
    }

    public String getCellRangeXML(boolean fragment) {
        StringBuffer sbx = new StringBuffer();
        if (!fragment) {
            sbx.append("<?xml version=\"1\" encoding=\"utf-8\"?>");
        }
        sbx.append("<NameHandle Name=\"" + this.getName() + "\">");
        sbx.append(this.getCellRangeXML());
        sbx.append("</NameHandle>");
        return sbx.toString();
    }

    public String getCellRangeXML() {
        StringBuffer sbx = new StringBuffer();
        try {
            CellHandle[] celx = this.getCells();
            RowHandle rowhold = null;
            int x = 0;
            while (x < celx.length) {
                RowHandle rx = celx[x].getRow();
                if (x == 0) {
                    rowhold = rx;
                    sbx.append("<Row Number='" + rowhold.getRowNumber() + "'>");
                    sbx.append(celx[x].getXML());
                } else if (rowhold.getRowNumber() == rx.getRowNumber()) {
                    sbx.append(celx[x].getXML());
                } else {
                    sbx.append("</Row>");
                    rowhold = rx;
                    sbx.append("<Row Number='" + rowhold.getRowNumber() + "'>");
                    sbx.append(celx[x].getXML());
                }
                ++x;
            }
            sbx.append("</Row>");
        }
        catch (CellNotFoundException ex) {
            Logger.logErr("NameHandle.getCellRangeXML failed: ", ex);
        }
        return sbx.toString();
    }

    public CellHandle[] getCells() throws CellNotFoundException {
        CompatibleVector cellhandles;
        block10: {
            try {
                cellhandles = new CompatibleVector();
                CellRange[] rngz = this.getCellRanges();
                if (rngz != null) {
                    int t = 0;
                    while (t < rngz.length) {
                        try {
                            CellHandle[] cells = rngz[t].getCells();
                            int b = 0;
                            while (b < cells.length) {
                                if (cells[b] != null) {
                                    cellhandles.add(cells[b]);
                                }
                                ++b;
                            }
                        }
                        catch (Exception ex) {
                            Logger.logWarn("Could not get cells for range: " + rngz[t]);
                        }
                        ++t;
                    }
                    break block10;
                }
                return null;
            }
            catch (Exception e) {
                if (e instanceof CellNotFoundException) {
                    throw (CellNotFoundException)e;
                }
                throw new CellNotFoundException(e.toString());
            }
        }
        Object[] ret = new CellHandle[cellhandles.size()];
        return (CellHandle[])cellhandles.toArray(ret);
    }

    public CellRange[] getCellRanges() throws Exception {
        if (this.initialRange != null) {
            CellRange[] ret = new CellRange[]{this.initialRange};
            return ret;
        }
        String loc = this.myName.getLocation();
        WorkSheetHandle[] sheets = this.getReferencedSheets();
        String[] nranges = loc.split(",(?=([^'|\"]*'[^'|\"]*'|\")*[^'|\"]*$)");
        CellRange[] ranges = new CellRange[nranges.length];
        int i = 0;
        while (i < nranges.length) {
            String r2 = nranges[i];
            if (r2.indexOf("!") == -1) {
                r2 = sheets[i] + "!" + r2;
            }
            ranges[i] = new CellRange(r2, this.mybook, this.createblanks);
            ranges[i].setParent(this.myName);
            ++i;
        }
        return ranges;
    }

    public WorkSheetHandle[] getReferencedSheets() throws WorkSheetNotFoundException {
        Boundsheet[] bs = this.myName.getBoundSheets();
        if (bs == null) {
            throw new WorkSheetNotFoundException("Worksheet for Named Range: " + this.toString() + ":" + this.myName.getExpressionString());
        }
        if (bs[0] == null) {
            throw new WorkSheetNotFoundException("Worksheet for Named Range: " + this.toString() + ":" + this.myName.getExpressionString());
        }
        WorkSheetHandle[] ret = new WorkSheetHandle[bs.length];
        int x = 0;
        while (x < ret.length) {
            ret[x] = this.mybook.getWorkSheet(bs[x].toString());
            ++x;
        }
        return ret;
    }

    public Object getCalculatedValue() throws FunctionNotSupportedException {
        return this.myName.getCalculatedValue();
    }

    public boolean setLocationLocked(String loc, boolean l) {
        int x = 0;
        if (l) {
            x = 1;
        }
        return this.myName.setLocationPolicy(loc, x);
    }

    public String getJSON() {
        return this.getJSON(false);
    }

    public String getJSON(boolean celldata) {
        JSONObject theNameHandle;
        block9: {
            theNameHandle = new JSONObject();
            try {
                theNameHandle.put("name", (Object)this.getName());
                theNameHandle.put("cellrange", (Object)this.myName.getLocation());
                if (!celldata) break block9;
                StringBuffer ret = new StringBuffer();
                CellHandle[] cx1 = this.getCells();
                int p = cx1[0].getRowNum();
                int x = 0;
                while (x < cx1.length) {
                    if (cx1[x] != null) {
                        if (cx1[x].getRowNum() != p) {
                            ret.append("\r\n");
                            p = cx1[x].getRowNum();
                        }
                        ret.append("'");
                        try {
                            ret.append(cx1[x].getStringVal());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (x != cx1.length - 1) {
                            ret.append("',");
                        } else {
                            ret.append("'");
                        }
                    }
                    ++x;
                }
                theNameHandle.put("celldata", (Object)ret.toString());
            }
            catch (Exception e) {
                Logger.logErr("Error creating JSON name handle: " + e);
            }
        }
        return theNameHandle.toString();
    }

    public JSONObject getJSONCellRange() {
        JSONObject theRange = new JSONObject();
        JSONArray cells = new JSONArray();
        try {
            CellHandle[] chandles = this.getCells();
            int i = 0;
            while (i < chandles.length) {
                CellHandle thisCell = chandles[i];
                JSONObject result = new JSONObject();
                result.put("Cell", (Object)thisCell.getJSONObject());
                cells.put((Object)result);
                ++i;
            }
            theRange.put("cs", (Object)cells);
        }
        catch (Exception e) {
            Logger.logErr("Error getting NamedRange JSON: " + e);
        }
        return theRange;
    }

    public String get2DSheetName() {
        try {
            return this.myName.getBoundSheets()[0].getSheetName();
        }
        catch (Exception e) {
            try {
                return this.myName.getSheet().getSheetName();
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

