/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.WorkBookException;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.XLS.ColumnNotFoundException;
import com.extentech.formats.XLS.SxStreamID;
import com.extentech.formats.XLS.Sxview;
import com.extentech.toolkit.Logger;
import org.json.JSONObject;

public class PivotTableHandle {
    public static int AUTO_FORMAT_Report1 = 1;
    public static int AUTO_FORMAT_Report2 = 2;
    public static int AUTO_FORMAT_Report3 = 3;
    public static int AUTO_FORMAT_Report4 = 4;
    public static int AUTO_FORMAT_Report5 = 5;
    public static int AUTO_FORMAT_Report6 = 6;
    public static int AUTO_FORMAT_Report7 = 7;
    public static int AUTO_FORMAT_Report8 = 8;
    public static int AUTO_FORMAT_Report9 = 9;
    public static int AUTO_FORMAT_Report10 = 10;
    public static int AUTO_FORMAT_Table1 = 11;
    public static int AUTO_FORMAT_Table2 = 12;
    public static int AUTO_FORMAT_Table3 = 13;
    public static int AUTO_FORMAT_Table4 = 14;
    public static int AUTO_FORMAT_Table5 = 15;
    public static int AUTO_FORMAT_Table6 = 16;
    public static int AUTO_FORMAT_Table7 = 17;
    public static int AUTO_FORMAT_Table8 = 18;
    public static int AUTO_FORMAT_Table9 = 19;
    public static int AUTO_FORMAT_Table10 = 20;
    public static int AUTO_FORMAT_Classic = 30;
    private Sxview pt;
    private WorkBookHandle book;
    private WorkSheetHandle worksheet;

    public PivotTableHandle(Sxview f, WorkBookHandle bk) {
        this.pt = f;
        this.book = bk;
    }

    public WorkSheetHandle getWorkSheetHandle() {
        return this.worksheet;
    }

    public CellRange getDataSourceRange() {
        SxStreamID sxid = this.book.getWorkBook().getPivotStream(this.pt.getICache());
        return sxid.getCellRange();
    }

    public void setSourceDataRange(CellRange cellRange) {
        SxStreamID sxid = this.book.getWorkBook().getPivotStream(this.pt.getICache());
        sxid.setCellRange(cellRange);
        try {
            this.pt.setNPivotFields((short)cellRange.getCols().length);
        }
        catch (ColumnNotFoundException columnNotFoundException) {
            // empty catch block
        }
    }

    public void setSourceDataRange(String range) {
        int[] rc = ExcelTools.getRangeCoords(range);
        if (range.indexOf("!") == -1) {
            range = this.getWorkSheetHandle() + "!" + range;
        }
        SxStreamID sxid = this.book.getWorkBook().getPivotStream(this.pt.getICache());
        sxid.setCellRange(range);
        this.pt.setNPivotFields((short)(rc[3] - rc[1] + 1));
    }

    public void setSource(String namedrange) {
    }

    public String getTableName() {
        return this.pt.getTableName();
    }

    public void setTableName(String tx) {
        this.pt.setTableName(tx);
    }

    public String getDataName() {
        return this.pt.getDataName();
    }

    public void setDataName(String name) {
        this.pt.setDataName(name);
    }

    public boolean containsRow(int x) {
        return x <= this.pt.getRwLast() && x >= this.pt.getRwFirst();
    }

    public String toString() {
        return this.getTableName();
    }

    public boolean containsCol(int x) {
        return x <= this.pt.getColLast() && x >= this.pt.getColFirst();
    }

    public void setRowsHaveGrandTotals(boolean b) {
        this.pt.setFRwGrand(b);
    }

    public boolean getRowsHaveGrandTotals() {
        return this.pt.getFRwGrand();
    }

    public void setColsHaveGrandTotals(boolean b) {
        this.pt.setColGrand(b);
    }

    public boolean getColsHaveGrandTotals() {
        return this.pt.getFColGrand();
    }

    public void setAutoFormatId(int b) {
        this.pt.setItblAutoFmt((short)b);
    }

    public int getAutoFormatId() {
        return this.pt.getItblAutoFmt();
    }

    public void setUsesAutoFormat(boolean b) {
        this.pt.setFAutoFormat(b);
    }

    public boolean getUsesAutoFormat() {
        return this.pt.getFAutoFormat();
    }

    public void setAutoWidthHeight(boolean b) {
        this.pt.setFWH(b);
    }

    public boolean getAutoWidthHeight() {
        return this.pt.getFWH();
    }

    public void setAutoFont(boolean b) {
        this.pt.setFFont(b);
    }

    public boolean getAutoFont() {
        return this.pt.getFFont();
    }

    public void removeArtifacts() {
        int[] coords = new int[]{this.pt.getRwFirst() - 2, this.pt.getColFirst(), this.pt.getRwLast(), this.pt.getColLast()};
        try {
            CellRange newr = new CellRange(this.worksheet, coords, true);
            CellHandle[] ch = newr.getCells();
            int r2 = 0;
            while (r2 < ch.length) {
                if (ch[r2] != null) {
                    ch[r2].remove(true);
                }
                ++r2;
            }
        }
        catch (Exception e) {
            Logger.logWarn("could not remove artifacts in PivotTableHandle: " + e);
        }
    }

    public void setAutoAlign(boolean b) {
        this.pt.setFAlign(b);
    }

    public boolean getAutoAlign() {
        return this.pt.getFAlign();
    }

    public void setAutoBorder(boolean b) {
        this.pt.setFBorder(b);
    }

    public boolean getAutoBorder() {
        return this.pt.getFBorder();
    }

    public void setAutoPattern(boolean b) {
        this.pt.setFPattern(b);
    }

    public boolean getAutoPattern() {
        return this.pt.getFPattern();
    }

    public void setAutoNumber(boolean b) {
        this.pt.setFNumber(b);
    }

    public boolean getAutoNumber() {
        return this.pt.getFNumber();
    }

    public void setRowFirst(int s) {
        this.pt.setRwFirst((short)s);
    }

    public int getRowFirst() {
        return this.pt.getRwFirst() + 1;
    }

    public void setRowLast(int s) {
        this.pt.setRwLast((short)(--s));
    }

    public int getRowLast() {
        return this.pt.getRwLast() + 1;
    }

    public void setColFirst(int s) {
        this.pt.setColFirst((short)s);
    }

    public int getColFirst() {
        return this.pt.getColFirst();
    }

    public void setColLast(int s) {
        this.pt.setColLast((short)s);
    }

    public int getColLast() {
        return this.pt.getColLast();
    }

    public void setRowFirstHead(int s) {
        this.pt.setRwFirstHead((short)(--s));
    }

    public int getRowFirstHead() {
        return this.pt.getRwFirstHead() + 1;
    }

    public void setRowFirstData(int s) {
        this.pt.setRwFirstData((short)(--s));
    }

    public int getRowFirstData() {
        return this.pt.getRwFirstData() + 1;
    }

    public void setColFirstData(int s) {
        this.pt.setColFirstData((short)s);
    }

    public int getColFirstData() {
        return this.pt.getColFirstData();
    }

    public String getJSON() {
        JSONObject thePivot = new JSONObject();
        try {
            thePivot.put("title", (Object)this.getTableName());
        }
        catch (Exception e) {
            throw new WorkBookException("PivotTableHandle.getJSON failed:" + e, 4);
        }
        return thePivot.toString();
    }
}

