/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.Handle;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.BottomMargin;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.HCenter;
import com.extentech.formats.XLS.LeftMargin;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.PrintGrid;
import com.extentech.formats.XLS.PrintRowCol;
import com.extentech.formats.XLS.RightMargin;
import com.extentech.formats.XLS.Setup;
import com.extentech.formats.XLS.TopMargin;
import com.extentech.formats.XLS.VCenter;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.WsBool;

public class PrinterSettingsHandle
implements Handle {
    public static final int PAPER_SIZE_UNDEFINED = 0;
    public static final int PAPER_SIZE_LETTER_8_5x11 = 1;
    public static final int PAPER_SIZE_LETTER_SMALL = 2;
    public static final int PAPER_SIZE_TABLOID_11x17 = 3;
    public static final int PAPER_SIZE_LEDGER_17x11 = 4;
    public static final int PAPER_SIZE_LEGAL_8_5x14 = 5;
    public static final int PAPER_SIZE_STATEMENT_5_5x8_5 = 6;
    public static final int PAPER_SIZE_LETTER_EXTRA_9_5Ax12 = 50;
    public static final int PAPER_SIZE_LEGAL_EXTRA_9_5Ax15 = 51;
    public static final int PAPER_SIZE_TABLOID_EXTRA_1111_16Ax18 = 52;
    public static final int PAPER_SIZE_A4_EXTRA_235MM_X_322MM = 53;
    public static final int PAPER_SIZE_LETTER_TRANSVERSE_8_5Ax11 = 54;
    public static final int PAPER_SIZE_EXECUTIVE_7_QUARTER_X_10_5 = 7;
    public static final int PAPER_SIZE_TRANSVERSE_210MM_X_297MM = 55;
    public static final int PAPER_SIZE_A3_297MM_X_420MM = 8;
    public static final int PAPER_SIZE_LETTER_EXTRA_TRANSV_9_5_X_12 = 56;
    public static final int PAPER_SIZE_A4_210MM_X_297MM = 9;
    public static final int PAPER_SIZE_SUPER_A_A4_227MM_X_356MM = 57;
    public static final int PAPER_SIZE_A4_SMALL_210MM_X_297MM = 10;
    public static final int PAPER_SIZE_SUPER_B_A3_305MM_X_487MM = 58;
    public static final int PAPER_SIZE_A5_148MM_X_210MM = 11;
    public static final int PAPER_SIZE_LETTER_PLUS = 59;
    public static final int PAPER_SIZE_2_X_1211_16 = 81;
    public static final int PAPER_SIZE_B4_JIS_257MM_X_364MM = 12;
    public static final int PAPER_SIZE_A4_PLUS_210MM_X_330MM = 60;
    public static final int PAPER_SIZE_B5_JIS_182MM_X_257MM = 13;
    public static final int PAPER_SIZE_A5_TRANSVERSE_148MM_X_210MM = 61;
    public static final int PAPER_SIZE_FOLIO_8_5_X_13 = 14;
    public static final int PAPER_SIZE_B5_JIS_TRANSVERSE_182MM_X_257MM = 62;
    public static final int PAPER_SIZE_QUATRO_215MM_X_275MM = 15;
    public static final int PAPER_SIZE_A3_EXTRA_322MM_X_445MM = 63;
    public static final int PAPER_SIZE_10Ax14_10_X_14 = 16;
    public static final int PAPER_SIZE_A5_EXTRA_174MM_X_235 = 64;
    public static final int PAPER_SIZE_11Ax17_11_X_17 = 17;
    public static final int PAPER_SIZE_B5_ISO_EXTRA_201MM_X_276MM = 65;
    public static final int PAPER_SIZE_NOTE_8_5_X_11 = 18;
    public static final int PAPER_SIZE_A2_420MM_X_594MM = 66;
    public static final int PAPER_SIZE_ENVELOPE_9_3_78_X_8_78 = 19;
    public static final int PAPER_SIZE_A3_TRANSVERSE_297MM_X_420MM = 67;
    public static final int PAPER_SIZE_ENVELOPE_10_4_18_X_9_5 = 20;
    public static final int PAPER_SIZE_EXTRA_TRANSVERSE_322MM_X_445MM = 68;
    public static final int PAPER_SIZE_ENVELOPE_11_4_5_X_10_38 = 21;
    public static final int PAPER_SIZE_DBL_JAP_POSTCARD_200MM_X_148MM = 69;
    public static final int PAPER_SIZE_ENVELOPE_12_4_34_X_11 = 22;
    public static final int PAPER_SIZE_A6_105MM_X_148MM = 70;
    public static final int PAPER_SIZE_ENVELOPE_14_5_X_11_5 = 23;
    public static final int PAPER_SIZE_C_17_X_22_72 = 24;
    public static final int PAPER_SIZE_D_22_X_34_73 = 25;
    public static final int PAPER_SIZE_E_34_X_44_74 = 26;
    public static final int PAPER_SIZE_DL_ENVELOPE_110MM_X_110MM_X_220MM = 27;
    public static final int PAPER_SIZE_LETTER_ROTATED_11_X_8_5 = 75;
    public static final int PAPER_SIZE_ENVELOPE_C5_162MM_X_229M = 28;
    public static final int PAPER_SIZE_A3_ROTATED_420MM_X_297MM = 76;
    public static final int PAPER_SIZE_ENVELOPE_C3_324MM_X_458MM = 29;
    public static final int PAPER_SIZE_A4_ROTATED_297MM_X_210MM = 77;
    public static final int PAPER_SIZE_ENVELOPE_C4_229MM_X_324MM = 30;
    public static final int PAPER_SIZE_A5_ROTATED_210MM_X_148MM = 78;
    public static final int PAPER_SIZE_ENVELOPE_C6_115MM_X_162MM = 31;
    public static final int PAPER_SIZE_ENVELOPE_C6_C5_114MM_X_229MM = 32;
    public static final int PAPER_SIZE_B4_ISO_250MM_X_353MM = 33;
    public static final int PAPER_SIZE_B5_ISO_176MM_X_250MM = 34;
    public static final int PAPER_SIZE_DBL_JAP_POSTCARD_ROT_148MM_X_200MM = 82;
    public static final int PAPER_SIZE_B6_ISO_125MM_X_176MM = 35;
    public static final int PAPER_SIZE_ENVELOPE_ITALY_10MM_X_230MM = 36;
    public static final int PAPER_SIZE_ENVELOPE_MONARCH_3_7_8_X_7_5 = 37;
    public static final int PAPER_SIZE_6_3_4_ENVELOPE_3_5_8_X_6_5 = 38;
    public static final int PAPER_SIZE_US_STANDARD_FANFOLD_147_8_X_11 = 39;
    public static final int PAPER_SIZE_GERMAN_STD_FANFOLD_8_5_X_12 = 40;
    public static final int PAPER_SIZE_GERMAN_LEGAL_FANFOLD_8_5_X_13 = 41;
    public static final int PAPER_SIZE_JAP_POSTCARD_100M_X_148MM = 43;
    public static final int PAPER_SIZE_9_X_11 = 44;
    public static final int PAPER_SIZE_10_X_11 = 45;
    public static final int PAPER_SIZE_15_X_11 = 46;
    public static final int PAPER_SIZE_ENVELOPE_INVITE_220MM_X_220MM = 47;
    public static final int PAPER_SIZE_B4_JIS_ROTATED_364MM_X_257MM = 79;
    public static final int PAPER_SIZE_B5_JIS_ROTATED_257MMX_X_182MM = 80;
    public static final int PAPER_SIZE_JAP_POSTCARD_ROT_148MM_X_100MM = 81;
    public static final int PAPER_SIZE_A6_ROTATED_148MM_X_105MM = 83;
    public static final int PAPER_SIZE_B6_JIS_128MM_X_182MM = 88;
    public static final int PAPER_SIZE_B6_JIS_ROT_182MM_X_128MM = 89;
    public static final int PAPER_SIZE_12_X_11 = 90;
    Boundsheet sheet;
    private Setup printerSettings;
    private HCenter hCenter;
    private VCenter vCenter;
    private LeftMargin leftMargin;
    private RightMargin rightMargin;
    private TopMargin topMargin;
    private BottomMargin bottomMargin;
    private PrintGrid grid;
    private PrintRowCol headers;
    private WsBool wsBool;

    public PrinterSettingsHandle(Boundsheet sheet) {
        this.sheet = sheet;
        for (BiffRec record : sheet.getPrintRecs()) {
            if (record instanceof Setup) {
                this.printerSettings = (Setup)record;
                continue;
            }
            if (record instanceof HCenter) {
                this.hCenter = (HCenter)record;
                continue;
            }
            if (record instanceof VCenter) {
                this.vCenter = (VCenter)record;
                continue;
            }
            if (record instanceof LeftMargin) {
                this.leftMargin = (LeftMargin)record;
                continue;
            }
            if (record instanceof RightMargin) {
                this.rightMargin = (RightMargin)record;
                continue;
            }
            if (record instanceof TopMargin) {
                this.topMargin = (TopMargin)record;
                continue;
            }
            if (record instanceof BottomMargin) {
                this.bottomMargin = (BottomMargin)record;
                continue;
            }
            if (record instanceof PrintGrid) {
                this.grid = (PrintGrid)record;
                continue;
            }
            if (record instanceof PrintRowCol) {
                this.headers = (PrintRowCol)record;
                continue;
            }
            if (!(record instanceof WsBool)) continue;
            this.wsBool = (WsBool)record;
        }
    }

    public short getCopies() {
        return this.printerSettings.getCopies();
    }

    public double getFooterMargin() {
        return this.printerSettings.getFooterMargin();
    }

    public double getHeaderMargin() {
        return this.printerSettings.getHeaderMargin();
    }

    public double getLeftMargin() {
        if (this.leftMargin == null) {
            this.leftMargin = new LeftMargin();
            this.sheet.addMarginRecord(this.leftMargin);
        }
        return this.leftMargin.getMargin();
    }

    public double getRightMargin() {
        if (this.rightMargin == null) {
            this.rightMargin = new RightMargin();
            this.sheet.addMarginRecord(this.rightMargin);
        }
        return this.rightMargin.getMargin();
    }

    public double getTopMargin() {
        if (this.topMargin == null) {
            this.topMargin = new TopMargin();
            this.sheet.addMarginRecord(this.topMargin);
        }
        return this.topMargin.getMargin();
    }

    public double getBottomMargin() {
        if (this.bottomMargin == null) {
            this.bottomMargin = new BottomMargin();
            this.sheet.addMarginRecord(this.bottomMargin);
        }
        return this.bottomMargin.getMargin();
    }

    public boolean getLandscape() {
        return this.printerSettings.getLandscape();
    }

    public boolean getLeftToRight() {
        return this.printerSettings.getLeftToRight();
    }

    public boolean getNoColor() {
        return this.printerSettings.getNoColor();
    }

    public boolean getNoOrient() {
        return this.printerSettings.getNoOrient();
    }

    public boolean getNoPrintData() {
        return this.printerSettings.getNoPrintData();
    }

    public short getPageStart() {
        return this.printerSettings.getPageStart();
    }

    public short getPaperSize() {
        return this.printerSettings.getPaperSize();
    }

    public boolean getPrintNotes() {
        return this.printerSettings.getPrintNotes();
    }

    public short getResolution() {
        return this.printerSettings.getResolution();
    }

    public short getScale() {
        return this.printerSettings.getScale();
    }

    public boolean getUsePage() {
        return this.printerSettings.getUsePage();
    }

    public short getVerticalResolution() {
        return this.printerSettings.getVerticalResolution();
    }

    public boolean isHCenter() {
        return this.hCenter.isHCenter();
    }

    public boolean isVCenter() {
        return this.vCenter.isVCenter();
    }

    public boolean isPrintGridLines() {
        return this.grid.isPrintGrid();
    }

    public boolean isPrintRowColHeaders() {
        return this.headers.isPrintHeaders();
    }

    public boolean isFitToPage() {
        return this.wsBool.isFitToPage();
    }

    public void setDraft(boolean b) {
        this.printerSettings.setDraft(b);
    }

    public void setFitHeight(int numpages) {
        this.printerSettings.setFitHeight((short)numpages);
    }

    public void setFitWidth(int numpages) {
        this.printerSettings.setFitWidth((short)numpages);
    }

    public void setFitToPage(boolean value) {
        this.wsBool.setFitToPage(value);
    }

    public void setFooterMargin(double f) {
        this.printerSettings.setFooterMargin(f);
    }

    public void setHCenter(boolean center) {
        this.hCenter.setHCenter(center);
    }

    public void setHeaderMargin(double h) {
        this.printerSettings.setHeaderMargin(h);
    }

    public void setLeftMargin(double value) {
        if (this.leftMargin == null) {
            this.leftMargin = new LeftMargin();
            this.sheet.addMarginRecord(this.leftMargin);
        }
        this.leftMargin.setMargin(value);
    }

    public void setRightMargin(double value) {
        if (this.rightMargin == null) {
            this.rightMargin = new RightMargin();
            this.sheet.addMarginRecord(this.rightMargin);
        }
        this.rightMargin.setMargin(value);
    }

    public void setTopMargin(double value) {
        if (this.topMargin == null) {
            this.topMargin = new TopMargin();
            this.sheet.addMarginRecord(this.topMargin);
        }
        this.topMargin.setMargin(value);
    }

    public void setBottomMargin(double value) {
        if (this.bottomMargin == null) {
            this.bottomMargin = new BottomMargin();
            this.sheet.addMarginRecord(this.bottomMargin);
        }
        this.bottomMargin.setMargin(value);
    }

    public void setLandscape(boolean b) {
        this.printerSettings.setNoOrient(false);
        this.printerSettings.setLandscape(b);
    }

    public void setLeftToRight(boolean b) {
        this.printerSettings.setLeftToRight(b);
    }

    public void setNoColor(boolean b) {
        this.printerSettings.setNoColor(b);
    }

    public void setPageStart(short p) {
        this.printerSettings.setPageStart(p);
    }

    public void setPrintNotes(boolean b) {
        this.printerSettings.setPrintNotes(b);
    }

    public void setResolution(int r2) {
        this.printerSettings.setResolution((short)r2);
    }

    public void setScale(int scale) {
        this.printerSettings.setScale((short)scale);
    }

    public void setUsePage(boolean usePage) {
        this.printerSettings.setUsePage(usePage);
    }

    public void setVerticalResolution(short verticalResolution) {
        this.printerSettings.setVerticalResolution(verticalResolution);
    }

    public void setCopies(int copies) {
        this.printerSettings.setCopies((short)copies);
    }

    public void setPaperSize(int p) {
        this.printerSettings.setPaperSize((short)p);
    }

    public boolean getDraft() {
        return this.printerSettings.getDraft();
    }

    public short getFitHeight() {
        return this.printerSettings.getFitHeight();
    }

    public short getFitWidth() {
        return this.printerSettings.getFitWidth();
    }

    public void setVCenter(boolean center) {
        this.vCenter.setVCenter(center);
    }

    public void setPrintGrid(boolean print) {
        this.grid.setPrintGrid(print);
    }

    public void setPrintRowColHeaders(boolean print) {
        this.headers.setPrintHeaders(print);
    }

    public String getTitles() {
        Name range = this.sheet.getName("Built-in: PRINT_TITLES");
        if (range == null) {
            return null;
        }
        return range.getExpressionString();
    }

    public void setTitles(String range) {
        Name name = this.sheet.getName("Built-in: PRINT_TITLES");
        if (name == null) {
            try {
                name = new Name(this.sheet.getWorkBook(), "Print_Titles");
                name.setBuiltIn((byte)7);
                name.setNewScope(this.sheet.getSheetNum() + 1);
            }
            catch (WorkSheetNotFoundException e) {
                throw new Error("sheet not found re-scoping name");
            }
        }
        if (range == null) {
            return;
        }
        String[] ranges = range.split(",");
        range = "";
        int i = 0;
        while (i < ranges.length) {
            if (i > 0) {
                range = String.valueOf(range) + ",";
            }
            String r2 = "";
            int[] rc = ExcelTools.getRangeCoords(ranges[i]);
            if (rc[0] == rc[2]) {
                r2 = "$" + ExcelTools.getAlphaVal(rc[1]) + ":$" + ExcelTools.getAlphaVal(rc[3]);
            }
            if (rc[1] == rc[3]) {
                r2 = "$" + rc[0] + ":$" + rc[2];
            }
            range = String.valueOf(range) + this.sheet.getSheetName() + "!" + r2;
            ++i;
        }
        name.setLocation(range);
    }
}

