/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ColHandle;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.FormulaHandle;
import com.extentech.ExtenXLS.ImageHandle;
import com.extentech.ExtenXLS.WorkBook;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.Mulblank;
import com.extentech.formats.XLS.Row;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RowHandle {
    public static int ROW_HEIGHT_DIVISOR = 17;
    public Row myRow;
    private FormatHandle formatter;
    private WorkBook wbh;
    private WorkSheetHandle wsh;

    protected RowHandle(Row c, WorkSheetHandle ws) {
        this.myRow = c;
        this.wbh = ws.getWorkBook();
        this.wsh = ws;
    }

    public int getHeight() {
        return this.myRow.getRowHeight();
    }

    public int getHeightInChars() {
        return this.myRow.getRowHeight() / 20;
    }

    public static int getHeight(Boundsheet sheet, int row) {
        int h = 255;
        try {
            Row r2 = sheet.getRowByNumber(row);
            if (r2 != null) {
                h = r2.getRowHeight();
            }
        }
        catch (Exception e) {
            h = 255;
        }
        return h;
    }

    public void setHeightInChars(int newHeight) {
        this.setHeight(newHeight * 20);
    }

    public void setRowHeightAutoFit() {
        Collection<BiffRec> ct = this.myRow.getCells();
        Iterator<BiffRec> it = ct.iterator();
        double h = 0.0;
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        double factorTwip = (double)dpi / 72.0 / 20.0;
        double factorZero = 7.0;
        while (it.hasNext()) {
            XLSRecord cellrec = (XLSRecord)it.next();
            try {
                double newH = 255.0;
                try {
                    com.extentech.formats.XLS.Font ef = cellrec.getXfRec().getFont();
                    int style = 0;
                    if (ef.getBold()) {
                        style |= 1;
                    }
                    if (ef.getItalic()) {
                        style |= 2;
                    }
                    Font f = new Font(ef.getFontName(), style, (int)ef.getFontHeightInPoints());
                    String s = cellrec.getStringVal();
                    if (!cellrec.getXfRec().getWrapText()) {
                        newH = StringTool.getApproximateHeight(f, s, Double.MAX_VALUE);
                    } else {
                        double cw = (double)ColHandle.getWidth(this.wsh.getBoundsheet(), cellrec.getColNumber()) / 256.0;
                        newH = StringTool.getApproximateHeight(f, s, cw * factorZero);
                    }
                    newH *= 20.0;
                }
                catch (Exception e) {
                    Logger.logErr("RowHandle.setRowHeightAutoFit: " + e.toString());
                }
                h = Math.max(h, newH);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (h > 0.0) {
            this.myRow.setRowHeight((int)Math.ceil(h));
        }
    }

    public void setHeight(int newHeight) {
        ImageHandle ih;
        int z;
        ArrayList<int[]> iAdjust = new ArrayList<int[]>();
        ImageHandle[] images = this.myRow.getSheet().getImages();
        if (images != null) {
            z = 0;
            while (z < images.length) {
                ih = images[z];
                int r0 = ih.getRow();
                int r1 = ih.getRow1();
                int row = this.myRow.getRowNumber();
                if (row >= r0 && row <= r1) {
                    short h = ih.getHeight();
                    iAdjust.add(new int[]{z, h});
                }
                ++z;
            }
        }
        this.myRow.setRowHeight(newHeight);
        z = 0;
        while (z < iAdjust.size()) {
            ih = images[((int[])iAdjust.get(z))[0]];
            ih.setHeight(((int[])iAdjust.get(z))[1]);
            ++z;
        }
    }

    public boolean containsVerticalMergeRange() {
        CellHandle[] c = this.getCells();
        int i = 0;
        while (i < c.length) {
            if (c[i].getMergedCellRange() != null) {
                CellRange cr = c[i].getMergedCellRange();
                try {
                    if (cr.getRows().length > 1) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return false;
    }

    public void setFormatId(int i) {
        this.myRow.setIxfe(i);
    }

    public FormatHandle getFormatHandle() {
        if (this.formatter == null) {
            this.setFormatHandle();
        }
        return this.formatter;
    }

    private void setFormatHandle() {
        if (this.formatter != null) {
            return;
        }
        this.formatter = new FormatHandle(this.wbh, this.getFormatId());
        this.formatter.setRowHandle(this);
    }

    public int getFormatId() {
        if (this.myRow.getExplicitFormatSet()) {
            return this.myRow.getIxfe();
        }
        return this.getWorkBook().getWorkBook().getDefaultIxfe();
    }

    public CellHandle[] getCells(boolean cached) {
        Collection<BiffRec> ct = this.myRow.getCells();
        Iterator<BiffRec> it = ct.iterator();
        CellHandle[] ch = new CellHandle[ct.size()];
        int t = 0;
        Mulblank aMul = null;
        int c = -1;
        while (it.hasNext()) {
            block9: {
                BiffRec rc = it.next();
                try {
                    if (rc.getOpcode() != 190) {
                        ch[t] = this.wsh.getCell(rc.getRowNumber(), rc.getColNumber(), cached);
                    } else {
                        if (rc == aMul) {
                            c = (short)(c + 1);
                        } else {
                            aMul = (Mulblank)rc;
                            c = (short)aMul.getColFirst();
                        }
                        ch[t] = this.wsh.getCell(rc.getRowNumber(), c, cached);
                    }
                }
                catch (CellNotFoundException cnfe) {
                    rc.setXFRecord();
                    ch[t] = new CellHandle(rc, null);
                    ch[t].setWorkSheetHandle(null);
                    if (rc.getOpcode() != 190) break block9;
                    if (rc == aMul) {
                        c = (short)(c + 1);
                    } else {
                        aMul = (Mulblank)rc;
                        c = (short)aMul.getColFirst();
                    }
                    ch[t].setBlankRef(c);
                }
            }
            ++t;
        }
        return ch;
    }

    public CellHandle[] getCells() {
        return this.getCells(false);
    }

    public String getJSON() {
        return this.getJSON(255).toString();
    }

    public JSONObject getJSON(int maxcols) {
        JSONObject theRange = new JSONObject();
        JSONArray cells = new JSONArray();
        try {
            theRange.put("Row", this.getRowNumber());
            theRange.put("BdrT", this.getHasAnyThickTopBorder());
            theRange.put("BdrB", this.getHasAnyBottomBorder());
            if (this.getFormatId() != this.getWorkBook().getWorkBook().getDefaultIxfe()) {
                theRange.put("xf", this.getFormatId());
            }
            theRange.put("h", this.getHeight() / ROW_HEIGHT_DIVISOR + 5);
            CellHandle[] chandles = this.getCells(false);
            int i = 0;
            while (i < chandles.length) {
                CellHandle thisCell = chandles[i];
                if (!thisCell.isDefaultCell()) {
                    if (thisCell.getCell().getOpcode() == 6) {
                        try {
                            FormulaHandle fh = thisCell.getFormulaHandle();
                            fh.getFormulaRec().setCachedValue(null);
                        }
                        catch (Exception fh) {
                            // empty catch block
                        }
                    }
                    if (thisCell.getColNum() >= maxcols) {
                        i = chandles.length;
                    } else if (thisCell.getCell().getOpcode() == 190) {
                        Mulblank mb = (Mulblank)thisCell.getCell();
                        ArrayList<Integer> columns = mb.getColReferences();
                        int x = 0;
                        while (x < columns.size()) {
                            thisCell.setBlankRef(columns.get(x));
                            thisCell.getCell().setCol(columns.get(x).shortValue());
                            JSONObject result = new JSONObject();
                            thisCell.getCellAddress();
                            String v = "";
                            try {
                                v = thisCell.getJSONObject();
                            }
                            catch (Exception exz) {
                                Logger.logErr("Error getting Row cell value " + thisCell.getCellAddress() + " JSON: " + exz);
                                v = "ERROR FETCHING VALUE for:" + thisCell.getCellAddress();
                            }
                            if (v != null) {
                                result.put("Cell", (Object)v);
                                cells.put((Object)result);
                            }
                            ++x;
                        }
                    } else {
                        JSONObject result = new JSONObject();
                        String v = "ERROR FETCHING VALUE for:" + thisCell.getCellAddress();
                        try {
                            v = thisCell.getJSONObject();
                        }
                        catch (Exception exz) {
                            Logger.logErr("Error getting Row cell value " + thisCell.getCellAddress() + " JSON: " + exz);
                        }
                        if (v != null) {
                            result.put("Cell", (Object)v);
                            cells.put((Object)result);
                        }
                    }
                }
                ++i;
            }
            theRange.put("cs", (Object)cells);
        }
        catch (JSONException e) {
            Logger.logErr("Error getting Row JSON: " + (Object)((Object)e));
        }
        return theRange;
    }

    public String toString() {
        return this.myRow.toString();
    }

    public int getRowNumber() {
        return this.myRow.getRowNumber();
    }

    public void setCollapsed(boolean b) {
        this.myRow.setCollapsed(b);
    }

    public void setHidden(boolean b) {
        this.myRow.setHidden(b);
    }

    public void setOutlineLevel(int x) {
        this.myRow.setOutlineLevel(x);
    }

    public int getOutlineLevel() {
        return this.myRow.getOutlineLevel();
    }

    public boolean isCollapsed() {
        return this.myRow.isCollapsed();
    }

    public boolean isHidden() {
        return this.myRow.isHidden();
    }

    public boolean isAlteredHeight() {
        return this.myRow.isAlteredHeight();
    }

    public void setBackgroundColor(Color colr) {
        this.setFormatHandle();
        this.formatter.setCellBackgroundColor(colr);
    }

    public boolean getHasThickTopBorder() {
        return this.myRow.getHasThickTopBorder();
    }

    public boolean getHasThickBottomBorder() {
        return this.myRow.getHasThickBottomBorder();
    }

    public boolean getHasAnyThickTopBorder() {
        return this.myRow.getHasAnyThickTopBorder();
    }

    public boolean getHasAnyBottomBorder() {
        return this.myRow.getHasAnyBottomBorder();
    }

    public void setHasThickTopBorder(boolean hasBorder) {
        this.myRow.setHasThickTopBorder(hasBorder);
    }

    public void setHasThickBottomBorder(boolean hasBorder) {
        this.myRow.setHasThickBottomBorder(hasBorder);
    }

    public int[] getColDimensions() {
        return this.myRow.getColDimensions();
    }

    public WorkBook getWorkBook() {
        return this.wbh;
    }

    public WorkSheetHandle getWorkSheetHandle() {
        return this.wsh;
    }
}

