/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.AutoFilterHandle;
import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ChartHandle;
import com.extentech.ExtenXLS.ColHandle;
import com.extentech.ExtenXLS.CommentHandle;
import com.extentech.ExtenXLS.ConditionalFormatHandle;
import com.extentech.ExtenXLS.DateConverter;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.FormulaHandle;
import com.extentech.ExtenXLS.Handle;
import com.extentech.ExtenXLS.ImageHandle;
import com.extentech.ExtenXLS.NameHandle;
import com.extentech.ExtenXLS.PivotTableHandle;
import com.extentech.ExtenXLS.PrinterSettingsHandle;
import com.extentech.ExtenXLS.RowHandle;
import com.extentech.ExtenXLS.ValidationHandle;
import com.extentech.ExtenXLS.WorkBookException;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.XLS.AutoFilter;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.CellPositionConflictException;
import com.extentech.formats.XLS.CellTypeMismatchException;
import com.extentech.formats.XLS.Cf;
import com.extentech.formats.XLS.Colinfo;
import com.extentech.formats.XLS.ColumnNotFoundException;
import com.extentech.formats.XLS.Condfmt;
import com.extentech.formats.XLS.Dv;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.ImageNotFoundException;
import com.extentech.formats.XLS.Mulblank;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.Note;
import com.extentech.formats.XLS.Password;
import com.extentech.formats.XLS.ReferenceTracker;
import com.extentech.formats.XLS.Row;
import com.extentech.formats.XLS.RowNotFoundException;
import com.extentech.formats.XLS.SheetProtectionManager;
import com.extentech.formats.XLS.Sxview;
import com.extentech.formats.XLS.Unicodestring;
import com.extentech.formats.XLS.ValidationException;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.Series;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WorkSheetHandle
implements Handle {
    private Boundsheet mysheet;
    private WorkBook mybook;
    WorkBookHandle wbh;
    private int DEBUGLEVEL = 0;
    private Hashtable dateFormats = new Hashtable();
    private boolean cache = true;
    private CompatibleVector addedrows = new CompatibleVector();
    private boolean range_init = true;
    public static final int ROW_INSERT_MULTI = 0;
    public static final int ROW_INSERT = 3;
    public static final int ROW_INSERT_ONCE = 1;
    public static final int ROW_INSERT_NO_REFERENCE_UPDATE = 2;
    public static final int ROW_DELETE = 1;
    public static final int ROW_DELETE_NO_REFERENCE_UPDATE = 2;
    public static final short ALLOWOBJECTS = 1;
    public static final short ALLOWSCENARIOS = 2;
    public static final short ALLOWFORMATCELLS = 4;
    public static final short ALLOWFORMATCOLUMNS = 8;
    public static final short ALLOWFORMATROWS = 16;
    public static final short ALLOWINSERTCOLUMNS = 32;
    public static final short ALLOWINSERTROWS = 64;
    public static final short ALLOWINSERTHYPERLINKS = 128;
    public static final short ALLOWDELETECOLUMNS = 256;
    public static final short ALLOWDELETEROWS = 512;
    public static final short ALLOWSELLOCKEDCELLS = 1024;
    public static final short ALLOWSORT = 2048;
    public static final short ALLOWAUTOFILTER = 4096;
    public static final short ALLOWPIVOTTABLES = 8192;
    public static final short ALLOWSELUNLOCKEDCELLS = 16384;

    public void addChart(byte[] serialchart, String name, short[] coords) {
        this.mysheet.addChart(serialchart, name, coords);
    }

    public int getFirstRow() {
        return this.mysheet.getMinRow();
    }

    public int getFirstCol() {
        return this.mysheet.getMinCol();
    }

    public int getLastRow() {
        return this.mysheet.getMaxRow();
    }

    public int getLastCol() {
        return this.mysheet.getMaxCol();
    }

    public void setProtected(boolean protect, String password) throws WorkBookException {
        SheetProtectionManager protector = this.mysheet.getProtectionManager();
        String oldpass = protector.getPassword();
        Password pss = new Password();
        pss.setPassword(password);
        String passcheck = pss.getPasswordHashString();
        if (oldpass != null && !oldpass.equals(passcheck) && oldpass != "0000") {
            throw new WorkBookException("Incorrect Password Attempt to Unprotect Worksheet.", 13);
        }
        protector.setProtected(protect);
        protector.setPassword(protect ? password : null);
    }

    public void setProtected(boolean protect) {
        this.mysheet.getProtectionManager().setProtected(protect);
    }

    public void setProtectionPassword(String password) {
        this.mysheet.getProtectionManager().setPassword(password);
    }

    public void setProtectionPasswordHashed(String hash) {
        this.mysheet.getProtectionManager().setPasswordHashed(hash);
    }

    public String getHashedProtectionPassword() {
        return this.mysheet.getProtectionManager().getPassword();
    }

    public boolean getProtected() {
        return this.mysheet.getProtectionManager().getProtected();
    }

    public boolean checkProtectionPassword(String guess) {
        return this.mysheet.getProtectionManager().checkPassword(guess);
    }

    public void setEnhancedProtection(int protectionOption, boolean set) {
        this.mysheet.getProtectionManager().setProtected(protectionOption, set);
    }

    public boolean getEnhancedProtection(int protectionOption) {
        return this.mysheet.getProtectionManager().getProtected(protectionOption);
    }

    public void setVeryHidden(boolean b) {
        int h = 0;
        if (b) {
            h = 2;
        }
        this.mysheet.setHidden(h);
        int t = this.mysheet.getSheetNum();
        try {
            Boundsheet s2 = this.mybook.getWorkSheetByNumber(t + 1);
            s2.setSelected(true);
        }
        catch (WorkSheetNotFoundException workSheetNotFoundException) {
            // empty catch block
        }
    }

    public boolean getSelected() {
        return this.mysheet.selected();
    }

    public boolean getHidden() {
        return this.mysheet.getHidden();
    }

    public boolean getVeryHidden() {
        return this.mysheet.getVeryHidden();
    }

    public void setHidden(boolean b) {
        int h = 0;
        if (b) {
            h = 1;
        }
        this.mysheet.setHidden(h);
        if (this.mysheet.getSheetNum() == 0) {
            try {
                Boundsheet s2 = this.mybook.getWorkSheetByNumber(this.mysheet.getSheetNum() + 1);
                this.mybook.setFirstVisibleSheet(s2);
            }
            catch (WorkSheetNotFoundException s2) {
                // empty catch block
            }
        }
        if (this.mysheet.selected()) {
            try {
                int x = 1;
                Boundsheet s2 = this.mybook.getWorkSheetByNumber(this.mysheet.getSheetNum() + x);
                while (s2.getHidden()) {
                    s2 = this.mybook.getWorkSheetByNumber(this.mysheet.getSheetNum() + x++);
                }
                s2.setSelected(true);
            }
            catch (WorkSheetNotFoundException workSheetNotFoundException) {
                // empty catch block
            }
        }
    }

    public void setFirstVisibleTab() {
        this.mysheet.getWorkBook().setFirstVisibleSheet(this.mysheet);
    }

    public int getTabIndex() {
        return this.mysheet.getSheetNum();
    }

    public void setTabIndex(int idx) {
        this.mysheet.getWorkBook().changeWorkSheetOrder(this.mysheet, idx);
    }

    public void setSelected(boolean b) {
        this.mysheet.setSelected(b);
    }

    public ColHandle getCol(int clnum) throws ColumnNotFoundException {
        ColHandle mycol;
        Colinfo ci = this.mysheet.getColInfo(clnum);
        if (ci == null || !ci.isSingleCol()) {
            try {
                ci = ci == null ? this.mysheet.createColinfo(clnum, clnum) : this.mysheet.createColinfo(clnum, clnum, ci);
                mycol = new ColHandle(ci, this);
            }
            catch (Exception e) {
                throw new ColumnNotFoundException("Unable to getCol for col number " + clnum + " " + e.toString());
            }
        } else {
            mycol = new ColHandle(ci, this);
        }
        return mycol;
    }

    public ColHandle addCol(int c1st, int clast) {
        Colinfo ci = this.mysheet.createColinfo(c1st, clast);
        ColHandle mycol = new ColHandle(ci, this);
        return mycol;
    }

    public ColHandle addCol(int colNum) {
        Colinfo ci = this.mysheet.createColinfo(colNum, colNum);
        ColHandle mycol = new ColHandle(ci, this);
        return mycol;
    }

    public ColHandle getCol(String name) throws ColumnNotFoundException {
        return this.getCol(ExcelTools.getIntVal(name));
    }

    public ColHandle[] getColumns() {
        CompatibleVector columns = new CompatibleVector();
        for (Colinfo c : this.mysheet.getColinfos()) {
            try {
                int start = c.getColFirst();
                int end = c.getColLast();
                int i = start;
                while (i <= end) {
                    try {
                        columns.add(this.getCol(i));
                    }
                    catch (ColumnNotFoundException columnNotFoundException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return columns.toArray((T[])new ColHandle[columns.size()]);
    }

    public List getColNames() {
        return this.mysheet.getColNames();
    }

    public List getRowNums() {
        return this.mysheet.getRowNums();
    }

    public RowHandle getRow(int t) throws RowNotFoundException {
        Row x = this.mysheet.getRowByNumber(t);
        if (x == null) {
            throw new RowNotFoundException("Row " + t + " not found in :" + this.getSheetName());
        }
        return new RowHandle(x, this);
    }

    public RowHandle[] getRows() {
        Row[] rs = this.mysheet.getRows();
        RowHandle[] ret = new RowHandle[rs.length];
        int t = 0;
        while (t < rs.length) {
            ret[t] = new RowHandle(rs[t], this);
            ++t;
        }
        return ret;
    }

    public Map getRowMap() {
        return this.mysheet.getRowMap();
    }

    boolean hasCell(String addr) {
        try {
            this.getCell(addr);
            return true;
        }
        catch (CellNotFoundException e) {
            return false;
        }
    }

    public int getNumRows() {
        return this.mysheet.getNumRows();
    }

    public int getNumCols() {
        return this.mysheet.getNumCols();
    }

    public void removeCell(CellHandle celldel) {
        this.mysheet.removeCell(celldel.getCell());
    }

    public void removeImage(ImageHandle img) {
        this.mysheet.removeImage(img);
        img.remove();
    }

    public void removeCell(String celladdr) {
        this.mysheet.removeCell(celladdr.toUpperCase());
    }

    public void removeRow(int rownum, boolean shiftrows) throws RowNotFoundException {
        if (shiftrows) {
            this.removeRow(rownum);
        } else {
            this.removeRow(rownum, 2);
        }
    }

    public void removeRow(int rownum) throws RowNotFoundException {
        this.removeRow(rownum, 1);
    }

    public void removeRowContents(int rownum) throws RowNotFoundException {
        this.mysheet.removeRowContents(rownum);
    }

    public void removeRow(int rownum, int flag) throws RowNotFoundException {
        this.mysheet.removeRows(rownum, 1, true);
        List charts = this.mysheet.getCharts();
        int i = 0;
        while (i < charts.size()) {
            int rnum;
            String sht = GenericPtg.qualifySheetname(this.getSheetName());
            Chart c = (Chart)charts.get(i);
            HashMap seriesmap = c.getSeriesPtgs();
            block3: for (Series s : seriesmap.keySet()) {
                Ptg[] ptgs = (Ptg[])seriesmap.get(s);
                int j = 0;
                while (j < ptgs.length) {
                    try {
                        PtgRef pr = (PtgRef)ptgs[j];
                        String cursheet = pr.getSheetName();
                        int[] rc = pr.getIntLocation();
                        if (rc[1] == rc[3] || !sht.equalsIgnoreCase(cursheet)) continue block3;
                        if (rc[0] == rownum - 1) {
                            c.removeSeries(j);
                            continue block3;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++j;
                }
            }
            int row = c.getRow0();
            if (row > (rnum = rownum + 1)) {
                int h = c.getHeight();
                c.setRow(row - 1);
                c.setHeight(h);
            }
            ++i;
        }
        if (flag != 2) {
            ReferenceTracker.updateReferences(rownum, -1, this.mysheet, true);
        }
        int rnum = rownum + 1;
        ImageHandle[] images = this.getImages();
        int i2 = 0;
        while (i2 < images.length) {
            ImageHandle ih = images[i2];
            int row = ih.getRow();
            if (row > rnum) {
                short h = ih.getHeight();
                ih.setRow(row - 1);
                ih.setHeight(h);
            }
            ++i2;
        }
    }

    public void clearCols(int first, int count) {
        this.removeCols(first, count, false);
    }

    public void removeCols(int first, int count) {
        this.removeCols(first, count, true);
    }

    private void removeCols(int first, int count, boolean shift) {
        if (first < 0) {
            throw new IllegalArgumentException("column index must be zero or greater");
        }
        if (count < 1) {
            throw new IllegalArgumentException("count must be at least one");
        }
        this.mysheet.removeCols(first, count, shift);
    }

    @Deprecated
    public void removeCol(String colstr) throws ColumnNotFoundException {
        this.removeCols(ExcelTools.getIntVal(colstr), 1, false);
    }

    @Deprecated
    public void removeCol(String colstr, boolean shiftcols) throws ColumnNotFoundException {
        this.removeCols(ExcelTools.getIntVal(colstr), 1, shiftcols);
    }

    public int getSheetNum() {
        return this.mysheet.getSheetNum();
    }

    public NameHandle[] getNamedRangesInScope() {
        Name[] nand = this.mysheet.getSheetScopedNames();
        NameHandle[] nands = new NameHandle[nand.length];
        int x = 0;
        while (x < nand.length) {
            nands[x] = new NameHandle(nand[x], this.wbh);
            ++x;
        }
        return nands;
    }

    public NameHandle getNamedRangeInScope(String rangename) throws CellNotFoundException {
        Name nand = this.mysheet.getScopedName(rangename);
        if (nand == null) {
            throw new CellNotFoundException(rangename);
        }
        return new NameHandle(nand, this.wbh);
    }

    public String getSheetName() {
        return this.mysheet.getSheetName();
    }

    public String getQualifiedSheetName() {
        return GenericPtg.qualifySheetname(this.mysheet.getSheetName());
    }

    protected Boundsheet getSheet() {
        return this.mysheet;
    }

    public byte[] getSerialBytes() {
        this.mysheet.setLocalRecs();
        ObjectOutputStream obs = null;
        byte[] b = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream bufo = new BufferedOutputStream(baos);
            obs = new ObjectOutputStream(bufo);
            obs.writeObject(this.mysheet);
            bufo.flush();
            b = baos.toByteArray();
        }
        catch (Throwable e) {
            Logger.logWarn("Serializing Sheet: " + this.toString() + " failed: " + e);
        }
        return b;
    }

    public void writeAsTabbedText(OutputStream dest) throws IOException {
        this.mysheet.writeAsTabbedText(dest);
    }

    protected WorkSheetHandle(Boundsheet sht, WorkBookHandle b) {
        this.wbh = b;
        this.mysheet = sht;
        this.mybook = sht.getWorkBook();
        String shiftRule = (String)System.getProperties().get("com.extentech.extenXLS.WorkSheetHandle.shiftInclusive");
        if (shiftRule != null && shiftRule.equalsIgnoreCase("true")) {
            this.mysheet.setShiftRule(shiftRule.equalsIgnoreCase("true"));
        }
        if (System.getProperty("com.extentech.ExtenXLS.cacheCellHandles") != null) {
            this.cache = Boolean.valueOf(System.getProperty("com.extentech.ExtenXLS.cacheCellHandles"));
        }
    }

    public boolean getUseCache() {
        return this.cache;
    }

    public void setVal(String address, Object val) throws CellNotFoundException, CellTypeMismatchException {
        CellHandle c = this.getCell(address);
        c.setVal(val);
    }

    public void setVal(String address, double d) throws CellNotFoundException, CellTypeMismatchException {
        CellHandle c = this.getCell(address);
        c.setVal(d);
    }

    public void setVal(String address, String s) throws CellNotFoundException, CellTypeMismatchException {
        CellHandle c = this.getCell(address);
        c.setVal(s);
    }

    public void setSheetName(String name) {
        this.wbh.sheethandles.remove(this.getSheetName());
        this.mysheet.setSheetName(name);
        this.wbh.sheethandles.put(name, this);
    }

    public void setVal(String address, int i) throws CellNotFoundException, CellTypeMismatchException {
        CellHandle c = this.getCell(address);
        c.setVal(i);
    }

    public Object getVal(String address) throws CellNotFoundException {
        CellHandle c = this.getCell(address);
        return c.getVal();
    }

    public CellHandle[] insertRow(int row1, Object[] data) {
        return this.insertRow(row1, data, true);
    }

    public boolean insertRow(int rownum) {
        return this.insertRow(rownum, (Row)null, 3, true);
    }

    public void insertRow(int rownum, int flag) {
        this.insertRow(rownum, (Row)null, flag, true);
    }

    public boolean insertRowAt(int rownum, boolean shiftrows) {
        this.addedrows.remove((Object)rownum);
        return this.insertRow(rownum, this.mysheet.getRowByNumber(rownum), rownum, shiftrows);
    }

    public boolean insertRow(int rownum, boolean shiftrows) {
        Row myr = null;
        try {
            myr = this.mysheet.getRowByNumber(rownum);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (myr != null || shiftrows) {
            return this.insertRow(rownum, myr, 0, shiftrows);
        }
        Row newRow = this.mysheet.insertRow(rownum, 0, shiftrows);
        return true;
    }

    public boolean insertRow(int rownum, RowHandle copyRow, int flag, boolean shiftrows) {
        return this.insertRow(rownum, copyRow.myRow, flag, shiftrows);
    }

    public CellHandle[] insertRow(int rownum, Object[] data, boolean shiftrows) {
        CellHandle[] retc = new CellHandle[data.length];
        try {
            this.insertRow(rownum, shiftrows);
            int t = 0;
            while (t < data.length) {
                if (data[t] != null) {
                    retc[t] = this.add(data[t], rownum, t);
                }
                ++t;
            }
        }
        catch (Exception ex) {
            throw new WorkBookException(ex.toString(), 4);
        }
        return retc;
    }

    private boolean insertRow(int rownum, Row copyRow, int flag, boolean shiftrows) {
        int offset = 1;
        return this.shiftRow(rownum, copyRow, flag, shiftrows, offset);
    }

    boolean deleteRow(int rownum, int flag, boolean shiftrows) {
        int offset = -1;
        return this.shiftRow(rownum, null, flag, shiftrows, offset);
    }

    private boolean shiftRow(int rownum, Row copyRow, int flag, boolean shiftrows, int offset) {
        ImageHandle[] images;
        if (copyRow == null) {
            this.add(null, "A" + rownum + 1);
            copyRow = this.mysheet.getRowByNumber(rownum);
        }
        if (flag == 1 && this.addedrows.contains(rownum)) {
            return false;
        }
        if (offset == 0) {
            offset = 1;
        }
        if (shiftrows && flag != 2) {
            int refUpdateStart = rownum;
            if (flag == 3) {
                ++refUpdateStart;
            }
            ReferenceTracker.updateReferences(refUpdateStart, offset, this.mysheet, true);
        }
        Row newRow = this.mysheet.insertRow(rownum, flag, shiftrows);
        if (shiftrows) {
            this.addedrows.add(rownum);
        }
        if (shiftrows && copyRow != null) {
            int refMovementDiff = copyRow.getRowNumber() - rownum;
            int refMovementRow = rownum;
            if (refMovementDiff < 0) {
                refMovementRow += refMovementDiff;
            }
            newRow.setRowHeight(copyRow.getRowHeight());
            Object[] copyRowCells = copyRow.getCellArray();
            Hashtable<String, CellRange> newmerges = new Hashtable<String, CellRange>();
            CellRange newmerge = null;
            CellHandle newCellHandle = null;
            Mulblank aMul = null;
            short c = -1;
            String sheetname = GenericPtg.qualifySheetname(this.toString());
            int i = 0;
            while (i < copyRowCells.length) {
                CellHandle copyCellHandle;
                block33: {
                    BiffRec copyRowCell = (BiffRec)copyRowCells[i];
                    if (copyRowCell.getOpcode() == 190) {
                        if (copyRowCell == aMul) {
                            c = (short)(c + 1);
                        } else {
                            aMul = (Mulblank)copyRowCell;
                            c = (short)aMul.getColFirst();
                        }
                        aMul.setCurrentCell(c);
                    }
                    copyCellHandle = new CellHandle(copyRowCell, this.wbh);
                    copyCellHandle.setWorkSheetHandle(this);
                    int colnum = copyCellHandle.getColNum();
                    if (copyRowCell.getOpcode() == 6 && flag != 2 && flag != 3) {
                        try {
                            newCellHandle = this.add((Object)copyCellHandle.getFormulaHandle().getFormulaString(), rownum, colnum);
                            if (newCellHandle == null) {
                                try {
                                    newCellHandle = this.getCell(rownum, colnum);
                                }
                                catch (CellNotFoundException cellNotFoundException) {
                                    // empty catch block
                                }
                            }
                            ReferenceTracker.adjustFormulaRefs(newCellHandle, refMovementRow, refMovementDiff * -1, true);
                            newCellHandle.getFormulaHandle().getFormulaRec().clearCachedValue();
                        }
                        catch (Exception e) {
                            if (this.DEBUGLEVEL > 0) {
                                Logger.logWarn("WorkSheetHandle.shiftRow() could not adjust formula references in formula: " + copyCellHandle + " while inserting new row." + e.toString());
                            }
                            break block33;
                        }
                    }
                    newCellHandle = this.add(null, rownum, colnum);
                    if (newCellHandle == null) {
                        try {
                            newCellHandle = this.getCell(rownum, colnum);
                        }
                        catch (CellNotFoundException e) {
                            // empty catch block
                        }
                    }
                }
                newCellHandle.setFormatId(copyCellHandle.getFormatId());
                CellRange oby = copyCellHandle.getMergedCellRange();
                if (oby != null) {
                    int[] fr = new int[]{rownum, oby.firstcellcol};
                    int[] lr = new int[]{rownum, oby.lastcellcol};
                    String newrng = String.valueOf(sheetname) + "!" + ExcelTools.formatLocation(fr) + ":" + ExcelTools.formatLocation(lr);
                    newrng = GenericPtg.qualifySheetname(newrng);
                    if (this.DEBUGLEVEL > 10) {
                        Logger.logInfo("WorksheetHandle.insertRow() created new Merge Range: " + newrng);
                    }
                    if (newmerges.get(newrng) == null) {
                        newmerge = new CellRange(newrng, this.wbh, true);
                        if (this.DEBUGLEVEL > 10) {
                            Logger.logInfo("WorksheetHandle.insertRow() created new Merge Range: " + newrng);
                        }
                        newmerges.put(newmerge.toString(), newmerge);
                    }
                }
                ++i;
            }
            Collection xl = newmerges.values();
            if (xl != null) {
                Iterator itx = xl.iterator();
                while (itx.hasNext()) {
                    ((CellRange)itx.next()).mergeCells(true);
                }
            }
        }
        if ((images = this.mysheet.getImages()) != null) {
            int i = 0;
            while (i < images.length) {
                ImageHandle ih = images[i];
                int row = ih.getRow();
                if (row >= rownum) {
                    short h = ih.getHeight();
                    ih.setRow(row + 1);
                    ih.setHeight(h);
                }
                ++i;
            }
        }
        List charts = this.mysheet.getCharts();
        int i = 0;
        while (i < charts.size()) {
            Chart c = (Chart)charts.get(i);
            ReferenceTracker.insertChartSeries(c, GenericPtg.qualifySheetname(this.getSheetName()), rownum);
            int row = c.getRow0();
            if (row >= rownum) {
                int h = c.getHeight();
                c.setRow(row + offset);
                c.setHeight(h);
            }
            ++i;
        }
        return true;
    }

    public ConditionalFormatHandle[] getConditionalFormatHandles() {
        ConditionalFormatHandle[] cfx = new ConditionalFormatHandle[this.mysheet.getConditionalFormats().size()];
        int i = 0;
        while (i < cfx.length) {
            Condfmt cfmt = (Condfmt)this.mysheet.getConditionalFormats().get(i);
            cfx[i] = new ConditionalFormatHandle(cfmt, this);
            ++i;
        }
        return cfx;
    }

    public WorkBookHandle getWorkBook() {
        return this.wbh;
    }

    public ImageHandle getImage(String name) throws ImageNotFoundException {
        int idz = this.mysheet.getImageVect().indexOf(name);
        if (idz > 0) {
            return (ImageHandle)this.mysheet.getImageVect().get(idz);
        }
        throw new ImageNotFoundException("Could not find " + name + " in " + this.getSheetName());
    }

    public ImageHandle[] getImages() {
        return this.mysheet.getImages();
    }

    public int getNumImages() {
        return this.mysheet.imageMap.size();
    }

    public void extractImagesToDirectory(String outdir) {
        ImageHandle[] extracted = this.getImages();
        int tx = 0;
        while (tx < extracted.length) {
            String n = extracted[tx].getName();
            if (n.equals("")) {
                n = "image" + extracted[tx].getMsodrawing().getImageIndex();
            }
            String imgname = String.valueOf(n) + "." + extracted[tx].getType();
            if (this.DEBUGLEVEL > 0) {
                Logger.logInfo("Successfully extracted: " + outdir + imgname);
            }
            try {
                FileOutputStream outimg = new FileOutputStream(String.valueOf(outdir) + imgname);
                extracted[tx].write(outimg);
                outimg.flush();
                outimg.close();
            }
            catch (Exception ex) {
                Logger.logErr("Could not extract images from: " + this);
            }
            ++tx;
        }
    }

    public void extractChartToDirectory(String outdir) {
        ArrayList charts = (ArrayList)this.mysheet.getCharts();
        String sheetname = this.getSheetName();
        int i = 0;
        while (i < charts.size()) {
            ChartHandle ch = new ChartHandle((Chart)charts.get(i), this.getWorkBook());
            String fname = String.valueOf(sheetname) + "_Chart" + ch.getId() + ".svg";
            try {
                FileOutputStream chartout = new FileOutputStream(String.valueOf(outdir) + fname);
                chartout.write(ch.getSVG(1.0).getBytes());
            }
            catch (Exception ex) {
                Logger.logErr("extractChartToDirectory: Could not extract charts from: " + this + ":" + ex.toString());
            }
            ++i;
        }
    }

    public void insertImage(ImageHandle im) {
        this.mysheet.insertImage(im);
    }

    public void insertCols(int first, int count) {
        if (first < 0) {
            throw new IllegalArgumentException("column index must be zero or greater");
        }
        if (count < 1) {
            throw new IllegalArgumentException("count must be at least one");
        }
        this.mysheet.insertCols(first, count);
    }

    @Deprecated
    public void insertCol(int colnum) {
        this.insertCols(colnum, 1);
    }

    @Deprecated
    public void insertCol(String colnum) {
        this.insertCols(ExcelTools.getIntVal(colnum), 1);
    }

    public void setCopyFormatsFromPriorWhenAdding(boolean f) {
        this.mysheet.setCopyPriorCellFormats(f);
    }

    public CellHandle add(Object obj, int row, int col) {
        return this.add(obj, row, col, this.getWorkBook().getWorkBook().getDefaultIxfe());
    }

    public CellHandle[] addValidated(Object obj, int row, int col) throws ValidationException {
        return this.addValidated(obj, row, col, this.getWorkBook().getWorkBook().getDefaultIxfe());
    }

    public CellHandle[] addValidated(Object obj, int row, int col, int formatId) throws ValidationException {
        int[] rc = new int[]{row, col};
        ValidationHandle vh = this.getValidationHandle(ExcelTools.formatLocation(rc));
        if (vh != null) {
            vh.isValid(obj);
        }
        return this.addValidated(obj, ExcelTools.formatLocation(rc));
    }

    public CellHandle add(Object obj, int row, int col, int formatId) {
        int[] rc = new int[]{row, col};
        if (obj instanceof Date) {
            String address = ExcelTools.formatLocation(rc);
            this.add((Date)obj, address, null);
        } else {
            BiffRec reca = this.mysheet.addValue(obj, rc, formatId);
            if (this.DEBUGLEVEL > 1) {
                if (reca != null) {
                    Logger.logInfo("WorkSheetHandle.add() " + reca.toString() + " Successfully Added.");
                } else {
                    return null;
                }
            }
        }
        if (!this.mysheet.fastCellAdds) {
            try {
                CellHandle c = this.getCell(row, col);
                if (this.wbh.getFormulaCalculationMode() != 1) {
                    c.clearAffectedCells();
                }
                return c;
            }
            catch (CellNotFoundException e) {
                Logger.logInfo("Adding Cell to row failed row:" + row + " col: " + col + " failed.");
                return null;
            }
        }
        return null;
    }

    public void fastAdd(Object obj, int row, int col, int formatId) {
        int[] rc = new int[]{row, col};
        if (formatId == -1) {
            formatId = 0;
        }
        if (obj instanceof Date) {
            String address = ExcelTools.formatLocation(rc);
            this.add((Date)obj, address, null);
        } else {
            BiffRec reca = this.mysheet.addValue(obj, rc, formatId);
            if (this.wbh.getFormulaCalculationMode() != 1) {
                ReferenceTracker rt = this.wbh.getWorkBook().getRefTracker();
                rt.clearAffectedFormulaCells(reca);
            }
            if (this.DEBUGLEVEL > 1 && reca != null) {
                Logger.logInfo("WorkSheetHandle.add() " + reca.toString() + " Successfully Added.");
            }
        }
    }

    public void setFastCellAdds(boolean fastadds) {
        this.mysheet.setFastCellAdds(fastadds);
    }

    public boolean getFastCellAdds() {
        return this.mysheet.fastCellAdds;
    }

    public CellHandle add(Object obj, String address, boolean autoDetectValue) {
        if (obj == null) {
            this.mysheet.addValue(obj, address);
        } else if (obj instanceof Date) {
            this.add((Date)obj, address, null);
        } else {
            this.mysheet.addValue(obj, address, autoDetectValue);
        }
        if (this.mysheet.fastCellAdds) {
            return null;
        }
        try {
            return this.getCell(address);
        }
        catch (CellNotFoundException e) {
            Logger.logInfo("Adding Cell: " + address + " failed");
            return null;
        }
    }

    public CellHandle add(Object obj, String address) {
        if (obj == null) {
            this.mysheet.addValue(obj, address);
        } else if (obj instanceof Date) {
            this.add((Date)obj, address, null);
        } else {
            this.mysheet.addValue(obj, address);
        }
        if (!this.mysheet.fastCellAdds) {
            try {
                CellHandle c = this.getCell(address);
                if (this.wbh.getFormulaCalculationMode() != 1) {
                    c.clearAffectedCells();
                }
                return c;
            }
            catch (CellNotFoundException e) {
                Logger.logInfo("Adding Cell: " + address + " failed");
                return null;
            }
        }
        return null;
    }

    public CellHandle[] addValidated(Object obj, String address) throws ValidationException {
        ValidationHandle vh = this.getValidationHandle(address);
        if (vh != null) {
            vh.isValid(obj);
        }
        CellHandle ch = this.add(obj, address);
        List<CellHandle> cxrs = ch.calculateAffectedCellsOnSheet();
        CellHandle[] cxrx = new CellHandle[cxrs.size() + 1];
        cxrx[0] = ch;
        int t = 1;
        while (t < cxrx.length) {
            cxrx[t] = cxrs.get(t - 1);
            cxrx[t].setWorkSheetHandle(this);
            ++t;
        }
        return cxrx;
    }

    public CellHandle add(Timestamp dt, String address, String fmt) {
        if (fmt == null) {
            fmt = "m/d/yyyy h:mm:ss";
        }
        Date dx = new Date(dt.getTime());
        return this.add(dx, address, fmt);
    }

    public CellHandle[] addValidated(Timestamp dt, String address, String fmt) throws ValidationException {
        if (fmt == null) {
            fmt = "m/d/yyyy h:mm:ss";
        }
        Date dx = new Date(dt.getTime());
        return this.addValidated(dx, address, fmt);
    }

    public CellHandle add(Date dt, String address, String fmt) {
        int[] rc = ExcelTools.getRowColFromString(address);
        return this.add(dt, rc[0], rc[1], fmt);
    }

    public CellHandle[] addValidated(Date dt, String address, String fmt) throws ValidationException {
        int[] rc = ExcelTools.getRowColFromString(address);
        return this.addValidated(dt, rc[0], rc[1], fmt);
    }

    public CellHandle add(Date dt, int row, int col, String fmt) {
        double x = DateConverter.getXLSDateVal(dt, this.mybook.getDateFormat());
        CellHandle thisCell = this.add((Object)new Double(x), row, col);
        if (thisCell == null && this.mysheet.fastCellAdds) {
            try {
                thisCell = this.getCell(row, col);
            }
            catch (CellNotFoundException exp) {
                Logger.logWarn("adding date to WorkSheet failed: " + this.getSheetName() + ":" + row + ":" + col);
                return null;
            }
        }
        if (fmt == null && ((fmt = thisCell.getFormatPattern()) == null || fmt.equals("General"))) {
            fmt = "m/d/yy h:mm";
        }
        if (this.dateFormats.get(fmt) == null) {
            FormatHandle fh = thisCell.getFormatHandle();
            fh.setFormatPattern(fmt);
            this.dateFormats.put(fmt, thisCell.getFormatId());
        } else {
            Integer in = (Integer)this.dateFormats.get(fmt);
            thisCell.setFormatId(in);
        }
        return thisCell;
    }

    public CellHandle[] addValidated(Date dt, int row, int col, String fmt) throws ValidationException {
        int[] rc = new int[]{row, col};
        ValidationHandle vh = this.getValidationHandle(ExcelTools.formatLocation(rc));
        if (vh != null) {
            vh.isValid(dt);
        }
        CellHandle ch = this.add(dt, row, col, fmt);
        List<CellHandle> cxrs = ch.calculateAffectedCellsOnSheet();
        CellHandle[] cxrx = new CellHandle[cxrs.size() + 1];
        cxrx[0] = ch;
        int t = 1;
        while (t < cxrx.length) {
            cxrx[t] = cxrs.get(t - 1);
            ++t;
        }
        return cxrx;
    }

    public void remove() {
        this.mybook.removeWorkSheet(this.mysheet);
        this.wbh.sheethandles.remove(this.getSheetName());
    }

    public CellRange getCellRange(String rangeName) throws CellNotFoundException {
        CellRange cr = new CellRange(String.valueOf(this.getSheetName()) + "!" + rangeName, this.getWorkBook());
        return cr;
    }

    public CellHandle[] getCells() {
        BiffRec[] cells = this.mysheet.getCells();
        CellHandle[] retval = new CellHandle[cells.length];
        Mulblank aMul = null;
        int c = -1;
        int i = 0;
        while (i < retval.length) {
            block9: {
                try {
                    if (cells[i].getOpcode() != 190) {
                        retval[i] = this.getCell(cells[i].getRowNumber(), cells[i].getColNumber());
                    } else {
                        if (cells[i] == aMul) {
                            c = (short)(c + 1);
                        } else {
                            aMul = (Mulblank)cells[i];
                            c = (short)aMul.getColFirst();
                        }
                        retval[i] = this.getCell(cells[i].getRowNumber(), c);
                    }
                }
                catch (CellNotFoundException cnfe) {
                    retval[i] = new CellHandle(cells[i], this.wbh);
                    retval[i].setWorkSheetHandle(this);
                    if (cells[i].getOpcode() != 190) break block9;
                    if (cells[i] == aMul) {
                        c = (short)(c + 1);
                    } else {
                        aMul = (Mulblank)cells[i];
                        c = (short)aMul.getColFirst();
                    }
                    retval[i].setBlankRef(c);
                }
            }
            ++i;
        }
        return retval;
    }

    public FormulaHandle getFormula(String addr) throws FormulaNotFoundException, CellNotFoundException {
        CellHandle c = this.getCell(addr);
        return c.getFormulaHandle();
    }

    public CellHandle getCell(String addr) throws CellNotFoundException {
        CellHandle ret = null;
        BiffRec c = this.mysheet.getCell(addr.toUpperCase());
        if (c == null) {
            String sn = "";
            try {
                sn = this.getSheetName();
                sn = String.valueOf(sn) + "!";
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (addr == null) {
                addr = "undefined cell address";
            }
            throw new CellNotFoundException(String.valueOf(sn) + addr);
        }
        ret = new CellHandle(c, this.wbh);
        ret.setWorkSheetHandle(this);
        return ret;
    }

    public CellHandle getCell(int row, int col) throws CellNotFoundException {
        return this.getCell(row, col, false);
    }

    public CellHandle getCell(int row, int col, boolean cache) throws CellNotFoundException {
        CellHandle ret = null;
        if (cache) {
            int[] rc = new int[]{row, col};
            String address = ExcelTools.formatLocation(rc);
            if (ret != null) {
                return ret;
            }
            ret = new CellHandle(this.mysheet.getCell(row, col), this.wbh);
            ret.setWorkSheetHandle(this);
            return ret;
        }
        ret = new CellHandle(this.mysheet.getCell(row, col), this.wbh);
        ret.setWorkSheetHandle(this);
        return ret;
    }

    public void moveCell(CellHandle c, String addr) throws CellPositionConflictException {
        this.mysheet.moveCell(c.getCellAddress(), addr);
    }

    public String getFooterText() {
        return this.mysheet.getFooter().getFooterText();
    }

    public String getHeaderText() {
        return this.mysheet.getHeader().getHeaderText();
    }

    public String getPrintArea() {
        return this.mysheet.getPrintArea();
    }

    public String getPrintTitles() {
        return this.mysheet.getPrintTitles();
    }

    public PrinterSettingsHandle getPrinterSettings() {
        return this.mysheet.getPrinterSetupHandle();
    }

    public void setPrintArea(CellRange printarea) {
        this.mysheet.setPrintArea(printarea.getRange());
    }

    public void setHeaderText(String t) {
        this.mysheet.getHeader().setHeaderText(t);
    }

    public void setFooterText(String t) {
        this.mysheet.getFooter().setFooterText(t);
    }

    public void setDefaultColWidth(int t) {
        this.mysheet.setDefaultColumnWidth(t);
    }

    public int getDefaultColWidth() {
        return (int)this.mysheet.getDefaultColumnWidth();
    }

    public String toString() {
        return this.mysheet.toString();
    }

    public Boundsheet getMysheet() {
        return this.mysheet;
    }

    public List calculateAffectedCells(String CellAddress) {
        CellHandle c = null;
        try {
            c = this.getCell(CellAddress);
        }
        catch (CellNotFoundException e) {
            return null;
        }
        return c.calculateAffectedCells();
    }

    public boolean getShowFormulaResults() {
        return this.mysheet.getWindow2().getShowFormulaResults();
    }

    public void setShowFormulaResults(boolean b) {
        this.mysheet.getWindow2().setShowFormulaResults(b);
    }

    public boolean getShowGridlines() {
        return this.mysheet.getWindow2().getShowGridlines();
    }

    public void setShowGridlines(boolean b) {
        this.mysheet.getWindow2().setShowGridlines(b);
    }

    public boolean getShowSheetHeaders() {
        return this.mysheet.getWindow2().getShowSheetHeaders();
    }

    public void setShowSheetHeaders(boolean b) {
        this.mysheet.getWindow2().setShowSheetHeaders(b);
    }

    public boolean getShowZeroValues() {
        return this.mysheet.getWindow2().getShowZeroValues();
    }

    public void setShowZeroValues(boolean b) {
        this.mysheet.getWindow2().setShowZeroValues(b);
    }

    public boolean getShowOutlineSymbols() {
        return this.mysheet.getWindow2().getShowOutlineSymbols();
    }

    public void setShowOutlineSymbols(boolean b) {
        this.mysheet.getWindow2().setShowOutlineSymbols(b);
    }

    public boolean getShowInNormalView() {
        return this.mysheet.getWindow2().getShowInNormalView();
    }

    public void setShowInNormalView(boolean b) {
        this.mysheet.getWindow2().setShowInNormalView(!b);
    }

    public boolean hasFrozenPanes() {
        return this.mysheet.getWindow2().getFreezePanes();
    }

    public void setHasFrozenPanes(boolean b) {
        this.mysheet.getWindow2().setFreezePanes(b);
        if (!b && this.mysheet.getPane() != null) {
            this.mysheet.removePane();
        }
    }

    public void setZoom(float zm) {
        this.mysheet.getScl().setZoom(zm);
    }

    public String getTopLeftCell() {
        if (this.mysheet.getPane() != null) {
            return this.mysheet.getPane().getTopLeftCell();
        }
        return null;
    }

    public float getZoom() {
        return this.mysheet.getScl().getZoom();
    }

    public void freezeRow(int row) {
        if (this.mysheet.getPane() == null) {
            this.mysheet.setPane(null);
        }
        this.mysheet.getPane().setFrozenRow(row);
    }

    public void freezeCol(int col) {
        if (this.mysheet.getPane() == null) {
            this.mysheet.setPane(null);
        }
        this.mysheet.getPane().setFrozenColumn(col);
    }

    public void splitCol(int col, int splitpos) {
        if (this.mysheet.getPane() == null) {
            this.mysheet.setPane(null);
        }
        this.mysheet.getPane().setSplitColumn(col, splitpos);
    }

    public void splitRow(int row, int splitpos) {
        if (this.mysheet.getPane() == null) {
            this.mysheet.setPane(null);
        }
        this.mysheet.getPane().setSplitRow(row, splitpos);
    }

    public int getSplitRowLocation() {
        if (this.mysheet.getPane() == null) {
            return -1;
        }
        return this.mysheet.getPane().getVisibleRow();
    }

    public int getSplitColLocation() {
        if (this.mysheet.getPane() == null) {
            return -1;
        }
        return this.mysheet.getPane().getVisibleCol();
    }

    public int getSplitLocation() {
        if (this.mysheet.getPane() == null) {
            return -1;
        }
        return this.mysheet.getPane().getRowSplitLoc();
    }

    public boolean getManualGridLineColor() {
        return this.mysheet.getWindow2().getManualGridLineColor();
    }

    public void setManualGridLineColor(boolean b) {
        this.mysheet.getWindow2().setManualGridLineColor(b);
    }

    public CompatibleVector getAddedrows() {
        return this.addedrows;
    }

    public ConditionalFormatHandle createConditionalFormatHandle(String cellAddress, String operator, String value1, String value2, String format, String firstCondition, String secondCondition) {
        if (cellAddress != null && cellAddress.indexOf("!") == -1) {
            cellAddress = String.valueOf(this.getSheetName()) + "!" + cellAddress;
        }
        Condfmt cfm = this.mysheet.createCondfmt(cellAddress, this.wbh);
        Cf cfr = this.mysheet.createCf(cfm);
        cfr.setOperator(operator);
        cfr.setCondition1(value1);
        cfr.setCondition2(value2);
        Cf.setStylePropsFromString(format, cfr);
        ConditionalFormatHandle cfh = new ConditionalFormatHandle(cfm, this);
        return cfh;
    }

    public CommentHandle createNote(String address, String txt, String author) {
        Note n = this.getMysheet().createNote(address, txt, author);
        return new CommentHandle(n);
    }

    public CommentHandle createNote(String address, Unicodestring txt, String author) {
        Note n = this.getMysheet().createNote(address, txt, author);
        return new CommentHandle(n);
    }

    public CommentHandle[] getCommentHandles() {
        ArrayList notes = this.getMysheet().getNotes();
        CommentHandle[] nHandles = new CommentHandle[notes.size()];
        int i = 0;
        while (i < nHandles.length) {
            nHandles[i] = new CommentHandle((Note)notes.get(i));
            ++i;
        }
        return nHandles;
    }

    public PivotTableHandle createPivotTable(String name, String range, int sId) {
        Sxview sx = this.getMysheet().addPivotTable(range, this.wbh, sId, name);
        PivotTableHandle pth = new PivotTableHandle(sx, this.getWorkBook());
        pth.setSourceDataRange(range);
        return pth;
    }

    public ValidationHandle getValidationHandle(String cellAddress) {
        if (this.mysheet.getDvalRec() != null) {
            Dv d = this.mysheet.getDvalRec().getDv(cellAddress);
            if (d == null) {
                return null;
            }
            return new ValidationHandle(d);
        }
        return null;
    }

    public ValidationHandle createValidationHandle(String cellAddress, byte valueType, byte condition, String errorBoxText, String errorBoxTitle, String promptBoxText, String promptBoxTitle, String firstCondition, String secondCondition) {
        Dv d = this.mysheet.createDv(cellAddress);
        d.setValType(valueType);
        d.setTypeOperator(condition);
        d.setErrorBoxText(errorBoxText);
        d.setErrorBoxTitle(errorBoxTitle);
        d.setPromptBoxText(promptBoxText);
        d.setPromptBoxTitle(promptBoxTitle);
        if (firstCondition != null) {
            d.setFirstCond(firstCondition);
        }
        if (secondCondition != null) {
            d.setSecondCond(secondCondition);
        }
        ValidationHandle vh = new ValidationHandle(d);
        return vh;
    }

    public ValidationHandle[] getAllValidationHandles() {
        if (this.mysheet.getDvRecs() == null) {
            return new ValidationHandle[0];
        }
        ValidationHandle[] vh = new ValidationHandle[this.mysheet.getDvRecs().size()];
        List dvrecs = this.mysheet.getDvRecs();
        int i = 0;
        while (i < vh.length) {
            vh[i] = new ValidationHandle((Dv)dvrecs.get(i));
            ++i;
        }
        return vh;
    }

    public boolean hasDataValidations() {
        return this.mysheet.getDvRecs() != null;
    }

    public AutoFilterHandle[] getAutoFilterHandles() {
        if (this.mysheet.getAutoFilters() == null) {
            return null;
        }
        AutoFilterHandle[] af = new AutoFilterHandle[this.mysheet.getAutoFilters().size()];
        List afs = this.mysheet.getAutoFilters();
        int i = 0;
        while (i < afs.size()) {
            af[i] = new AutoFilterHandle((AutoFilter)afs.get(i));
            ++i;
        }
        return af;
    }

    public AutoFilterHandle addAutoFilter(int column) {
        AutoFilter af = this.mysheet.addAutoFilter(column);
        return new AutoFilterHandle(af);
    }

    public void removeAutoFilters() {
        this.mysheet.removeAutoFilter();
    }

    public void evaluateAutoFilters() {
        this.mysheet.evaluateAutoFilters();
    }

    public void close() {
        if (this.mysheet != null) {
            this.mysheet.close();
        }
        this.addedrows.clear();
        this.addedrows = new CompatibleVector();
        this.mysheet = null;
        this.mybook = null;
        this.wbh = null;
        this.dateFormats.clear();
        this.dateFormats = null;
    }

    protected Boundsheet getBoundsheet() {
        return this.mysheet;
    }

    public void readCSV(BufferedReader input) throws IOException {
        int rws = 0;
        String field_delimiter = System.getProperty("com.extentech.extenxls.csvdelimiter", ",");
        String thisLine = "";
        while ((thisLine = input.readLine()) != null) {
            String[] vals = StringTool.getTokensUsingDelim(thisLine, field_delimiter);
            Object[] data = new Object[vals.length];
            int t = 0;
            while (t < vals.length) {
                vals[t] = StringTool.strip(vals[t], '\"');
                try {
                    int i = Integer.parseInt(vals[t]);
                    data[t] = i;
                    double d = Double.parseDouble(vals[t]);
                    data[t] = new Double(d);
                }
                catch (NumberFormatException ax) {
                    data[t] = vals[t];
                }
                ++t;
            }
            this.insertRow(rws++, data, true);
        }
    }
}

