/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.LEO;

import com.extentech.formats.LEO.Block;
import com.extentech.formats.LEO.BlockByteConsumer;
import com.extentech.formats.XLS.WorkBookException;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class BlockByteReader
implements Serializable {
    private static final long serialVersionUID = 4845306509411520019L;
    private boolean applyRelativePosition = true;
    private List blockmap = new ArrayList();
    private boolean ro = false;
    private int length = -1;
    transient ByteBuffer backingByteBuffer = ByteBuffer.allocate(0);

    protected BlockByteReader() {
    }

    public BlockByteReader(List blokz, int len) {
        this.blockmap = blokz;
        this.length = len;
    }

    public boolean isReadOnly() {
        return this.ro;
    }

    public byte[] getHeaderBytes(int startpos) {
        try {
            int SIZE = 512;
            if (this.length < 4096) {
                SIZE = 64;
            }
            int block = startpos / SIZE;
            int check = startpos % SIZE;
            if (check + 4 > SIZE && this.blockmap.size() - 1 == block) {
                byte[] junk = new byte[4];
                return junk;
            }
            if (check + 4 > SIZE) {
                Block bx = (Block)this.blockmap.get(block);
                int l1 = SIZE * (block + 1) - startpos;
                int s2 = startpos % SIZE;
                byte[] b1 = bx.getBytes(s2, s2 + l1);
                bx = (Block)this.blockmap.get(block + 1);
                l1 = 4 - l1;
                byte[] b2 = bx.getBytes(0, l1);
                return ByteTools.append(b2, b1);
            }
            Block bx = (Block)this.blockmap.get(block);
            return bx.getBytes(startpos -= block * SIZE, startpos + 4);
        }
        catch (RuntimeException e) {
            throw new WorkBookException("Smallblock based workbooks are unsupported in ExtenXLS: see http://extentech.com/uimodules/docs/docs_detail.jsp?showall=true&meme_id=195", 5);
        }
    }

    public byte get(BlockByteConsumer rec, int startpos) {
        byte ret = this.get(rec, startpos, 1)[0];
        return ret;
    }

    public byte[] get(BlockByteConsumer rec, int startpos, int len) {
        rec.setByteReader(this);
        int recoffy = rec.getOffset();
        if (this.getApplyRelativePosition()) {
            startpos += 4;
        }
        return this.getRecBytes(rec, startpos += recoffy, len);
    }

    private byte[] getRecBytes(BlockByteConsumer rec, int startpos, int len) {
        if (startpos < 0 || startpos > startpos + len) {
            throw new RuntimeException("ERROR: BBR.getRecBytes(" + rec.getClass().getName() + "," + startpos + "," + (startpos + len) + ") failed - OUT OF BOUNDS.");
        }
        int[] pos = this.getReadPositions(startpos, len);
        int numblocks = pos.length / 3;
        int blkdef = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int t = 0;
        while (t < numblocks) {
            try {
                Block b1 = (Block)this.blockmap.get(pos[blkdef++]);
                out.write(b1.getBytes(pos[blkdef++], pos[blkdef++]));
            }
            catch (Exception a) {
                Logger.logWarn("ERROR: BBR.getRecBytes streaming " + rec.toString() + " bytes for block failed: " + a);
            }
            ++t;
        }
        return out.toByteArray();
    }

    public static int[] getReadPositions(int startpos, int len, boolean BIGBLOCKSTORAGE) {
        int SIZE = 512;
        if (!BIGBLOCKSTORAGE) {
            SIZE = 64;
        }
        int firstblock = startpos / SIZE;
        int lastblock = (startpos + len) / SIZE;
        int numblocks = lastblock - firstblock;
        int origlen = len;
        int ct = startpos / SIZE;
        int pos1 = startpos;
        int[] ret = new int[++numblocks * 3];
        int t = 0;
        while (len > 0) {
            if (t >= ret.length) {
                Logger.logWarn("BlockByteReader.getReadPositions() wrong guess on NumBlocks.");
                int[] retz = new int[++numblocks * 3];
                System.arraycopy(ret, 0, retz, 0, ret.length);
                ret = retz;
            }
            ret[t++] = firstblock++;
            int check = pos1 % SIZE;
            if ((check += len) > SIZE) {
                int s2;
                pos1 = startpos - SIZE * ct;
                if (pos1 < 0) {
                    pos1 = 0;
                }
                if ((s2 = pos1 % SIZE) < 0) {
                    s2 = 0;
                    pos1 = 0;
                }
                ret[t++] = s2;
                ret[t++] = SIZE;
            } else {
                pos1 = startpos - SIZE * ct;
                int strt = startpos - SIZE * ct;
                if (strt < 0) {
                    ret[t++] = 0;
                    ret[t++] = len;
                } else {
                    ret[t++] = strt;
                    ret[t++] = startpos + origlen - SIZE * ct;
                }
            }
            ++ct;
            int ctdn = ret[t - 1] - pos1;
            len -= ctdn;
            pos1 = 0;
        }
        return ret;
    }

    public int[] getReadPositions(int startpos, int len) {
        return BlockByteReader.getReadPositions(startpos, len, this.length >= 4096);
    }

    public int[] getFileOffsets(int start, int size) {
        int[] smap = this.getReadPositions(start, size);
        int[] fmap = new int[smap.length / 3 * 2];
        int offset = 0;
        int fidx = 0;
        Block block = null;
        int sidx = 0;
        while (sidx < smap.length) {
            Block prev = block;
            block = (Block)this.blockmap.get(smap[sidx]);
            if (prev == null || block.getOriginalPos() + smap[sidx + 1] != prev.getOriginalPos() + smap[sidx - 1]) {
                fmap[fidx++] = offset;
                fmap[fidx++] = block.getOriginalPos() + smap[sidx + 1];
            }
            offset += smap[sidx + 2] - smap[sidx + 1];
            sidx += 3;
        }
        int[] ret = new int[fidx];
        System.arraycopy(fmap, 0, ret, 0, fidx);
        return ret;
    }

    public String getFileOffsetString(int start, int size) {
        String ret = "";
        int[] map = this.getFileOffsets(start, size);
        int idx = 0;
        while (idx < map.length) {
            ret = String.valueOf(ret) + (idx != 0 ? " " : "") + Integer.toHexString(map[idx + 0]).toUpperCase() + ":" + Integer.toHexString(map[idx + 1]).toUpperCase();
            idx += 2;
        }
        return ret;
    }

    public List getBlockmap() {
        return this.blockmap;
    }

    public void setBlockmap(AbstractList list) {
        this.blockmap = list;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int i) {
        this.length = i;
    }

    public static ByteBuffer allocate(int arg0) {
        return ByteBuffer.allocate(arg0);
    }

    public static ByteBuffer allocateDirect(int arg0) {
        return ByteBuffer.allocateDirect(arg0);
    }

    public static final ByteBuffer wrap(byte[] arg0) {
        return ByteBuffer.wrap(arg0);
    }

    public static final ByteBuffer wrap(byte[] arg0, int arg1, int arg2) {
        return ByteBuffer.wrap(arg0, arg1, arg2);
    }

    public byte[] array() {
        return this.backingByteBuffer.array();
    }

    public int arrayOffset() {
        return this.backingByteBuffer.arrayOffset();
    }

    public CharBuffer asCharBuffer() {
        return this.backingByteBuffer.asCharBuffer();
    }

    public DoubleBuffer asDoubleBuffer() {
        return this.backingByteBuffer.asDoubleBuffer();
    }

    public FloatBuffer asFloatBuffer() {
        return this.backingByteBuffer.asFloatBuffer();
    }

    public IntBuffer asIntBuffer() {
        return this.backingByteBuffer.asIntBuffer();
    }

    public LongBuffer asLongBuffer() {
        return this.backingByteBuffer.asLongBuffer();
    }

    public ByteBuffer asReadOnlyBuffer() {
        return this.backingByteBuffer.asReadOnlyBuffer();
    }

    public ShortBuffer asShortBuffer() {
        return this.backingByteBuffer.asShortBuffer();
    }

    public int capacity() {
        return this.backingByteBuffer.capacity();
    }

    public Buffer clear() {
        return this.backingByteBuffer.clear();
    }

    public ByteBuffer compact() {
        return this.backingByteBuffer.compact();
    }

    public ByteBuffer duplicate() {
        return this.backingByteBuffer.duplicate();
    }

    public boolean equals(Object arg0) {
        return this.backingByteBuffer.equals(arg0);
    }

    public Buffer flip() {
        return this.backingByteBuffer.flip();
    }

    public byte get() {
        return this.backingByteBuffer.get();
    }

    public ByteBuffer get(byte[] arg0) {
        return this.backingByteBuffer.get(arg0);
    }

    public ByteBuffer get(byte[] arg0, int arg1, int arg2) {
        return this.backingByteBuffer.get(arg0, arg1, arg2);
    }

    public char getChar() {
        return this.backingByteBuffer.getChar();
    }

    public char getChar(int arg0) {
        return this.backingByteBuffer.getChar(arg0);
    }

    public double getDouble() {
        return this.backingByteBuffer.getDouble();
    }

    public double getDouble(int arg0) {
        return this.backingByteBuffer.getDouble(arg0);
    }

    public float getFloat() {
        return this.backingByteBuffer.getFloat();
    }

    public float getFloat(int arg0) {
        return this.backingByteBuffer.getFloat(arg0);
    }

    public int getInt() {
        return this.backingByteBuffer.getInt();
    }

    public int getInt(int arg0) {
        return this.backingByteBuffer.getInt(arg0);
    }

    public long getLong() {
        return this.backingByteBuffer.getLong();
    }

    public long getLong(int arg0) {
        return this.backingByteBuffer.getLong(arg0);
    }

    public short getShort() {
        return this.backingByteBuffer.getShort();
    }

    public short getShort(int arg0) {
        return this.backingByteBuffer.getShort(arg0);
    }

    public boolean hasArray() {
        return this.backingByteBuffer.hasArray();
    }

    public int hashCode() {
        return this.backingByteBuffer.hashCode();
    }

    public boolean hasRemaining() {
        return this.backingByteBuffer.hasRemaining();
    }

    public boolean isDirect() {
        return this.backingByteBuffer.isDirect();
    }

    public int limit() {
        return this.backingByteBuffer.limit();
    }

    public Buffer limit(int arg0) {
        return this.backingByteBuffer.limit(arg0);
    }

    public Buffer mark() {
        return this.backingByteBuffer.mark();
    }

    public ByteOrder order() {
        return this.backingByteBuffer.order();
    }

    public ByteBuffer order(ByteOrder arg0) {
        return this.backingByteBuffer.order(arg0);
    }

    public int position() {
        return this.backingByteBuffer.position();
    }

    public Buffer position(int arg0) {
        return this.backingByteBuffer.position(arg0);
    }

    public ByteBuffer put(byte arg0) {
        return this.backingByteBuffer.put(arg0);
    }

    public ByteBuffer put(byte[] arg0) {
        return this.backingByteBuffer.put(arg0);
    }

    public ByteBuffer put(byte[] arg0, int arg1, int arg2) {
        return this.backingByteBuffer.put(arg0, arg1, arg2);
    }

    public ByteBuffer put(int arg0, byte arg1) {
        return this.backingByteBuffer.put(arg0, arg1);
    }

    public ByteBuffer put(ByteBuffer arg0) {
        return this.backingByteBuffer.put(arg0);
    }

    public ByteBuffer putChar(char arg0) {
        return this.backingByteBuffer.putChar(arg0);
    }

    public ByteBuffer putChar(int arg0, char arg1) {
        return this.backingByteBuffer.putChar(arg0, arg1);
    }

    public ByteBuffer putDouble(double arg0) {
        return this.backingByteBuffer.putDouble(arg0);
    }

    public ByteBuffer putDouble(int arg0, double arg1) {
        return this.backingByteBuffer.putDouble(arg0, arg1);
    }

    public ByteBuffer putFloat(float arg0) {
        return this.backingByteBuffer.putFloat(arg0);
    }

    public ByteBuffer putFloat(int arg0, float arg1) {
        return this.backingByteBuffer.putFloat(arg0, arg1);
    }

    public ByteBuffer putInt(int arg0) {
        return this.backingByteBuffer.putInt(arg0);
    }

    public ByteBuffer putInt(int arg0, int arg1) {
        return this.backingByteBuffer.putInt(arg0, arg1);
    }

    public ByteBuffer putLong(int arg0, long arg1) {
        return this.backingByteBuffer.putLong(arg0, arg1);
    }

    public ByteBuffer putLong(long arg0) {
        return this.backingByteBuffer.putLong(arg0);
    }

    public ByteBuffer putShort(int arg0, short arg1) {
        return this.backingByteBuffer.putShort(arg0, arg1);
    }

    public ByteBuffer putShort(short arg0) {
        return this.backingByteBuffer.putShort(arg0);
    }

    public int remaining() {
        return this.backingByteBuffer.remaining();
    }

    public Buffer reset() {
        return this.backingByteBuffer.reset();
    }

    public Buffer rewind() {
        return this.backingByteBuffer.rewind();
    }

    public ByteBuffer slice() {
        return this.backingByteBuffer.slice();
    }

    public String toString() {
        return this.backingByteBuffer.toString();
    }

    public ByteBuffer getBackingByteBuffer() {
        return this.backingByteBuffer;
    }

    public void setBackingByteBuffer(ByteBuffer buffer) {
        this.backingByteBuffer = buffer;
    }

    public boolean getApplyRelativePosition() {
        return this.applyRelativePosition;
    }

    public void setApplyRelativePosition(boolean b) {
        this.applyRelativePosition = b;
    }
}

