/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

public class Alignment
implements OOXMLElement {
    private static final long serialVersionUID = 995367747930839216L;
    private HashMap<String, String> attrs = null;

    public Alignment(HashMap<String, String> attrs) {
        this.attrs = attrs;
    }

    public Alignment(Alignment a) {
        this.attrs = a.attrs;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("alignment")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                            ++i;
                        }
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("alignment")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("alignment.parseOOXML: " + e.toString());
        }
        Alignment a = new Alignment(attrs);
        return a;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<alignment");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append("/>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Alignment(this);
    }

    public String getAlignment(String type) {
        if (this.attrs != null) {
            return this.attrs.get(type);
        }
        return null;
    }
}

