/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.Color;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import org.xmlpull.v1.XmlPullParser;

class BorderElement
implements OOXMLElement {
    private static final long serialVersionUID = -8040551653089261574L;
    private String style;
    private Color color;
    private String borderElement;

    public BorderElement(String style, Color c, String borderElement) {
        this.style = style;
        this.color = c;
        this.borderElement = borderElement;
    }

    public BorderElement(BorderElement b) {
        this.style = b.style;
        this.color = b.color;
        this.borderElement = b.borderElement;
    }

    public int getBorderSize() {
        int st = this.getBorderStyle();
        if (st <= 4) {
            return st + 1;
        }
        if (st == 7) {
            return 1;
        }
        if (st == 6 || st == 8 || st == 12) {
            return 3;
        }
        return 2;
    }

    public int getBorderStyle() {
        if (this.style == null || this.style.equals("none")) {
            return -1;
        }
        if (this.style.equals("thin")) {
            return 1;
        }
        if (this.style.equals("medium")) {
            return 2;
        }
        if (this.style.equals("dashed")) {
            return 3;
        }
        if (this.style.equals("dotted")) {
            return 4;
        }
        if (this.style.equals("thick")) {
            return 5;
        }
        if (this.style.equals("double")) {
            return 6;
        }
        if (this.style.equals("hair")) {
            return 7;
        }
        if (this.style.equals("mediumDashed")) {
            return 8;
        }
        if (this.style.equals("dashDot")) {
            return 9;
        }
        if (this.style.equals("mediumDashDot")) {
            return 10;
        }
        if (this.style.equals("dashDotDot")) {
            return 11;
        }
        if (this.style.equals("mediumDashDotDot")) {
            return 12;
        }
        if (this.style.equals("slantDashDot")) {
            return 13;
        }
        return -1;
    }

    public String getBorderColor() {
        if (this.color != null) {
            return this.color.getColorAsOOXMLRBG();
        }
        return null;
    }

    public int getBorderColorInt() {
        if (this.color != null) {
            return this.color.getColorInt();
        }
        return 0;
    }

    public BorderElement(String style, String val, String borderElement, WorkBookHandle bk) {
        this.style = style;
        if (style != null && val != null) {
            this.color = new Color("color", false, Color.COLORTYPERGB, val, 0.0, 0, bk.getWorkBook().getTheme());
        }
        this.borderElement = borderElement;
    }

    public BorderElement(String style, int val, String borderElement, WorkBookHandle bk) {
        this.style = style;
        if (style != null && val != -1) {
            this.color = new Color("color", false, Color.COLORTYPEINDEXED, String.valueOf(val), 0.0, 0, bk.getWorkBook().getTheme());
        }
        this.borderElement = borderElement;
    }

    public static BorderElement parseOOXML(XmlPullParser xpp, WorkBookHandle bk) {
        String style = null;
        Color c = null;
        String borderElement = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("color")) {
                        c = (Color)Color.parseOOXML(xpp, (short)0, bk);
                    } else {
                        if (xpp.getAttributeCount() > 0) {
                            style = xpp.getAttributeValue(0);
                        }
                        borderElement = tnm;
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals(borderElement)) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("borderElement.parseOOXML: " + e.toString());
        }
        BorderElement b = new BorderElement(style, c, borderElement);
        return b;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<" + this.borderElement);
        if (this.style != null) {
            ooxml.append(" style=\"" + this.style + "\">");
            if (this.color != null) {
                ooxml.append(this.color.getOOXML());
            }
            ooxml.append("</" + this.borderElement + ">");
        } else {
            ooxml.append("/>");
        }
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new BorderElement(this);
    }

    public String toString() {
        return String.valueOf(this.style != null ? this.style : "<none>") + " c:" + (this.color != null ? this.color.toString() : "<none>");
    }
}

