/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.RPr;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class Br
implements OOXMLElement {
    private static final long serialVersionUID = -1724086871866480013L;
    private RPr rp;

    public Br(RPr rp) {
        this.rp = rp;
    }

    public Br(Br b) {
        this.rp = b.rp;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:br>");
        if (this.rp != null) {
            ooxml.append(this.rp.getOOXML());
        }
        ooxml.append("</a:br>");
        return ooxml.toString();
    }

    public static Br parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        RPr rp = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("rPr")) {
                        lastTag.push(tnm);
                        rp = RPr.parseOOXML(xpp, lastTag, bk);
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("br")) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("br.parseOOXML: " + e.toString());
        }
        Br b = new Br(rp);
        return b;
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Br(this);
    }
}

