/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.BodyPr;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.P;
import com.extentech.formats.OOXML.StrRef;
import com.extentech.formats.XLS.Font;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class ChartText
implements OOXMLElement {
    private static final long serialVersionUID = -1175394918747218776L;
    StrRef strref = null;
    P para = null;
    BodyPr bpr = null;

    public ChartText(String s) {
        this.para = new P(s);
    }

    public ChartText(StrRef s, P para, BodyPr bpr) {
        this.strref = s;
        this.para = para;
        this.bpr = bpr;
    }

    public static ChartText parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        P para = null;
        BodyPr bpr = null;
        StrRef s = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block7: {
                    String endTag;
                    block5: {
                        String tnm;
                        block8: {
                            block6: {
                                if (eventType != 2) break block5;
                                tnm = xpp.getName();
                                if (!tnm.equals("p")) break block6;
                                lastTag.push(tnm);
                                para = (P)P.parseOOXML(xpp, lastTag, bk);
                                break block7;
                            }
                            if (!tnm.equals("bodyPr")) break block8;
                            lastTag.push(tnm);
                            bpr = (BodyPr)BodyPr.parseOOXML(xpp, lastTag);
                            break block7;
                        }
                        if (!tnm.equals("strRef")) break block7;
                        lastTag.push(tnm);
                        s = (StrRef)StrRef.parseOOXML(xpp, lastTag);
                        break block7;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("tx")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("chartText.parseOOXML: " + e.toString());
        }
        ChartText ct = new ChartText(s, para, bpr);
        return ct;
    }

    @Override
    public String getOOXML() {
        StringBuffer cooxml = new StringBuffer();
        cooxml.append("<c:tx>");
        if (this.strref == null) {
            cooxml.append("<c:rich>");
            if (this.bpr != null) {
                cooxml.append(this.bpr.getOOXML());
            } else {
                cooxml.append("<a:bodyPr/>");
            }
            cooxml.append("<a:lstStyle/>");
            if (this.para != null) {
                cooxml.append(this.para.getOOXML());
            }
            cooxml.append("</c:rich>");
        } else {
            cooxml.append(this.strref.getOOXML());
        }
        cooxml.append("</c:tx>");
        return cooxml.toString();
    }

    public String getTitle() {
        if (this.para != null) {
            return this.para.getTitle();
        }
        return "";
    }

    @Override
    public OOXMLElement cloneElement() {
        return new ChartText(this.strref, this.para, this.bpr);
    }

    public int getFontId(WorkBookHandle wb) {
        Object o;
        HashMap<Object, Object> textprops = new HashMap();
        if (this.para != null) {
            textprops = this.para.getTextProperties();
        }
        int w = 400;
        boolean u = false;
        double h = 200.0;
        boolean b = false;
        boolean i = false;
        String face = "Arial";
        if (textprops.get("b") != null) {
            b = "1".equals((String)textprops.get("b"));
        }
        if (textprops.get("i") != null) {
            i = "1".equals((String)textprops.get("i"));
        }
        if (textprops.get("latin_typeface") != null) {
            face = (String)textprops.get("latin_typeface");
        }
        if ((o = textprops.get("sz")) != null) {
            h = Font.PointsToFontHeight(Integer.parseInt((String)o) / 100);
        }
        Font f = new Font(face, w, new Float(h).intValue());
        if (b) {
            f.setBold(true);
        }
        if (i) {
            f.setItalic(i);
        }
        if (u) {
            f.setUnderlineStyle((byte)(u ? 1 : 0));
        }
        if ((o = textprops.get("vertAlign")) != null) {
            String s = (String)o;
            if (s.equals("baseline")) {
                f.setScript(0);
            } else if (s.equals("superscript")) {
                f.setScript(1);
            } else if (s.equals("subscript")) {
                f.setScript(2);
            }
        }
        if ((o = textprops.get("strike")) != null) {
            f.setStricken(true);
        }
        return FormatHandle.addFont(f, wb);
    }
}

