/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

class CustomFilter
implements OOXMLElement {
    private static final long serialVersionUID = 7995078604042667255L;
    private HashMap<String, String> attrs = null;

    public CustomFilter(HashMap<String, String> attrs) {
        this.attrs = attrs;
    }

    public CustomFilter(CustomFilter c) {
        this.attrs = c.attrs;
    }

    public static CustomFilter parseOOXML(XmlPullParser xpp) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("customFilter")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                            ++i;
                        }
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("customFilter")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("customFilter.parseOOXML: " + e.toString());
        }
        CustomFilter c = new CustomFilter(attrs);
        return c;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<customFilter");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append("/>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new CustomFilter(this);
    }
}

