/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.CustomFilter;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import org.xmlpull.v1.XmlPullParser;

class CustomFilters
implements OOXMLElement {
    private static final long serialVersionUID = -2491942158519963335L;
    private boolean and = false;
    private CustomFilter[] custfilter = null;

    public CustomFilters(boolean and, CustomFilter[] custfilter) {
        this.and = and;
        this.custfilter = custfilter;
    }

    public CustomFilters(CustomFilters c) {
        this.and = c.and;
        this.custfilter = c.custfilter;
    }

    public static CustomFilters parseOOXML(XmlPullParser xpp) {
        boolean and = false;
        CustomFilter[] custfilter = new CustomFilter[2];
        int idx = 0;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("customFilters")) {
                        if (xpp.getAttributeCount() == 1) {
                            and = xpp.getAttributeValue(0).equals("1");
                        }
                    } else if (tnm.equals("customFilter")) {
                        custfilter[idx++] = CustomFilter.parseOOXML(xpp);
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("customFilters")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("customFilters.parseOOXML: " + e.toString());
        }
        CustomFilters c = new CustomFilters(and, custfilter);
        return c;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<customFilters");
        if (this.and) {
            ooxml.append(" and=\"1\"");
        }
        ooxml.append(">");
        if (this.custfilter != null) {
            if (this.custfilter[0] != null) {
                ooxml.append(this.custfilter[0].getOOXML());
            }
            if (this.custfilter[1] != null) {
                ooxml.append(this.custfilter[1].getOOXML());
            }
        }
        ooxml.append("</customFilters>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new CustomFilters(this);
    }
}

