/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.Pos;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class Cxn
implements OOXMLElement {
    private static final long serialVersionUID = -4193511102420582252L;
    private HashMap<String, String> attrs;
    private Pos pos = null;

    public Cxn(HashMap<String, String> attrs, Pos p) {
        this.attrs = attrs;
        this.pos = p;
    }

    public Cxn(Cxn c) {
        this.attrs = c.attrs;
        this.pos = c.pos;
    }

    public static Cxn parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        Pos p = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block8: {
                    String endTag;
                    block6: {
                        String tnm;
                        block7: {
                            if (eventType != 2) break block6;
                            tnm = xpp.getName();
                            if (!tnm.equals("cxn")) break block7;
                            int i = 0;
                            while (i < xpp.getAttributeCount()) {
                                attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                                ++i;
                            }
                            break block8;
                        }
                        if (!tnm.equals("pos")) break block8;
                        lastTag.push(tnm);
                        p = Pos.parseOOXML(xpp, lastTag);
                        break block8;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("cxn")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("cxn.parseOOXML: " + e.toString());
        }
        Cxn c = new Cxn(attrs, p);
        return c;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:cxn");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append(">");
        if (this.pos != null) {
            ooxml.append(this.pos.getOOXML());
        }
        ooxml.append("</a:cxn>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Cxn(this);
    }
}

