/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.NvCxnSpPr;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.formats.OOXML.Style;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class CxnSp
implements OOXMLElement {
    private static final long serialVersionUID = -8492664135843926551L;
    private HashMap<String, String> attrs = new HashMap();
    private NvCxnSpPr nvc;
    private SpPr spPr;
    private Style style;

    public CxnSp(HashMap<String, String> attrs, NvCxnSpPr nvc, SpPr sp, Style s) {
        this.attrs = attrs;
        this.nvc = nvc;
        this.spPr = sp;
        this.style = s;
    }

    public CxnSp(CxnSp c) {
        this.attrs = c.attrs;
        this.nvc = c.nvc;
        this.spPr = c.spPr;
        this.style = c.style;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        NvCxnSpPr nvc = null;
        SpPr sp = null;
        Style s = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block8: {
                    String endTag;
                    block6: {
                        String tnm;
                        block10: {
                            block9: {
                                block7: {
                                    if (eventType != 2) break block6;
                                    tnm = xpp.getName();
                                    if (!tnm.equals("cxnSp")) break block7;
                                    int i = 0;
                                    while (i < xpp.getAttributeCount()) {
                                        attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                                        ++i;
                                    }
                                    break block8;
                                }
                                if (!tnm.equals("nvCxnSpPr")) break block9;
                                lastTag.push(tnm);
                                nvc = NvCxnSpPr.parseOOXML(xpp, lastTag);
                                break block8;
                            }
                            if (!tnm.equals("spPr")) break block10;
                            lastTag.push(tnm);
                            sp = (SpPr)SpPr.parseOOXML(xpp, lastTag, bk);
                            break block8;
                        }
                        if (!tnm.equals("style")) break block8;
                        lastTag.push(tnm);
                        s = (Style)Style.parseOOXML(xpp, lastTag, bk);
                        break block8;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("cxnSp")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("cxnSp.parseOOXML: " + e.toString());
        }
        CxnSp c = new CxnSp(attrs, nvc, sp, s);
        return c;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<xdr:cxnSp");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append(">");
        if (this.nvc != null) {
            ooxml.append(this.nvc.getOOXML());
        }
        if (this.spPr != null) {
            ooxml.append(this.spPr.getOOXML());
        }
        if (this.style != null) {
            ooxml.append(this.style.getOOXML());
        }
        ooxml.append("</xdr:cxnSp>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new CxnSp(this);
    }

    public String getName() {
        if (this.nvc != null) {
            return this.nvc.getName();
        }
        return null;
    }

    public void setName(String name) {
        if (this.nvc != null) {
            this.nvc.setName(name);
        }
    }

    public String getDescr() {
        if (this.nvc != null) {
            return this.nvc.getDescr();
        }
        return null;
    }

    public void setDescr(String descr) {
        if (this.nvc != null) {
            this.nvc.setDescr(descr);
        }
    }

    public String getMacro() {
        if (this.attrs.get("macro") != null) {
            return this.attrs.get("macro");
        }
        return null;
    }

    public void setMacro(String macro) {
        this.attrs.put("macro", macro);
    }

    public void setId(int id) {
        if (this.nvc != null) {
            this.nvc.setId(id);
        }
    }

    public int getId() {
        if (this.nvc != null) {
            return this.nvc.getId();
        }
        return -1;
    }

    public String getEmbed() {
        if (this.spPr != null) {
            return this.spPr.getEmbed();
        }
        return null;
    }

    public String getLink() {
        if (this.spPr != null) {
            return this.spPr.getLink();
        }
        return null;
    }

    public void setEmbed(String embed) {
        if (this.spPr != null) {
            this.spPr.setEmbed(embed);
        }
    }

    public void setLink(String link) {
        if (this.spPr != null) {
            this.spPr.setLink(link);
        }
    }
}

