/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.Marker;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class DPt
implements OOXMLElement {
    private static final long serialVersionUID = 8354707071603571747L;
    private int idx;
    private boolean invertIfNegative;
    private boolean bubble3D;
    private Marker marker;
    private SpPr spPr;
    private int explosion;

    public DPt(int idx, boolean invertIfNegative, boolean bubble3D, Marker m, SpPr sp, int explosion) {
        this.idx = idx;
        this.invertIfNegative = invertIfNegative;
        this.bubble3D = bubble3D;
        this.marker = m;
        this.spPr = sp;
        this.explosion = explosion;
    }

    public DPt(DPt d) {
        this.idx = d.idx;
        this.invertIfNegative = d.invertIfNegative;
        this.bubble3D = d.bubble3D;
        this.marker = d.marker;
        this.spPr = d.spPr;
        this.explosion = d.explosion;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        int idx = -1;
        boolean invertIfNegative = true;
        boolean bubble3D = true;
        Marker m = null;
        SpPr sp = null;
        int explosion = 0;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block11: {
                    String endTag;
                    block9: {
                        String tnm;
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block10: {
                                            if (eventType != 2) break block9;
                                            tnm = xpp.getName();
                                            if (!tnm.equals("idx")) break block10;
                                            if (xpp.getAttributeCount() > 0) {
                                                idx = Integer.valueOf(xpp.getAttributeValue(0));
                                            }
                                            break block11;
                                        }
                                        if (!tnm.equals("invertIfNegative")) break block12;
                                        if (xpp.getAttributeCount() > 0) {
                                            invertIfNegative = xpp.getAttributeValue(0).equals("1");
                                        }
                                        break block11;
                                    }
                                    if (!tnm.equals("bubble3D")) break block13;
                                    if (xpp.getAttributeCount() > 0) {
                                        bubble3D = xpp.getAttributeValue(0).equals("1");
                                    }
                                    break block11;
                                }
                                if (!tnm.equals("explosion")) break block14;
                                if (xpp.getAttributeCount() > 0) {
                                    explosion = Integer.valueOf(xpp.getAttributeValue(0));
                                }
                                break block11;
                            }
                            if (!tnm.equals("spPr")) break block15;
                            lastTag.push(tnm);
                            sp = (SpPr)SpPr.parseOOXML(xpp, lastTag, bk);
                            break block11;
                        }
                        if (!tnm.equals("marker")) break block11;
                        lastTag.push(tnm);
                        m = (Marker)Marker.parseOOXML(xpp, lastTag, bk);
                        break block11;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("dPt")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("dPt.parseOOXML: " + e.toString());
        }
        DPt oe = new DPt(idx, invertIfNegative, bubble3D, m, sp, explosion);
        return oe;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<c:dPt>");
        ooxml.append("<c:idx val=\"" + this.idx + "\"/>");
        if (!this.invertIfNegative) {
            ooxml.append("<c:invertIfNegative val=\"0\"/>");
        }
        if (this.marker != null) {
            ooxml.append(this.marker.getOOXML());
        }
        if (!this.bubble3D) {
            ooxml.append("<c:bubble3D val=\"0\"/>");
        }
        if (this.explosion != 0) {
            ooxml.append("<c:explosion val=\"" + this.explosion + "\"/>");
        }
        if (this.spPr != null) {
            ooxml.append(this.spPr.getOOXML());
        }
        ooxml.append("</c:dPt>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new DPt(this);
    }
}

