/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.ColorChoice;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class FgClr
implements OOXMLElement {
    private static final long serialVersionUID = 6836994790529289731L;
    private ColorChoice colorChoice;

    public FgClr(ColorChoice c) {
        this.colorChoice = c;
    }

    public FgClr(FgClr s) {
        this.colorChoice = s.colorChoice;
    }

    public static FgClr parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        ColorChoice c = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("hslClr") || tnm.equals("prstClr") || tnm.equals("schemeClr") || tnm.equals("scrgbClr") || tnm.equals("srgbClr") || tnm.equals("sysClr")) {
                        lastTag.push(tnm);
                        c = (ColorChoice)ColorChoice.parseOOXML(xpp, lastTag, bk);
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("fgClr")) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("fgClr.parseOOXML: " + e.toString());
        }
        FgClr s = new FgClr(c);
        return s;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:fgClr>");
        if (this.colorChoice != null) {
            ooxml.append(this.colorChoice.getOOXML());
        }
        ooxml.append("</a:fgClr>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new FgClr(this);
    }
}

