/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.GradientFill;
import com.extentech.formats.OOXML.OOXMLConstants;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.PatternFill;
import com.extentech.formats.OOXML.Theme;
import com.extentech.formats.XLS.Xf;
import com.extentech.toolkit.Logger;
import org.xmlpull.v1.XmlPullParser;

public class Fill
implements OOXMLElement {
    private static final long serialVersionUID = -4510508531435037641L;
    private PatternFill patternFill = null;
    private GradientFill gradientFill = null;
    private Theme theme = null;

    public Fill(PatternFill p, GradientFill g, Theme t) {
        this.patternFill = p;
        this.gradientFill = g;
        this.theme = t;
    }

    public Fill(Fill f) {
        if (f.patternFill != null) {
            this.patternFill = (PatternFill)f.patternFill.cloneElement();
        }
        if (f.gradientFill != null) {
            this.gradientFill = (GradientFill)f.gradientFill.cloneElement();
        }
        this.theme = f.theme;
    }

    public Fill(String fs, int fg, int bg, Theme t) {
        this.patternFill = new PatternFill(fs, fg, bg);
        this.theme = t;
    }

    public Fill(int pattern, int fg, String fgColorCustom, int bg, String bgColorCustom, Theme t) {
        this.patternFill = new PatternFill(PatternFill.translateIndexedFillPattern(pattern), fg, fgColorCustom, bg, bgColorCustom);
        this.theme = t;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, boolean isDxf, WorkBookHandle bk) {
        PatternFill p = null;
        GradientFill g = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("patternFill")) {
                        p = PatternFill.parseOOXML(xpp, isDxf, bk);
                    } else if (tnm.equals("gradientFill")) {
                        g = GradientFill.parseOOXML(xpp, bk);
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("fill")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("fill.parseOOXML: " + e.toString());
        }
        Fill oe = new Fill(p, g, bk.getWorkBook().getTheme());
        return oe;
    }

    protected static String transformToWebRGBColor(String rgbcolor) {
        if (rgbcolor.indexOf("#") == 0) {
            return rgbcolor;
        }
        if (rgbcolor.indexOf("FF") == 0 && rgbcolor.length() == 8) {
            return "#" + rgbcolor.substring(2, rgbcolor.length());
        }
        return "#" + rgbcolor;
    }

    protected static String transformToOOXMLRGBColor(String rgbcolor) {
        if (rgbcolor.indexOf("#") == 0) {
            return "FF" + rgbcolor.substring(1, rgbcolor.length());
        }
        if (rgbcolor.indexOf("FF") == 0 && rgbcolor.length() == 8) {
            return rgbcolor;
        }
        return "FF" + rgbcolor;
    }

    @Override
    public String getOOXML() {
        return this.getOOXML(false);
    }

    public String getOOXML(boolean isDxf) {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<fill>");
        if (this.patternFill != null) {
            ooxml.append(this.patternFill.getOOXML(isDxf));
        }
        if (this.gradientFill != null) {
            ooxml.append(this.gradientFill.getOOXML());
        }
        ooxml.append("</fill>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Fill(this);
    }

    public static String getOOXML(Xf xf) {
        short bg;
        if (xf.getFill() != null) {
            return xf.getFill().getOOXML();
        }
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<fill>");
        try {
            ooxml.append("<patternFill patternType=\"" + OOXMLConstants.patternFill[xf.getFillPattern()] + "\">");
        }
        catch (IndexOutOfBoundsException e) {
            ooxml.append("<patternFill>");
        }
        short fg = xf.getForegroundColor();
        if (fg > -1 && fg != 64) {
            ooxml.append("<fgColor rgb=\"" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[fg]).substring(1) + "\"/>");
        }
        if ((bg = xf.getBackgroundColor()) > -1 && bg != 64) {
            ooxml.append("<bgColor rgb=\"" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[bg]).substring(1) + "\"/>");
        }
        ooxml.append("</patternFill>");
        ooxml.append("\r\n");
        ooxml.append("</fill>");
        ooxml.append("\r\n");
        return ooxml.toString();
    }

    public static String getOOXML(int fs, int fg, int bg) {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<fill>");
        try {
            ooxml.append("<patternFill patternType=\"" + OOXMLConstants.patternFill[fs] + "\">");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ooxml.append("<patternFill>");
        }
        if (fg > -1 && fg != 64) {
            ooxml.append("<fgColor rgb=\"" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[fg]).substring(1) + "\"/>");
            ooxml.append("\r\n");
        }
        if (bg > -1 && bg != 64) {
            ooxml.append("<bgColor rgb=\"" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[bg]).substring(1) + "\"/>");
            ooxml.append("\r\n");
        }
        ooxml.append("</patternFill>");
        ooxml.append("\r\n");
        ooxml.append("</fill>");
        ooxml.append("\r\n");
        return ooxml.toString();
    }

    public String getFgColorAsRGB(Theme t) {
        if (this.patternFill != null) {
            return this.patternFill.getFgColorAsRGB(t);
        }
        return null;
    }

    public int getFgColorAsInt(Theme t) {
        if (this.patternFill != null) {
            return this.patternFill.getFgColorAsInt(t);
        }
        return 0;
    }

    public String getBgColorAsRGB(Theme t) {
        if (this.patternFill != null) {
            return this.patternFill.getBgColorAsRGB(t);
        }
        return null;
    }

    public int getBgColorAsInt(Theme t) {
        if (this.patternFill != null) {
            return this.patternFill.getBgColorAsInt(t);
        }
        return -1;
    }

    public void setFgColor(int t) {
        if (this.patternFill != null) {
            this.patternFill.setFgColor(t);
            return;
        }
    }

    public void setFgColor(int t, String colorString) {
        if (this.patternFill != null) {
            this.patternFill.setFgColor(t, colorString);
        } else {
            this.patternFill = new PatternFill("none", t, colorString, -1, null);
        }
    }

    public void setBgColor(int t) {
        if (this.patternFill != null) {
            this.patternFill.setBgColor(t);
            return;
        }
    }

    public void setBgColor(int t, String colorString) {
        if (this.patternFill != null) {
            this.patternFill.setBgColor(t, colorString);
        } else {
            this.patternFill = new PatternFill("none", -1, null, t, colorString);
        }
    }

    public String getFillPattern() {
        if (this.patternFill != null) {
            return this.patternFill.getFillPattern();
        }
        return null;
    }

    public int getFillPatternInt() {
        if (this.patternFill != null) {
            return this.patternFill.getFillPatternInt();
        }
        return -1;
    }

    public void setFillPattern(int t) {
        if (this.patternFill != null) {
            this.patternFill.setFillPattern(t);
        }
    }

    public boolean isBackgroundSolid() {
        if (this.patternFill != null) {
            return this.patternFill.getFillPattern().equalsIgnoreCase("solid");
        }
        return false;
    }
}

