/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.ColorFilter;
import com.extentech.formats.OOXML.CustomFilters;
import com.extentech.formats.OOXML.DynamicFilter;
import com.extentech.formats.OOXML.Filters;
import com.extentech.formats.OOXML.IconFilter;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.Top10;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

class FilterColumn
implements OOXMLElement {
    private static final long serialVersionUID = 5005589034415840928L;
    private HashMap<String, String> attrs = null;
    private Object filter = null;

    public FilterColumn(HashMap<String, String> attrs, Object filter) {
        this.attrs = attrs;
        this.filter = filter;
    }

    public FilterColumn(FilterColumn f) {
        this.attrs = f.attrs;
        this.filter = f.filter;
    }

    public static FilterColumn parseOOXML(XmlPullParser xpp) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        ColorFilter filter = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("filterColumn")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                            ++i;
                        }
                    } else if (tnm.equals("colorFilter")) {
                        filter = ColorFilter.parseOOXML(xpp);
                    } else if (!(tnm.equals("customFilters") || tnm.equals("dynamicFilter") || tnm.equals("filters") || tnm.equals("iconFilter"))) {
                        tnm.equals("top10");
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("filterColumn")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("filterColumn.parseOOXML: " + e.toString());
        }
        FilterColumn f = new FilterColumn(attrs, filter);
        return f;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<filterColumn ");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append(">");
        if (this.filter instanceof ColorFilter) {
            ooxml.append(((ColorFilter)this.filter).getOOXML());
        }
        if (this.filter instanceof CustomFilters) {
            ooxml.append(((CustomFilters)this.filter).getOOXML());
        }
        if (this.filter instanceof DynamicFilter) {
            ooxml.append(((DynamicFilter)this.filter).getOOXML());
        }
        if (this.filter instanceof Filters) {
            ooxml.append(((Filters)this.filter).getOOXML());
        }
        if (this.filter instanceof IconFilter) {
            ooxml.append(((IconFilter)this.filter).getOOXML());
        }
        if (this.filter instanceof Top10) {
            ooxml.append(((Top10)this.filter).getOOXML());
        }
        ooxml.append("</filterColumn>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new FilterColumn(this);
    }
}

