/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class From
implements OOXMLElement {
    private static final long serialVersionUID = -4776435343244555855L;
    private int[] bounds;

    public From(int[] bounds) {
        this.bounds = new int[4];
        System.arraycopy(bounds, 0, this.bounds, 0, 4);
    }

    public From(From f) {
        this.bounds = f.bounds;
    }

    public static From parseOOXML(XmlPullParser xpp, Stack lastTag) {
        int[] bounds = new int[4];
        int boundsidx = 0;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block7: {
                    String endTag;
                    block5: {
                        String tnm;
                        block9: {
                            block8: {
                                block6: {
                                    if (eventType != 2) break block5;
                                    tnm = xpp.getName();
                                    if (!tnm.equals("col")) break block6;
                                    bounds[boundsidx++] = new Integer(xpp.next());
                                    break block7;
                                }
                                if (!tnm.equals("colOff")) break block8;
                                bounds[boundsidx++] = new Integer(xpp.next());
                                break block7;
                            }
                            if (!tnm.equals("row")) break block9;
                            bounds[boundsidx++] = new Integer(xpp.next());
                            break block7;
                        }
                        if (!tnm.equals("rowOff")) break block7;
                        bounds[boundsidx++] = new Integer(xpp.next());
                        break block7;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("from")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("from.parseOOXML: " + e.toString());
        }
        From f = new From(bounds);
        return f;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<xdr:from>");
        ooxml.append("<xdr:col>" + this.bounds[0] + "</xdr:col>");
        ooxml.append("<xdr:colOff>" + this.bounds[1] + "</xdr:colOff>");
        ooxml.append("<xdr:row>" + this.bounds[2] + "</xdr:row>");
        ooxml.append("<xdr:rowOff>" + this.bounds[3] + "</xdr:rowOff>");
        ooxml.append("</xdr:from>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new From(this);
    }

    public int[] getBounds() {
        if (this.bounds == null) {
            this.bounds = new int[4];
        }
        return this.bounds;
    }

    public void setBounds(int[] bounds) {
        System.arraycopy(bounds, 0, this.bounds, 0, 4);
    }
}

