/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.CustGeom;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.PrstGeom;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class GeomGroup
implements OOXMLElement {
    private static final long serialVersionUID = -7202561792070909825L;
    private PrstGeom p = null;
    private CustGeom c = null;

    public GeomGroup() {
    }

    public GeomGroup(PrstGeom p, CustGeom c) {
        this.p = p;
        this.c = c;
    }

    public GeomGroup(GeomGroup g) {
        this.p = g.p;
        this.c = g.c;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        PrstGeom p = null;
        CustGeom c = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("prstGeom")) {
                        lastTag.push(tnm);
                        p = PrstGeom.parseOOXML(xpp, lastTag);
                        lastTag.pop();
                        break;
                    }
                    if (tnm.equals("custGeom")) {
                        lastTag.push(tnm);
                        c = CustGeom.parseOOXML(xpp, lastTag);
                        lastTag.pop();
                        break;
                    }
                } else if (eventType == 3) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("GeomGroup.parseOOXML: " + e.toString());
        }
        GeomGroup g = new GeomGroup(p, c);
        return g;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        if (this.p != null) {
            ooxml.append(this.p.getOOXML());
        } else if (this.c != null) {
            ooxml.append(this.c.getOOXML());
        }
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new GeomGroup(this);
    }
}

