/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.GraphicData;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class Graphic
implements OOXMLElement {
    private static final long serialVersionUID = -7027946026352255398L;
    private GraphicData graphicData = new GraphicData();

    public Graphic() {
    }

    public Graphic(GraphicData g) {
        this.graphicData = g;
    }

    public Graphic(Graphic gr) {
        this.graphicData = gr.graphicData;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        GraphicData g = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("graphicData")) {
                        lastTag.push(tnm);
                        g = GraphicData.parseOOXML(xpp, lastTag);
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("graphic")) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("graphic.parseOOXML: " + e.toString());
        }
        Graphic gr = new Graphic(g);
        return gr;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:graphic>");
        if (this.graphicData != null) {
            ooxml.append(this.graphicData.getOOXML());
        }
        ooxml.append("</a:graphic>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Graphic(this);
    }

    public String getURI() {
        if (this.graphicData != null) {
            return this.graphicData.getURI();
        }
        return null;
    }

    public void setURI(String uri) {
        if (this.graphicData != null) {
            this.graphicData.setURI(uri);
        }
    }

    public String getChartRId() {
        if (this.graphicData != null) {
            return this.graphicData.getChartRId();
        }
        return null;
    }

    public void setChartRId(String rid) {
        if (this.graphicData != null) {
            this.graphicData.setChartRId(rid);
        }
    }
}

