/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.ManualLayout;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public final class Layout
implements OOXMLElement {
    private static final long serialVersionUID = -6547994902298821138L;
    private ManualLayout ml;

    private Layout(ManualLayout ml) {
        this.ml = ml;
    }

    private Layout(Layout l) {
        this.ml = l.ml;
    }

    public Layout(String target, double[] offs) {
        String[] stringArray = new String[4];
        stringArray[0] = "edge";
        stringArray[1] = "edge";
        String[] modes = stringArray;
        String[] soffs = new String[4];
        int i = 0;
        while (i < 4) {
            if (offs[i] > 0.0) {
                soffs[i] = String.valueOf(offs[i]);
            }
            ++i;
        }
        this.ml = new ManualLayout(target, modes, soffs);
    }

    public float[] getCoords() {
        float[] coords = new float[4];
        int i = 0;
        while (i < 4) {
            if (this.ml.offs[i] != null) {
                coords[i] = new Float(this.ml.offs[i]).floatValue();
            }
            ++i;
        }
        return coords;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        ManualLayout ml = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("manualLayout")) {
                        lastTag.push(tnm);
                        ml = ManualLayout.parseOOXML(xpp, lastTag);
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("layout")) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("layout.parseOOXML: " + e.toString());
        }
        Layout l = new Layout(ml);
        return l;
    }

    @Override
    public String getOOXML() {
        StringBuffer looxml = new StringBuffer();
        if (this.ml != null) {
            looxml.append("<c:layout>");
            looxml.append(this.ml.getOOXML());
            looxml.append("</c:layout>");
        } else {
            looxml.append("<c:layout/>");
        }
        return looxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Layout(this);
    }

    public static String getOOXML(double[] offs) {
        StringBuffer looxml = new StringBuffer();
        looxml.append("<c:layout>");
        looxml.append("<c:manualLayout>");
        looxml.append("<c:layoutTarget val=\"inner\"/>");
        looxml.append("<c:xMode val=\"edge\"/>");
        looxml.append("<c:yMode val=\"edge\"/>");
        looxml.append("<c:x val=\"" + offs[0] + "\"/>");
        looxml.append("<c:y val=\"" + offs[1] + "\"/>");
        looxml.append("<c:w val=\"" + offs[2] + "\"/>");
        looxml.append("<c:h val=\"" + offs[3] + "\"/>");
        looxml.append("</c:manualLayout>");
        looxml.append("</c:layout>");
        return looxml.toString();
    }
}

