/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.TxPr;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class LegendEntry
implements OOXMLElement {
    private static final long serialVersionUID = 1859347855337611982L;
    private TxPr tx;
    private int idx = -1;
    private boolean delete;

    public LegendEntry(int idx, boolean d, TxPr tx) {
        this.idx = idx;
        this.delete = d;
        this.tx = tx;
    }

    public LegendEntry(LegendEntry le) {
        this.idx = le.idx;
        this.delete = le.delete;
        this.tx = le.tx;
    }

    public static LegendEntry parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        TxPr tx = null;
        int idx = -1;
        boolean delete = true;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block7: {
                    String endTag;
                    block5: {
                        String tnm;
                        block8: {
                            block6: {
                                if (eventType != 2) break block5;
                                tnm = xpp.getName();
                                if (!tnm.equals("idx")) break block6;
                                idx = Integer.valueOf(xpp.getAttributeValue(0));
                                break block7;
                            }
                            if (!tnm.equals("delete")) break block8;
                            delete = Boolean.valueOf(xpp.getAttributeValue(0));
                            break block7;
                        }
                        if (!tnm.equals("txPr")) break block7;
                        lastTag.push(tnm);
                        tx = (TxPr)TxPr.parseOOXML(xpp, lastTag, bk);
                        break block7;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("legendEntry")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("legendEntry.parseOOXML: " + e.toString());
        }
        LegendEntry le = new LegendEntry(idx, delete, tx);
        return le;
    }

    @Override
    public String getOOXML() {
        StringBuffer tooxml = new StringBuffer();
        tooxml.append("<c:legendEntry>");
        tooxml.append("<c:idx val=\"" + this.idx + "\"/>");
        if (!this.delete) {
            tooxml.append("<c:delete=\"" + this.delete + "\">");
        }
        if (this.tx != null) {
            tooxml.append(this.tx.getOOXML());
        }
        tooxml.append("</c:legendEntry>");
        return tooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new LegendEntry(this);
    }
}

