/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public final class Marker
implements OOXMLElement {
    private static final long serialVersionUID = -5070227633357072878L;
    private SpPr sp;
    private String size;
    private String symbol;

    public Marker(String s, String sz, SpPr sp) {
        this.symbol = s;
        this.size = sz;
        this.sp = sp;
    }

    public Marker(Marker m) {
        this.symbol = m.symbol;
        this.size = m.size;
        this.sp = m.sp;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        SpPr sp = null;
        String size = null;
        String symbol = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block7: {
                    String endTag;
                    block5: {
                        String tnm;
                        block8: {
                            block6: {
                                if (eventType != 2) break block5;
                                tnm = xpp.getName();
                                if (!tnm.equals("symbol")) break block6;
                                symbol = xpp.getAttributeValue(0);
                                break block7;
                            }
                            if (!tnm.equals("size")) break block8;
                            size = xpp.getAttributeValue(0);
                            break block7;
                        }
                        if (!tnm.equals("spPr")) break block7;
                        lastTag.push(tnm);
                        sp = (SpPr)SpPr.parseOOXML(xpp, lastTag, bk);
                        break block7;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("marker")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("marker.parseOOXML: " + e.toString());
        }
        Marker m = new Marker(symbol, size, sp);
        return m;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<c:marker>");
        if (this.symbol != null) {
            ooxml.append("<c:symbol val=\"" + this.symbol + "\"/>");
        }
        if (this.size != null) {
            ooxml.append("<c:size val=\"" + this.size + "\"/>");
        }
        if (this.sp != null) {
            ooxml.append(this.sp.getOOXML());
        }
        ooxml.append("</c:marker>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Marker(this);
    }
}

