/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.Path;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class PathLst
implements OOXMLElement {
    private static final long serialVersionUID = -1996347204024728000L;
    private ArrayList<Path> path;
    private HashMap<String, String> attrs = null;

    public PathLst(HashMap<String, String> attrs, ArrayList<Path> p) {
        this.attrs = attrs;
        this.path = p;
    }

    public PathLst(PathLst pl) {
        this.attrs = pl.attrs;
        this.path = pl.path;
    }

    public static PathLst parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        ArrayList<Path> p = new ArrayList<Path>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block8: {
                    String endTag;
                    block6: {
                        String tnm;
                        block7: {
                            if (eventType != 2) break block6;
                            tnm = xpp.getName();
                            if (!tnm.equals("pathLst")) break block7;
                            int i = 0;
                            while (i < xpp.getAttributeCount()) {
                                attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                                ++i;
                            }
                            break block8;
                        }
                        if (!tnm.equals("path")) break block8;
                        lastTag.push(tnm);
                        p.add(Path.parseOOXML(xpp, lastTag));
                        break block8;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("pathLst")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("pathLst.parseOOXML: " + e.toString());
        }
        PathLst pl = new PathLst(attrs, p);
        return pl;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:pathLst");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append(">");
        if (this.path != null) {
            int i = 0;
            while (i < this.path.size()) {
                ooxml.append(this.path.get(i).getOOXML());
                ++i;
            }
        }
        ooxml.append("</a:pathLst>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new PathLst(this);
    }
}

